/*
 * Decompiled with CFR 0.152.
 */
package org.mongodb.morphia.converters;

import org.mongodb.morphia.converters.SimpleValueConverter;
import org.mongodb.morphia.converters.TypeConverter;
import org.mongodb.morphia.mapping.MappedField;

public class EnumConverter
extends TypeConverter
implements SimpleValueConverter {
    public Object decode(Class targetClass, Object fromDBObject, MappedField optionalExtraInfo) {
        if (fromDBObject == null) {
            return null;
        }
        return Enum.valueOf(targetClass, fromDBObject.toString());
    }

    @Override
    public Object encode(Object value, MappedField optionalExtraInfo) {
        if (value == null) {
            return null;
        }
        return this.getName((Enum)value);
    }

    protected boolean isSupported(Class c, MappedField optionalExtraInfo) {
        return c.isEnum();
    }

    private <T extends Enum> String getName(T value) {
        return value.name();
    }
}

