/*
 * Decompiled with CFR 0.152.
 */
package org.mongodb.morphia.aggregation;

import com.mongodb.AggregationOptions;
import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.Cursor;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import com.mongodb.ReadPreference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.mongodb.morphia.DatastoreImpl;
import org.mongodb.morphia.aggregation.AggregationPipeline;
import org.mongodb.morphia.aggregation.GeoNear;
import org.mongodb.morphia.aggregation.Group;
import org.mongodb.morphia.aggregation.Projection;
import org.mongodb.morphia.geo.GeometryShapeConverter;
import org.mongodb.morphia.logging.Logger;
import org.mongodb.morphia.logging.MorphiaLoggerFactory;
import org.mongodb.morphia.mapping.MappedField;
import org.mongodb.morphia.mapping.Mapper;
import org.mongodb.morphia.query.MorphiaIterator;
import org.mongodb.morphia.query.Query;
import org.mongodb.morphia.query.Sort;

public class AggregationPipelineImpl
implements AggregationPipeline {
    private static final Logger LOG = MorphiaLoggerFactory.get(AggregationPipelineImpl.class);
    private final DBCollection collection;
    private final Class source;
    private final List<DBObject> stages = new ArrayList<DBObject>();
    private final Mapper mapper;
    private final DatastoreImpl datastore;
    private boolean firstStage = false;

    public AggregationPipelineImpl(DatastoreImpl datastore, DBCollection collection, Class source) {
        this.datastore = datastore;
        this.collection = collection;
        this.mapper = datastore.getMapper();
        this.source = source;
    }

    public List<DBObject> getStages() {
        return this.stages;
    }

    @Override
    public <U> Iterator<U> aggregate(Class<U> target) {
        return this.aggregate(target, AggregationOptions.builder().build(), this.collection.getReadPreference());
    }

    @Override
    public <U> Iterator<U> aggregate(Class<U> target, AggregationOptions options) {
        return this.aggregate(target, options, this.collection.getReadPreference());
    }

    @Override
    public <U> Iterator<U> aggregate(Class<U> target, AggregationOptions options, ReadPreference readPreference) {
        return this.aggregate(this.datastore.getCollection((Class)target).getName(), target, options, readPreference);
    }

    @Override
    public <U> Iterator<U> aggregate(String collectionName, Class<U> target, AggregationOptions options, ReadPreference readPreference) {
        LOG.debug("stages = " + this.stages);
        Cursor cursor = this.collection.aggregate(this.stages, options, readPreference);
        return new MorphiaIterator(this.datastore, cursor, this.mapper, target, collectionName, this.mapper.createEntityCache());
    }

    @Override
    public AggregationPipeline geoNear(GeoNear geoNear) {
        BasicDBObject geo = new BasicDBObject();
        GeometryShapeConverter.PointConverter pointConverter = new GeometryShapeConverter.PointConverter();
        pointConverter.setMapper(this.mapper);
        this.putIfNull(geo, "near", geoNear.getNearAsDBObject(pointConverter));
        this.putIfNull(geo, "distanceField", geoNear.getDistanceField());
        this.putIfNull(geo, "limit", geoNear.getLimit());
        this.putIfNull(geo, "num", geoNear.getMaxDocuments());
        this.putIfNull(geo, "maxDistance", geoNear.getMaxDistance());
        if (geoNear.getQuery() != null) {
            geo.put("query", geoNear.getQuery().getQueryObject());
        }
        this.putIfNull(geo, "spherical", geoNear.getSpherical());
        this.putIfNull(geo, "distanceMultiplier", geoNear.getDistanceMultiplier());
        this.putIfNull(geo, "includeLocs", geoNear.getIncludeLocations());
        this.putIfNull(geo, "uniqueDocs", geoNear.getUniqueDocuments());
        this.stages.add(new BasicDBObject("$geoNear", geo));
        return this;
    }

    @Override
    public AggregationPipeline group(Group ... groupings) {
        return this.group((String)null, groupings);
    }

    @Override
    public AggregationPipeline group(String id, Group ... groupings) {
        BasicDBObject group = new BasicDBObject();
        group.put("_id", id != null ? "$" + id : null);
        for (Group grouping : groupings) {
            group.putAll(this.toDBObject(grouping));
        }
        this.stages.add(new BasicDBObject("$group", group));
        return this;
    }

    @Override
    public AggregationPipeline group(List<Group> id, Group ... groupings) {
        BasicDBObject idGroup = null;
        if (id != null) {
            idGroup = new BasicDBObject();
            for (Group group : id) {
                idGroup.putAll(this.toDBObject(group));
            }
        }
        BasicDBObject group = new BasicDBObject("_id", idGroup);
        for (Group grouping : groupings) {
            group.putAll(this.toDBObject(grouping));
        }
        this.stages.add(new BasicDBObject("$group", group));
        return this;
    }

    @Override
    public AggregationPipeline limit(int count) {
        this.stages.add(new BasicDBObject("$limit", (Object)count));
        return this;
    }

    @Override
    public AggregationPipeline lookup(String from, String localField, String foreignField, String as) {
        this.stages.add(new BasicDBObject("$lookup", new BasicDBObject("from", from).append("localField", localField).append("foreignField", foreignField).append("as", as)));
        return this;
    }

    @Override
    public AggregationPipeline match(Query query) {
        this.stages.add(new BasicDBObject("$match", query.getQueryObject()));
        return this;
    }

    @Override
    public <U> Iterator<U> out(Class<U> target) {
        return this.out(this.datastore.getCollection((Class)target).getName(), target);
    }

    @Override
    public <U> Iterator<U> out(Class<U> target, AggregationOptions options) {
        return this.out(this.datastore.getCollection((Class)target).getName(), target, options);
    }

    @Override
    public <U> Iterator<U> out(String collectionName, Class<U> target) {
        return this.out(collectionName, target, AggregationOptions.builder().build());
    }

    @Override
    public <U> Iterator<U> out(String collectionName, Class<U> target, AggregationOptions options) {
        this.stages.add(new BasicDBObject("$out", collectionName));
        return this.aggregate(target, options);
    }

    @Override
    public AggregationPipeline project(Projection ... projections) {
        this.firstStage = this.stages.isEmpty();
        BasicDBObject dbObject = new BasicDBObject();
        for (Projection projection : projections) {
            dbObject.putAll(this.toDBObject(projection));
        }
        this.stages.add(new BasicDBObject("$project", dbObject));
        return this;
    }

    @Override
    public AggregationPipeline skip(int count) {
        this.stages.add(new BasicDBObject("$skip", (Object)count));
        return this;
    }

    @Override
    public AggregationPipeline sort(Sort ... sorts) {
        BasicDBObject sortList = new BasicDBObject();
        for (Sort sort : sorts) {
            sortList.put(sort.getField(), (Object)sort.getOrder());
        }
        this.stages.add(new BasicDBObject("$sort", sortList));
        return this;
    }

    @Override
    public AggregationPipeline unwind(String field) {
        this.stages.add(new BasicDBObject("$unwind", "$" + field));
        return this;
    }

    private DBObject toDBObject(Projection projection) {
        MappedField field;
        String target = this.firstStage ? ((field = this.mapper.getMappedClass(this.source).getMappedField(projection.getTarget())) != null ? field.getNameToStore() : projection.getTarget()) : projection.getTarget();
        if (projection.getProjections() != null) {
            List<Projection> list = projection.getProjections();
            BasicDBObject projections = new BasicDBObject();
            for (Projection subProjection : list) {
                projections.putAll(this.toDBObject(subProjection));
            }
            return new BasicDBObject(target, projections);
        }
        if (projection.getSource() != null) {
            return new BasicDBObject(target, projection.getSource());
        }
        if (projection.getArguments() != null) {
            if (target == null) {
                return this.toExpressionArgs(projection.getArguments());
            }
            return new BasicDBObject(target, this.toExpressionArgs(projection.getArguments()));
        }
        return new BasicDBObject(target, (Object)(projection.isSuppressed() ? 0 : 1));
    }

    private DBObject toDBObject(Group group) {
        BasicDBObject dbObject = new BasicDBObject();
        if (group.getAccumulator() != null) {
            dbObject.put(group.getName(), group.getAccumulator().toDBObject());
        } else if (group.getProjections() != null) {
            BasicDBObject projection = new BasicDBObject();
            for (Projection p : group.getProjections()) {
                projection.putAll(this.toDBObject(p));
            }
            dbObject.put(group.getName(), projection);
        } else if (group.getNested() != null) {
            dbObject.put(group.getName(), this.toDBObject(group.getNested()));
        } else {
            dbObject.put(group.getName(), group.getSourceField());
        }
        return dbObject;
    }

    private void putIfNull(DBObject dbObject, String name, Object value) {
        if (value != null) {
            dbObject.put(name, value);
        }
    }

    private DBObject toExpressionArgs(List<Object> args) {
        BasicDBList result = new BasicDBList();
        for (Object arg : args) {
            if (arg instanceof Projection) {
                Projection projection = (Projection)arg;
                if (projection.getArguments() != null || projection.getProjections() != null || projection.getSource() != null) {
                    result.add(this.toDBObject(projection));
                    continue;
                }
                result.add("$" + projection.getTarget());
                continue;
            }
            result.add(arg);
        }
        return result.size() == 1 ? (DBObject)result.get(0) : result;
    }

    public String toString() {
        return this.stages.toString();
    }
}

