/*
 * Decompiled with CFR 0.152.
 */
package org.mongodb.morphia;

import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.bson.BsonDocument;
import org.bson.BsonDocumentWriter;
import org.bson.Document;
import org.bson.codecs.EncoderContext;
import org.mongodb.morphia.AnnotationBuilder;
import org.mongodb.morphia.FieldBuilder;
import org.mongodb.morphia.IndexBuilder;
import org.mongodb.morphia.IndexOptionsBuilder;
import org.mongodb.morphia.annotations.Collation;
import org.mongodb.morphia.annotations.Field;
import org.mongodb.morphia.annotations.Index;
import org.mongodb.morphia.annotations.IndexOptions;
import org.mongodb.morphia.annotations.Indexed;
import org.mongodb.morphia.annotations.Indexes;
import org.mongodb.morphia.annotations.NotSaved;
import org.mongodb.morphia.annotations.Reference;
import org.mongodb.morphia.annotations.Serialized;
import org.mongodb.morphia.annotations.Text;
import org.mongodb.morphia.logging.Logger;
import org.mongodb.morphia.logging.MorphiaLoggerFactory;
import org.mongodb.morphia.mapping.MappedClass;
import org.mongodb.morphia.mapping.MappedField;
import org.mongodb.morphia.mapping.Mapper;
import org.mongodb.morphia.mapping.MappingException;
import org.mongodb.morphia.utils.IndexType;

final class IndexHelper {
    private static final Logger LOG = MorphiaLoggerFactory.get(IndexHelper.class);
    private static final EncoderContext ENCODER_CONTEXT = EncoderContext.builder().build();
    private final Mapper mapper;
    private final MongoDatabase database;

    IndexHelper(Mapper mapper, MongoDatabase database) {
        this.mapper = mapper;
        this.database = database;
    }

    private static String join(List<String> path, char delimiter) {
        StringBuilder builder = new StringBuilder();
        for (String element : path) {
            if (builder.length() != 0) {
                builder.append(delimiter);
            }
            builder.append(element);
        }
        return builder.toString();
    }

    private void calculateWeights(Index index, com.mongodb.client.model.IndexOptions indexOptions) {
        Document weights = new Document();
        for (Field field : index.fields()) {
            if (field.weight() == -1) continue;
            if (field.type() != IndexType.TEXT) {
                throw new MappingException("Weight values only apply to text indexes: " + Arrays.toString(index.fields()));
            }
            weights.put(field.value(), (Object)field.weight());
        }
        if (!weights.isEmpty()) {
            indexOptions.weights(weights);
        }
    }

    Index convert(Text text, String nameToStore) {
        return new IndexBuilder().options(text.options()).fields(Collections.singletonList(new FieldBuilder().value(nameToStore).type(IndexType.TEXT).weight(text.value())));
    }

    Index convert(Indexed indexed, String nameToStore) {
        if (indexed.dropDups() || indexed.options().dropDups()) {
            LOG.warning("Support for dropDups has been removed from the server.  Please remove this setting.");
        }
        Map<String, Object> newOptions = this.extractOptions(indexed.options());
        if (!this.extractOptions(indexed).isEmpty() && !newOptions.isEmpty()) {
            throw new MappingException("Mixed usage of deprecated @Indexed values with the new @IndexOption values is not allowed.  Please migrate all settings to @IndexOptions");
        }
        List<Field> fields = Collections.singletonList(new FieldBuilder().value(nameToStore).type(IndexType.fromValue(indexed.value().toIndexValue())));
        return newOptions.isEmpty() ? new IndexBuilder().options(new IndexOptionsBuilder().migrate(indexed)).fields(fields) : new IndexBuilder().options(indexed.options()).fields(fields);
    }

    private List<Index> collectFieldIndexes(MappedClass mc) {
        ArrayList<Index> list = new ArrayList<Index>();
        for (MappedField mf : mc.getPersistenceFields()) {
            if (mf.hasAnnotation(Indexed.class)) {
                Indexed indexed = mf.getAnnotation(Indexed.class);
                list.add(this.convert(indexed, mf.getNameToStore()));
                continue;
            }
            if (!mf.hasAnnotation(Text.class)) continue;
            Text text = mf.getAnnotation(Text.class);
            list.add(this.convert(text, mf.getNameToStore()));
        }
        return list;
    }

    private List<Index> collectIndexes(MappedClass mc, List<MappedClass> parentMCs) {
        if (parentMCs.contains(mc) || mc.getEmbeddedAnnotation() != null && parentMCs.isEmpty()) {
            return Collections.emptyList();
        }
        List<Index> indexes = this.collectTopLevelIndexes(mc);
        indexes.addAll(this.collectFieldIndexes(mc));
        indexes.addAll(this.collectNestedIndexes(mc, parentMCs));
        return indexes;
    }

    private List<Index> collectNestedIndexes(MappedClass mc, List<MappedClass> parentMCs) {
        ArrayList<Index> list = new ArrayList<Index>();
        for (MappedField mf : mc.getPersistenceFields()) {
            if (mf.isTypeMongoCompatible() || mf.hasAnnotation(Reference.class) || mf.hasAnnotation(Serialized.class) || mf.hasAnnotation(NotSaved.class) || mf.isTransient()) continue;
            ArrayList<MappedClass> parents = new ArrayList<MappedClass>(parentMCs);
            parents.add(mc);
            ArrayList<MappedClass> classes = new ArrayList<MappedClass>();
            MappedClass mappedClass = this.mapper.getMappedClass(mf.isSingleValue() ? mf.getType() : mf.getSubClass());
            classes.add(mappedClass);
            classes.addAll(this.mapper.getSubTypes(mappedClass));
            for (MappedClass aClass : classes) {
                for (Index index : this.collectIndexes(aClass, parents)) {
                    ArrayList<Field> fields = new ArrayList<Field>();
                    for (Field field : index.fields()) {
                        fields.add(new FieldBuilder().value(field.value().equals("$**") ? field.value() : mf.getNameToStore() + "." + field.value()).type(field.type()).weight(field.weight()));
                    }
                    list.add(new IndexBuilder(index).fields(fields));
                }
            }
        }
        return list;
    }

    private List<Index> collectTopLevelIndexes(MappedClass mc) {
        ArrayList<Index> list = new ArrayList<Index>();
        if (mc != null) {
            List annotations = mc.getAnnotations(Indexes.class);
            if (annotations != null) {
                for (Indexes indexes : annotations) {
                    Index[] indexArray = indexes.value();
                    int n = indexArray.length;
                    for (int i = 0; i < n; ++i) {
                        Index index;
                        Index updated = index = indexArray[i];
                        if (index.fields().length == 0) {
                            LOG.warning(String.format("This index on '%s' is using deprecated configuration options.  Please update to use the fields value on @Index: %s", mc.getClazz().getName(), index.toString()));
                            updated = new IndexBuilder().migrate(index);
                        }
                        ArrayList<Field> fields = new ArrayList<Field>();
                        for (Field field : updated.fields()) {
                            fields.add(new FieldBuilder().value(this.findField(mc, index.options(), Arrays.asList(field.value().split("\\.")))).type(field.type()).weight(field.weight()));
                        }
                        list.add(this.replaceFields(updated, fields));
                    }
                }
            }
            list.addAll(this.collectTopLevelIndexes(mc.getSuperClass()));
        }
        return list;
    }

    private Map<String, Object> extractOptions(IndexOptions options) {
        return AnnotationBuilder.toMap(options);
    }

    private Map<String, Object> extractOptions(Indexed indexed) {
        Map<String, Object> map = AnnotationBuilder.toMap(indexed);
        if (indexed.options().collation().locale().equals("")) {
            map.remove("options");
        }
        map.remove("value");
        return map;
    }

    private MappingException pathFail(MappedClass mc, List<String> path) {
        return new MappingException(String.format("Could not resolve path '%s' against '%s'.", IndexHelper.join(path, '.'), mc.getClazz().getName()));
    }

    private Index replaceFields(Index original, List<Field> list) {
        return new IndexBuilder(original).fields(list);
    }

    private BsonDocument toBsonDocument(String key, Object value) {
        BsonDocumentWriter writer = new BsonDocumentWriter(new BsonDocument());
        writer.writeStartDocument();
        writer.writeName(key);
        this.database.getCodecRegistry().get(value.getClass()).encode(writer, value, ENCODER_CONTEXT);
        writer.writeEndDocument();
        return writer.getDocument();
    }

    BsonDocument calculateKeys(MappedClass mc, Index index) {
        BsonDocument keys = new BsonDocument();
        for (Field field : index.fields()) {
            String path;
            try {
                path = this.findField(mc, index.options(), new ArrayList<String>(Arrays.asList(field.value().split("\\."))));
            }
            catch (Exception e) {
                path = field.value();
                String message = String.format("The path '%s' can not be validated against '%s' and may represent an invalid index", path, mc.getClazz().getName());
                if (!index.options().disableValidation()) {
                    throw new MappingException(message);
                }
                LOG.warning(message);
            }
            keys.putAll(this.toBsonDocument(path, field.type().toIndexValue()));
        }
        return keys;
    }

    com.mongodb.client.model.IndexOptions convert(IndexOptions options, boolean background) {
        if (options.dropDups()) {
            LOG.warning("Support for dropDups has been removed from the server.  Please remove this setting.");
        }
        com.mongodb.client.model.IndexOptions indexOptions = new com.mongodb.client.model.IndexOptions().background(options.background() || background).sparse(options.sparse()).unique(options.unique());
        if (!options.language().equals("")) {
            indexOptions.defaultLanguage(options.language());
        }
        if (!options.languageOverride().equals("")) {
            indexOptions.languageOverride(options.languageOverride());
        }
        if (!options.name().equals("")) {
            indexOptions.name(options.name());
        }
        if (options.expireAfterSeconds() != -1) {
            indexOptions.expireAfter(Long.valueOf(options.expireAfterSeconds()), TimeUnit.SECONDS);
        }
        if (!options.partialFilter().equals("")) {
            indexOptions.partialFilterExpression(Document.parse(options.partialFilter()));
        }
        if (!options.collation().locale().equals("")) {
            indexOptions.collation(this.convert(options.collation()));
        }
        return indexOptions;
    }

    com.mongodb.client.model.Collation convert(Collation collation) {
        return com.mongodb.client.model.Collation.builder().locale(collation.locale()).backwards(collation.backwards()).caseLevel(collation.caseLevel()).collationAlternate(collation.alternate()).collationCaseFirst(collation.caseFirst()).collationMaxVariable(collation.maxVariable()).collationStrength(collation.strength()).normalization(collation.normalization()).numericOrdering(collation.numericOrdering()).build();
    }

    String findField(MappedClass mc, IndexOptions options, List<String> path) {
        String segment = path.get(0);
        if (segment.equals("$**")) {
            return segment;
        }
        MappedField mf = mc.getMappedField(segment);
        if (mf == null) {
            mf = mc.getMappedFieldByJavaField(segment);
        }
        if (mf == null && mc.isInterface()) {
            for (MappedClass mappedClass : this.mapper.getSubTypes(mc)) {
                try {
                    return this.findField(mappedClass, options, new ArrayList<String>(path));
                }
                catch (MappingException mappingException) {
                }
            }
        }
        if (mf == null) {
            if (!options.disableValidation()) {
                throw this.pathFail(mc, path);
            }
            return IndexHelper.join(path, '.');
        }
        String namePath = mf.getNameToStore();
        if (path.size() > 1) {
            try {
                Class concreteType = !mf.isSingleValue() ? mf.getSubClass() : mf.getConcreteType();
                namePath = namePath + "." + this.findField(this.mapper.getMappedClass(concreteType), options, path.subList(1, path.size()));
            }
            catch (MappingException e) {
                if (!options.disableValidation()) {
                    throw this.pathFail(mc, path);
                }
                return IndexHelper.join(path, '.');
            }
        }
        return namePath;
    }

    void createIndex(MongoCollection collection, MappedClass mc, boolean background) {
        if (!mc.isInterface() && !mc.isAbstract()) {
            for (Index index : this.collectIndexes(mc, Collections.<MappedClass>emptyList())) {
                this.createIndex(collection, mc, index, background);
            }
        }
    }

    void createIndex(MongoCollection collection, MappedClass mc, Index index, boolean background) {
        Index normalized = IndexBuilder.normalize(index);
        BsonDocument keys = this.calculateKeys(mc, normalized);
        com.mongodb.client.model.IndexOptions indexOptions = this.convert(normalized.options(), background);
        this.calculateWeights(normalized, indexOptions);
        collection.createIndex(keys, indexOptions);
    }
}

