/*
 * Decompiled with CFR 0.152.
 */
package org.mongodb.morphia;

import java.util.ArrayList;
import java.util.List;
import org.mongodb.morphia.AnnotationBuilder;
import org.mongodb.morphia.FieldBuilder;
import org.mongodb.morphia.IndexOptionsBuilder;
import org.mongodb.morphia.annotations.Field;
import org.mongodb.morphia.annotations.Index;
import org.mongodb.morphia.annotations.IndexOptions;
import org.mongodb.morphia.utils.IndexType;

class IndexBuilder
extends AnnotationBuilder<Index>
implements Index {
    IndexBuilder() {
    }

    IndexBuilder(Index original) {
        super(original);
    }

    static Index normalize(Index index) {
        return index.fields().length != 0 ? index : new IndexBuilder().migrate(index);
    }

    @Override
    public Class<Index> annotationType() {
        return Index.class;
    }

    public IndexBuilder fields(String fields) {
        return this.fields(this.parseFieldsString(fields));
    }

    @Override
    public Field[] fields() {
        return (Field[])this.get("fields");
    }

    @Override
    public IndexOptions options() {
        return (IndexOptions)this.get("options");
    }

    @Override
    public boolean background() {
        return (Boolean)this.get("background");
    }

    @Override
    public boolean disableValidation() {
        return (Boolean)this.get("disableValidation");
    }

    @Override
    public boolean dropDups() {
        return (Boolean)this.get("dropDups");
    }

    @Override
    public int expireAfterSeconds() {
        return (Integer)this.get("expireAfterSeconds");
    }

    @Override
    public String name() {
        return (String)this.get("name");
    }

    @Override
    public boolean sparse() {
        return (Boolean)this.get("sparse");
    }

    @Override
    public boolean unique() {
        return (Boolean)this.get("unique");
    }

    @Override
    public String value() {
        return (String)this.get("value");
    }

    private List<Field> parseFieldsString(String str) {
        String[] parts;
        ArrayList<Field> fields = new ArrayList<Field>();
        for (String s : parts = str.split(",")) {
            s = s.trim();
            IndexType dir = IndexType.ASC;
            if (s.startsWith("-")) {
                dir = IndexType.DESC;
                s = s.substring(1).trim();
            }
            fields.add(new FieldBuilder().value(s).type(dir));
        }
        return fields;
    }

    IndexBuilder fields(List<Field> fields) {
        this.put("fields", fields.toArray(new Field[0]));
        return this;
    }

    IndexBuilder fields(Field ... fields) {
        this.put("fields", fields);
        return this;
    }

    IndexBuilder options(IndexOptions options) {
        this.put("options", options);
        return this;
    }

    IndexBuilder background(boolean background) {
        this.put("background", background);
        return this;
    }

    IndexBuilder disableValidation(boolean disableValidation) {
        this.put("disableValidation", disableValidation);
        return this;
    }

    IndexBuilder dropDups(boolean dropDups) {
        this.put("dropDups", dropDups);
        return this;
    }

    IndexBuilder expireAfterSeconds(int expireAfterSeconds) {
        this.put("expireAfterSeconds", expireAfterSeconds);
        return this;
    }

    IndexBuilder name(String name) {
        this.put("name", name);
        return this;
    }

    IndexBuilder sparse(boolean sparse) {
        this.put("sparse", sparse);
        return this;
    }

    IndexBuilder unique(boolean unique) {
        this.put("unique", unique);
        return this;
    }

    IndexBuilder value(String value) {
        this.put("value", value);
        return this;
    }

    IndexBuilder migrate(Index index) {
        return this.fields(this.parseFieldsString(index.value())).options(new IndexOptionsBuilder().migrate(index));
    }
}

