/*
 * Decompiled with CFR 0.152.
 */
package Utility.com.parablu;

import Utility.com.parablu.MD5Generator;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientURI;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.parablu.pcbd.domain.Device;
import java.io.File;
import java.io.PrintStream;
import java.nio.ByteBuffer;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.lang.StringUtils;
import org.bson.Document;

public class OdbUniqueNamesOfDeviceUUIDs {
    public static void main(String[] args) throws ConfigurationException {
        try {
            System.out.println("##########started############");
            File file = new File("serverOutput.txt");
            if (!file.exists()) {
                file.createNewFile();
            } else {
                file.delete();
                file.createNewFile();
            }
            PrintStream o = new PrintStream(file);
            System.setOut(o);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("This will be written to the text file");
        PropertiesConfiguration config = null;
        config = new PropertiesConfiguration(args[0]);
        String mongoIP = config.getProperty("mongoIP").toString();
        String mongoPort = config.getProperty("mongoPort").toString();
        if (StringUtils.isEmpty(mongoIP)) {
            System.out.println("mongoIP or port cannot be empty in config file...Please configure and run again :)");
            throw new ArrayIndexOutOfBoundsException();
        }
        System.out.println("mongo IP:" + mongoIP);
        MongoClientURI uri = new MongoClientURI("mongodb://neil:parablu@" + mongoIP + ":" + mongoPort + "/parablu001");
        MongoClient client = new MongoClient(uri);
        MongoDatabase db = client.getDatabase(uri.getDatabase());
        System.out.println("connectivity success  ");
        MongoCollection<Document> deviceColl = db.getCollection("DEVICE");
        MongoCollection<Document> latestDeviceBkpInfoColl = db.getCollection("ODB_FOLDER_NAME_DEVICEUUID_MAPPING");
        FindIterable<Document> devices = null;
        devices = deviceColl.find();
        System.out.println("DEvice list:");
        latestDeviceBkpInfoColl.drop();
        devices.forEach(latestDevice -> {
            Device device1 = new Device();
            device1.setDeviceUUID(latestDevice.getString("deviceUUID"));
            device1.setDestCollection(latestDevice.getString("destCollection"));
            device1.setDecoupled((Boolean)latestDevice.get("decoupled"));
            device1.setDeviceName(latestDevice.getString("deviceName"));
            device1.setBlocked((Boolean)latestDevice.get("blocked"));
            device1.setUserName(latestDevice.getString("userName"));
            Document latestBkpOverviewInfo = new Document();
            latestBkpOverviewInfo.put("deviceUUID", (Object)device1.getDeviceUUID());
            latestBkpOverviewInfo.put("userName", (Object)device1.getUserName());
            String uniqueName = OdbUniqueNamesOfDeviceUUIDs.getUniqueODUserFolder(device1.getDeviceUUID());
            latestBkpOverviewInfo.put("OdbFolderName", (Object)uniqueName);
            System.out.println("DEvice uuid:" + device1.getDeviceUUID() + " Unique name:" + uniqueName);
            latestDeviceBkpInfoColl.insertOne(latestBkpOverviewInfo);
        });
        System.out.println("Script finished.....");
        System.exit(0);
    }

    private static String getUniqueODUserFolder(String deviceUUID) {
        String convertedString = "";
        if (!StringUtils.isEmpty(deviceUUID)) {
            String md5Val = MD5Generator.generateMD5OfString(deviceUUID);
            Long l = ByteBuffer.wrap(md5Val.toString().getBytes()).getLong();
            convertedString = Long.toString(l, 36);
        }
        return convertedString;
    }
}

