/*
 * Decompiled with CFR 0.152.
 */
package Utility.com.parablu;

import Utility.com.parablu.MD5Generator;
import com.mongodb.BasicDBObject;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientURI;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.parablu.pcbd.domain.BackUpImage;
import com.parablu.pcbd.domain.ChunkDetail;
import com.parablu.pcbd.domain.ChunkFile;
import com.parablu.pcbd.domain.Device;
import java.io.File;
import java.io.PrintStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.io.filefilter.PrefixFileFilter;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.bson.Document;
import org.springframework.util.CollectionUtils;

public class ClientDedupMissingChunkFinder {
    private static int skipValue;
    private static TimerTask backupTimerTask;
    private static Timer timer;
    private static int count;
    int deviceuuidCount;
    private static int threads;
    private static int limit;
    private static String baseStoragePath;
    private static List<Device> devList;
    private static boolean brevity;

    static {
        devList = new ArrayList<Device>();
    }

    public static void main(String[] args) throws ConfigurationException {
        try {
            char a = "a:\\".charAt(1);
            int comp = Character.compare(':', a);
            String s = "c:";
            System.out.println(String.valueOf(ClientDedupMissingChunkFinder.getChunkNewCollectionName("2442bfec619b75039c2852b6cf11b9c1")) + "##########started############" + ClientDedupMissingChunkFinder.getUniqueODUserFolder("b!KqIIkTSMT0-9ji7q48ABkBernxLfUSJMjeZvCWSBMNroTeZJ_VSsRI3iX_cM5rmj"));
            File file = new File("serverOutput.txt");
            if (!file.exists()) {
                file.createNewFile();
            } else {
                file.delete();
                file.createNewFile();
            }
            PrintStream o = new PrintStream(file);
            System.setOut(o);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("This will be written to the text file");
        PropertiesConfiguration config = null;
        config = new PropertiesConfiguration(args[0]);
        String mongoIP = config.getProperty("mongoIP").toString();
        String mongoPort = config.getProperty("mongoPort").toString();
        String thread = config.getProperty("thread").toString();
        String userName = config.getProperty("userName").toString();
        baseStoragePath = config.getProperty("baseStoragePath").toString();
        boolean startOver = Boolean.parseBoolean(config.getProperty("startOver").toString());
        brevity = Boolean.parseBoolean(config.getProperty("brevity").toString());
        int threadCount = Integer.parseInt(thread);
        if (StringUtils.isEmpty(mongoIP)) {
            System.out.println("mongoIP or port cannot be empty in config file...Please configure and run again :)");
            throw new ArrayIndexOutOfBoundsException();
        }
        System.out.println("mongo IP:" + mongoIP);
        MongoClientURI uri = new MongoClientURI("mongodb://neil:parablu@" + mongoIP + ":" + mongoPort + "/parablu001");
        MongoClient client = new MongoClient(uri);
        MongoDatabase db = client.getDatabase(uri.getDatabase());
        System.out.println("connectivity success  ");
        MongoCollection<Document> userColl = db.getCollection("USER");
        MongoCollection<Document> latestDeviceBkpInfoColl = db.getCollection("ROGUE_DBO_CLEANUP_FINISHED_DEVICES");
        MongoCollection<Document> deviceBkpOverviewColl = db.getCollection("DEVICE_BACKUP_OVERVIEW");
        FindIterable<Document> devices = null;
        if (StringUtils.isEmpty(userName)) {
            devices = userColl.find();
        } else {
            BasicDBObject inQuery = new BasicDBObject();
            userName = userName.replace("[", "");
            userName = userName.replace("]", "");
            userName = userName.trim();
            List<String> list = Arrays.asList(userName.split(","));
            list.replaceAll(String::trim);
            System.out.println(String.valueOf(userName) + " Device list size:" + list.size());
            System.out.println("Device list size:" + list.toString());
            inQuery.append("deviceUUID", new BasicDBObject("$in", list));
            System.out.println("inQuery:" + inQuery.toString());
            devices = userColl.find(inQuery);
        }
        System.out.println("DEvice list:");
        if (startOver) {
            latestDeviceBkpInfoColl.drop();
        }
        devices.forEach(latestDevice -> {
            Device device1 = new Device();
            device1.setDeviceUUID(latestDevice.getString("deviceUUID"));
            device1.setDestCollection(latestDevice.getString("destCollection"));
            device1.setDecoupled((Boolean)latestDevice.get("decoupled"));
            device1.setDeviceName(latestDevice.getString("deviceName"));
            device1.setBlocked((Boolean)latestDevice.get("blocked"));
            if (!startOver) {
                BasicDBObject andQuery1 = new BasicDBObject();
                ArrayList<BasicDBObject> whereQuery1 = new ArrayList<BasicDBObject>();
                whereQuery1.add(new BasicDBObject("deviceUUID", device1.getDeviceUUID()));
                andQuery1.put("$and", whereQuery1);
                devList.add(device1);
            } else {
                devList.add(device1);
            }
        });
        System.out.println("Converting device Db object to list of  device ...");
        System.out.println("total device size is...." + devList.size());
        int threadSizeVal = threadCount;
        ExecutorService executor = Executors.newFixedThreadPool(threadSizeVal);
        ExecutorCompletionService<Device> pool = new ExecutorCompletionService<Device>(executor);
        ClientDedupMissingChunkFinder.checkThreadStatusAndStartUpdate(db, latestDeviceBkpInfoColl, deviceBkpOverviewColl, pool);
        int i = 0;
        while (i < threadSizeVal) {
            System.out.println("Creating thread for first time>>>>>>>>> i value::");
            ClientDedupMissingChunkFinder.callUpdateDBEntries(db, latestDeviceBkpInfoColl, deviceBkpOverviewColl, pool);
            ++i;
        }
    }

    private static String convertStringTOBase64(String name) {
        String base64EncodeString = null;
        if (name != null) {
            byte[] bytes = DigestUtils.md5(name);
            byte[] bytesEncoded = Base64.encodeBase64(bytes);
            base64EncodeString = new String(bytesEncoded);
            base64EncodeString = base64EncodeString.substring(0, base64EncodeString.length() - 2);
            System.out.println("ecncoded value for given string is " + base64EncodeString);
        }
        return base64EncodeString;
    }

    private static String getUniqueODUserFolder(String deviceUUID) {
        String convertedString = "";
        if (!StringUtils.isEmpty(deviceUUID)) {
            String md5Val = MD5Generator.generateMD5OfString(deviceUUID);
            Long l = ByteBuffer.wrap(md5Val.toString().getBytes()).getLong();
            convertedString = Long.toString(l, 36);
        }
        return convertedString;
    }

    private static synchronized Device getDeviceFromList() {
        Device dev = null;
        try {
            if (!CollectionUtils.isEmpty(devList) && devList.get(0) != null) {
                dev = devList.get(0);
                System.out.println(".............." + dev.getDeviceUUID());
                devList.remove(dev);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return dev;
    }

    private static void checkThreadStatusAndStartUpdate(final MongoDatabase db, final MongoCollection latestDeviceBkpInfoColl, final MongoCollection deviceBkpOverviewColl, final CompletionService<Device> pool) {
        if (timer == null) {
            timer = new Timer();
        }
        if (backupTimerTask == null) {
            backupTimerTask = new TimerTask(){

                @Override
                public void run() {
                    try {
                        Future future = pool.take();
                        if (future.isDone()) {
                            Device device = (Device)future.get();
                            System.out.println("Update finished for device..." + device.getDeviceUUID());
                            BasicDBObject andQuery1 = new BasicDBObject();
                            ArrayList<BasicDBObject> whereQuery1 = new ArrayList<BasicDBObject>();
                            whereQuery1.add(new BasicDBObject("deviceUUID", device.getDeviceUUID()));
                            andQuery1.put("$and", whereQuery1);
                            Document latestDeviceBkpInfo = (Document)latestDeviceBkpInfoColl.find(andQuery1).first();
                            if (latestDeviceBkpInfo == null) {
                                Document latestBkpOverviewInfo = new Document();
                                latestBkpOverviewInfo.put("deviceUUID", (Object)device.getDeviceUUID());
                                latestBkpOverviewInfo.put("timestamp", (Object)System.currentTimeMillis());
                                latestBkpOverviewInfo.put("deviceName", (Object)device.getDeviceName());
                                latestDeviceBkpInfoColl.insertOne(latestBkpOverviewInfo);
                            } else {
                                BasicDBObject updateFields = new BasicDBObject();
                                BasicDBObject updateQuery = new BasicDBObject();
                                updateFields.put("deviceUUID", device.getDeviceUUID());
                                updateFields.put("timestamp", System.currentTimeMillis());
                                updateFields.put("deviceName", device.getDeviceName());
                                updateQuery.append("$set", updateFields);
                                latestDeviceBkpInfoColl.updateOne(andQuery1, updateQuery);
                            }
                            System.out.println(String.valueOf(Thread.currentThread().getName()) + " future is done........");
                            ClientDedupMissingChunkFinder.callUpdateDBEntries(db, latestDeviceBkpInfoColl, deviceBkpOverviewColl, pool);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            };
            timer.schedule(backupTimerTask, 1000L, 1000L);
        }
    }

    private static void callUpdateDBEntries(MongoDatabase db, MongoCollection latestDeviceBkpInfoColl, MongoCollection deviceBkpOverviewColl, CompletionService<Device> pool) {
        Device device = ClientDedupMissingChunkFinder.getDeviceFromList();
        if (device != null) {
            Runnable uploadJob = () -> {
                try {
                    ClientDedupMissingChunkFinder.updateLatestSize(db, latestDeviceBkpInfoColl, deviceBkpOverviewColl, device);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            };
            pool.submit(uploadJob, device);
        }
    }

    private static List<BackUpImage> getFilteredBackupImageList(List<BackUpImage> backUpImages) {
        ArrayList<BackUpImage> filteredBackUpImages = new ArrayList<BackUpImage>();
        Map<String, Map<String, List<BackUpImage>>> map = backUpImages.stream().collect(Collectors.groupingBy(BackUpImage::getDevicePath, Collectors.groupingBy(BackUpImage::getFileName)));
        for (Map.Entry<String, Map<String, List<BackUpImage>>> entry : map.entrySet()) {
            entry.getValue().entrySet().stream().forEach(p -> filteredBackUpImages.add(((List)p.getValue()).stream().sorted(Comparator.comparing(BackUpImage::getLastServerModifiedTime).reversed()).findFirst().get()));
        }
        return filteredBackUpImages;
    }

    private static void updateLatestSize(MongoDatabase db, MongoCollection latestDeviceBkpInfoColl, MongoCollection deviceBkpOverviewColl, Device device) {
        if (device == null) {
            System.out.println(String.valueOf(Thread.currentThread().getName()) + ".......Device is empty so return");
            return;
        }
        System.out.println(String.valueOf(Thread.currentThread().getName()) + "Satrted for device :" + device.getDeviceUUID() + " on " + System.currentTimeMillis());
        MongoCollection<Document> bkpColl = db.getCollection(device.getDestCollection());
        String deviceUUID = device.getDeviceUUID();
        BasicDBObject andQuery = new BasicDBObject();
        ArrayList<BasicDBObject> whereQuery = new ArrayList<BasicDBObject>();
        whereQuery.add(new BasicDBObject("deviceUUID", deviceUUID));
        whereQuery.add(new BasicDBObject("folder", true));
        whereQuery.add(new BasicDBObject("present", true));
        andQuery.put("$and", whereQuery);
        ArrayList<Document> allFoldersList = new ArrayList<Document>();
        int skip = 0;
        System.out.println(String.valueOf(Thread.currentThread().getName()) + " getting folders................");
        long latestFileSizes = 0L;
        while (true) {
            System.out.println("dest coll name:" + device.getDestCollection());
            FindIterable<Document> folders = bkpColl.find(andQuery).skip(skip * 200).limit(200);
            System.out.println("after getting folders:");
            if (folders.first() == null) break;
            for (Document document : folders) {
                allFoldersList.add(document);
            }
            ++skip;
        }
        System.out.println(String.valueOf(Thread.currentThread().getName()) + " getting folders list................" + allFoldersList.size());
        latestFileSizes = ClientDedupMissingChunkFinder.calacluateSizeForPaths(bkpColl, deviceUUID, allFoldersList, latestFileSizes, db, device.getDeviceName());
        allFoldersList = new ArrayList();
        System.out.println(String.valueOf(Thread.currentThread().getName()) + "Ended for device :" + device.getDeviceUUID() + " on " + System.currentTimeMillis());
    }

    private static long calacluateSizeForPaths(MongoCollection bkpColl, String deviceUUID, List<Document> allFoldersList, long latestFileSizes, MongoDatabase db, String deviceName) {
        for (Document folder : allFoldersList) {
            FindIterable files;
            String folderName = "";
            folderName = StringUtils.isEmpty(folder.getString("devicePath")) ? folder.getString("fileName") : String.valueOf(folder.getString("devicePath")) + "/" + folder.getString("fileName");
            BasicDBObject andQuery1 = new BasicDBObject();
            ArrayList<BasicDBObject> whereQuery = new ArrayList<BasicDBObject>();
            whereQuery.add(new BasicDBObject("deviceUUID", deviceUUID));
            whereQuery.add(new BasicDBObject("devicePath", folderName));
            whereQuery.add(new BasicDBObject("folder", false));
            whereQuery.add(new BasicDBObject("present", true));
            whereQuery.add(new BasicDBObject("storagePlace", "CLOUD"));
            andQuery1.put("$and", whereQuery);
            int skip1 = 0;
            int count = 0;
            while ((files = bkpColl.find(andQuery1).skip(skip1 * 200).limit(200)).first() != null) {
                ++skip1;
                ArrayList<BackUpImage> allFilesList = new ArrayList<BackUpImage>();
                int k = 0;
                for (Document document : files) {
                    ++k;
                    BackUpImage backUpImage = new BackUpImage();
                    backUpImage.setDevicePath(document.getString("devicePath"));
                    backUpImage.setFileName(document.getString("fileName"));
                    backUpImage.setLastServerModifiedTime(document.getLong("lastServerModifiedTime"));
                    backUpImage.setStoragePlace(document.getString("storagePlace"));
                    backUpImage.setUserName(document.getString("userName"));
                    backUpImage.setDeviceUUID(document.getString("deviceUUID"));
                    List chunkFilesDocs = (List)document.get("chunkFiles");
                    ArrayList<ChunkFile> chunkFiles = new ArrayList<ChunkFile>();
                    chunkFilesDocs.forEach(doc -> {
                        ChunkFile chunkFile = new ChunkFile();
                        chunkFile.setMd5(doc.getString("md5"));
                        chunkFile.setFileName(doc.getString("fileName"));
                        chunkFile.setfSPath(doc.getString("fsPath"));
                        chunkFile.setCloudStoragePath(doc.getString("cloudStoragePath"));
                        chunkFiles.add(chunkFile);
                    });
                    backUpImage.setChunkFiles(chunkFiles);
                    if (StringUtils.isEmpty(backUpImage.getDevicePath()) || StringUtils.isEmpty(backUpImage.getFileName())) continue;
                    backUpImage.setSize(document.getLong("size"));
                    allFilesList.add(backUpImage);
                }
                List<BackUpImage> list = ClientDedupMissingChunkFinder.getFilteredBackupImageList(allFilesList);
                block3: for (BackUpImage image : list) {
                    ++count;
                    latestFileSizes += image.getSize();
                    if (CollectionUtils.isEmpty(image.getChunkFiles())) {
                        System.out.println("@PVN@ |" + Thread.currentThread().getName() + "|" + image.getDevicePath() + "|" + image.getFileName() + "|" + image.getUserName() + "|" + image.getDeviceUUID() + "|" + deviceName + "|" + "REASON: bkpimage - chunk file not found.");
                        continue;
                    }
                    for (ChunkFile chunkFile : image.getChunkFiles()) {
                        File file;
                        andQuery1 = new BasicDBObject();
                        whereQuery = new ArrayList();
                        whereQuery.add(new BasicDBObject("md5", chunkFile.getMd5()));
                        andQuery1.put("$and", whereQuery);
                        MongoCollection<Document> chunkDetailColl = db.getCollection(ClientDedupMissingChunkFinder.getChunkNewCollectionName(chunkFile.getMd5()));
                        FindIterable<Document> chunkDetailDocs = chunkDetailColl.find(andQuery1);
                        ArrayList chunkDetailList = new ArrayList();
                        chunkDetailDocs.forEach(chunkDetailDoc -> {
                            ChunkDetail chunkDetail = new ChunkDetail();
                            chunkDetail.setCloudStoragePath(chunkDetailDoc.getString("cloudStoragePath"));
                            chunkDetail.setMd5(chunkDetailDoc.getString("md5"));
                            chunkDetail.setCloudChunkName(chunkDetailDoc.getString("cloudChunkName"));
                            chunkDetail.setContainerName(chunkDetailDoc.getString("containerName"));
                            chunkDetail.setRefCount(chunkDetailDoc.getInteger("refCount"));
                            chunkDetail.setUserName(chunkDetailDoc.getString("userName"));
                            chunkDetail.setEncodedName(chunkDetailDoc.getString("encodedName"));
                            chunkDetailList.add(chunkDetail);
                        });
                        ChunkDetail chunkDetail = null;
                        if (!CollectionUtils.isEmpty(chunkDetailList)) {
                            for (ChunkDetail detailFromDB : chunkDetailList) {
                                if (detailFromDB.getRefCount() <= 0) continue;
                                chunkDetail = detailFromDB;
                            }
                        }
                        if (chunkDetail == null) {
                            System.out.println("@PVN@ |" + Thread.currentThread().getName() + "|" + image.getDevicePath() + "|" + image.getFileName() + "|" + image.getUserName() + "|" + image.getDeviceUUID() + "|" + deviceName + "|" + "REASON: chunk detail not found.");
                            continue block3;
                        }
                        String completeDownloadpath = String.valueOf(baseStoragePath) + "/backup" + "/" + chunkDetail.getContainerName();
                        if (!StringUtils.isEmpty(chunkDetail.getCloudStoragePath())) {
                            completeDownloadpath = String.valueOf(completeDownloadpath) + "/" + chunkDetail.getCloudStoragePath();
                        }
                        String downloadFileName = String.valueOf(completeDownloadpath) + "/" + chunkDetail.getCloudChunkName();
                        if (!brevity) {
                            System.out.println("Check file exist or not for:" + downloadFileName);
                        }
                        if (!(file = new File(downloadFileName)).exists()) {
                            if (StringUtils.isEmpty(chunkDetail.getCloudStoragePath())) {
                                completeDownloadpath = String.valueOf(completeDownloadpath) + "/" + "1";
                                downloadFileName = String.valueOf(completeDownloadpath) + "/" + chunkDetail.getCloudChunkName();
                                if (!brevity) {
                                    System.out.println("Check file exist or not for after adding 1 manually:" + downloadFileName);
                                }
                                file = new File(downloadFileName);
                            }
                            if (!file.exists() && chunkDetail != null && !StringUtils.isEmpty(chunkDetail.getEncodedName())) {
                                downloadFileName = String.valueOf(completeDownloadpath) + "/" + chunkDetail.getEncodedName();
                                if (!brevity) {
                                    System.out.println("Check file exist or not for after adding encoded name:" + downloadFileName);
                                }
                                file = new File(downloadFileName);
                            }
                            if (!file.exists()) {
                                File dir = new File(completeDownloadpath);
                                Object[] destFiles = dir.list(new PrefixFileFilter(chunkDetail.getMd5()));
                                if (!brevity) {
                                    System.out.println("Check file exist or not for after adding :" + downloadFileName);
                                }
                                if (ArrayUtils.isNotEmpty(destFiles)) {
                                    file = new File(String.valueOf(completeDownloadpath) + "/" + (String)destFiles[0]);
                                }
                            }
                            if (!file.exists()) {
                                System.out.println("@PVN@ |" + Thread.currentThread().getName() + "|" + image.getDevicePath() + "|" + image.getFileName() + "|" + image.getUserName() + "|" + image.getDeviceUUID() + "|" + deviceName + "|" + "REASON: File not exists.");
                                continue block3;
                            }
                            if (brevity) continue;
                            System.out.println("@PVN@ |" + Thread.currentThread().getName() + "|" + image.getDevicePath() + "|" + image.getFileName() + "|" + image.getUserName() + "|" + image.getDeviceUUID() + "|" + deviceName + "|" + "REASON: File exists.");
                            continue;
                        }
                        if (brevity) continue;
                        System.out.println("@PVN@ |" + Thread.currentThread().getName() + "|" + image.getDevicePath() + "/" + image.getFileName() + "|" + image.getUserName() + "|" + image.getDeviceUUID() + "|" + deviceName + "|" + "REASON: File exists.");
                    }
                }
            }
        }
        return latestFileSizes;
    }

    private static String getChunkNewCollectionName(String md5) {
        int hashCode = Arrays.hashCode(md5.getBytes());
        int chunkDetailDest = Math.abs(hashCode % 101);
        return "CHUNK_DETAIL_" + chunkDetailDest;
    }
}

