<?php

use \Core\View;
use \Helpers\Url;
use Helpers\Form;
use Core\Language;
 /*
 *
 * Copyright 2015
 * ParaBlu Systems Private Limited
 * All Rights Reserved
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of ParaBlu Systems Private Limited and its suppliers, if any.
 * The intellectual and technical concepts contained herein are proprietary
 * to ParaBlu Systems Private Limited and its suppliers and may be covered by
 * Indian, US and Foreign Patents, patents in process, and are protected by
 * trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from ParaBlu Systems Private Limited.
 *
 * index.php
 *
 * @author Prashanth Kumar B - prashanth.kumar@parablu.com
 * @version 2.0
 * @date 7/10/15
 * @time 11:55 AM
 * 
 */
?>
<div class="container">
    <div class="row">
        <div class="col-lg-6">
            <ol class="breadcrumb">
                <li><h3><a href="<?=Url::basePath('settings')?>"><?=$data['title']?></a></h3></li>
                <li><?=$data['crumb1']?></li>
            </ol>
        </div>
        <div class="col-lg-6 hide">
            <?php View::renderTemplate('partials/createButton', $data)?>
        </div>
    </div>
</div>
<div class="main" ng-controller="SettingController">
    <div class="row profile">
        <div class="col-lg-1 col-md-1 col-sm-1">
            <?php if(!isMobile()){ View::renderTemplate('partials/sideBar', $data); }?>
        </div>
        <div class="col-lg-11 col-md-11 col-sm-11">
            <span class="csrf_token hide"><?=$data['csrf_token']?></span>
            <span class="currentPage hide"><?='dashboard'?></span>
            <div class="row">
                <div class="panel">
                    <div class="panel-heading">
                        <h4 style="padding: 0px 0px 0px 15px;"><?=$data['crumb1']?></h4>
                    </div>
                    <div class="panel-body">
                        <form class="smtpConfiguration" ng-submit="saveSmtpConfiguration()" data-parsley-validate>
				        <div class="hide">
                                                <label for="pubkey">Public Key</label><br/>
                            <textarea id="pubkey" rows="15" cols="65">-----BEGIN PUBLIC KEY-----
                        MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQDJa13jCuhhMNQfcXb6uRJEnKkQ
                        BQxpl1Dp5U8EDbo16KrSDT++OytnYqVx6opHwJoZ9jwc8qUMheyPkvqRwkxBEulq
                        Ig8Tca9eg/uVjg2DHs4wIyzNJ7P19n1d4KoF3I8ZU1IrdDa0aQ85Fc3ogakZY9+x
                        VCPksMvihMgXe2xLdwIDAQAB
                        -----END PUBLIC KEY-----</textarea><br/>
                        </div>
                            <div class="form-group col-lg-6">
                                <label for="smtpHost">SMTP Host</label>
                                <input type="text" class="form-control" name="smtpHost" id="smtpHost" value="<?=$data['smtpHost']?>" placeholder="Enter SMTP Host" required autocomplete="off">
                            </div>
                            <div class="form-group col-lg-6">
                                <label for="sslPort">SSL Port</label>
                                <input type="number" class="form-control" name="sslPort" id="sslPort" value="<?=$data['sslPort']?>" placeholder="Enter SSL Port" required autocomplete="off">
                            </div>
                            <div class="form-group col-lg-6">
                                <label for="factoryClass">SSL Factory Class</label>
                                <input type="text" class="form-control" name="factoryClass" id="factoryClass" value="<?=$data['sslFactoryClass']?>" placeholder="Enter SSL Factory Class" required autocomplete="off">
                            </div>
                            <div class="form-group col-lg-6">
                                <label for="smtpPort">SMTP Port</label>
                                <input type="number" class="form-control" name="smtpPort" id="smtpPort" value="<?=$data['smtpPort']?>" placeholder="Enter SMTP Port" required autocomplete="off">
                            </div>
                            <div class="form-group col-lg-6">
                                <label for="smtpAuth">SMTP Auth</label>
                                <select class="form-control smtpAuth selectpicker" name="smtpAuth" id="smtpAuth" >
                                    <option value="true" <?php if($data["smtpAuth"] == true){echo "selected";}?>>True</option>
                                    <option value="false" <?php if($data["smtpAuth"] == false){echo "selected";}?>>False</option>
                                </select>
                            </div>
                            <div class="form-group col-lg-6">
                                <label for="smtpStarttlsEnable">SMTP Start TLS Enable</label>
                                <select class="form-control smtpStarttlsEnable selectpicker" name="smtpStarttlsEnable" id="smtpStarttlsEnable" >
                                    <option value="true" selected="selected" <?php if($data["smtpStarttlsEnable"] == true){echo "selected";}?>>True</option>
                                    <option value="false" <?php if($data["smtpStarttlsEnable"] == false){echo "selected";}?>>False</option>
                                </select>
                            </div>
			    <div class="form-group col-lg-6">
                                <label for="smtpSSLEnable">SMTP SSL Enable</label>
                                <select class="form-control smtpSSLEnable selectpicker" name="smtpSSLEnable" id="smtpSSLEnable" >
                                    <option value="true" selected="selected" <?php if($data["smtpSSLEnable"] == true){echo "selected";}?>>True</option>
                                    <option value="false" <?php if($data["smtpSSLEnable"] == false){echo "selected";}?>>False</option>
                                </select>
                            </div>
                            <div class="form-group col-lg-6">
                                <label for="smtpUname">SMTP Username</label>
                                <input type="text" class="form-control" name="smtpUname" id="smtpUname" value="<?=$data['smtpUserName']?>" placeholder="Enter SMTP Username" required autocomplete="off">
                            </div>
                            <div class="form-group col-lg-6">
                                <label for="smtpPwd">SMTP Password</label>
                                <a href="#" data-toggle="tooltip" data-placement="top" title="Password change may cause...."><i class="fa fa-question-circle" aria-hidden="true"></i></a>
                                <input type="password" class="form-control" name="smtpPwd" id="smtpPwd" value="<?=$data['smtpPwd']?>" placeholder="Enter SMTP Password" required autocomplete="off">
                            </div>
                            <div class="form-group col-lg-6">
                                <label for="email">Email ID</label>
                                <input type="email" class="form-control" name="email" id="email" value="<?=$data['fromEmail']?>" placeholder="Enter your Email ID" required autocomplete="off">
                            </div>
                            <div class="form-group col-lg-6">
                                <label for="enableMail">Enable Email</label>
                                <select class="form-control enableMail selectpicker" name="enableMail" id="enableMail" >
                                    <option value="true" selected="selected" <?php if($data["enableEmail"] == true){echo "selected";}?>>True</option>
                                    <option value="false" <?php if($data["enableEmail"] == false){echo "selected";}?>>False</option>
                                </select>
                            </div>
                            <div class="form-group col-lg-6">
                                <button type="submit" class="btn saveSMTP btn-success pull-right">Save</button>
                            </div>
                        </form>
                    </div>
                </div>
                <!--start add-->
                <div class="modal fade" id="testMail" tabindex="-1" role="dialog">
                    <div class="modal-dialog">
                        <div class="modal-content <?php if(!isMobile()){ ?>mediumModal<?php } ?>">
                            <?= Form::open(array(
                                        'ng-submit' => 'testMail()',
                                        'class' => 'testMailClass',
                                        'csrf' => $data['csrf_token'],
                                        'autocomplete' => 'off'
                                        )); ?>
                                        <div class="modal-header">
                                            <!--<button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>-->
                                            <h4 class="modal-title"><?=Language::show('Test Mail Validation', 'keywords')?></h4>
                                        </div>
                                        <div class="modal-body">
                                            <div class="row">
                                                <div class="form-group col-lg-6">
                                                    <label for="email"><?=Language::show('Email', 'keywords')?></label>
                                                    <input type="email" class="form-control" name="email" id="testEmail" value="" placeholder="Enter your email id" required autocomplete="off">
                                                </div>
                                            </div>
                                        </div>
                                        <div class="modal-footer">
                                            <button type="submit" class="btn btn-success testEmailBtn"><?=Language::show('Test Mail', 'keywords')?></button>
                                            <a ng-click="closeTestMail()" class="btn btn-default"><?=Language::show('Close', 'keywords')?></a>
                                        </div>
                            <?= Form::close(); ?>
                        </div>
                    </div>
                </div>
                <!--end add -->
            </div>
        </div>
    </div>
    <?php View::renderTemplate('partials/search', $data); ?>
</div><!-- /.container -->
<?php View::renderTemplate('partials/scripts')?>
<script src="<?=Url::templatePath()?>js/angular/controllers/SettingController.js?<?=VERSIONS_NUMBER?>" type="text/javascript"></script>
<script>
$(document).ready(function(){
    $('[data-toggle="tooltip"]').tooltip();   
});
</script>