/**
 * Created by parablu-dev on 8/5/15.
 */

app.controller('UserController', ['$scope', 'toastr', 'Upload', '$http', '$ngBootbox', '$timeout', 'blockUI', 'BASE_FOLDER', 'timeAgo', function($scope, toastr, Upload, $http, $ngBootbox, $timeout, blockUI, BASE_FOLDER, timeAgo) {

    timeAgo.settings.fullDateAfterSeconds = 60*60*24;

    $scope.sortReverse = false;
    $scope.sortType = 'userName';

    $scope.BASE_FOLDER = BASE_FOLDER;
    $scope.userStatus   = $('.userStatusCollector').html();
    $scope.selectedUser = $('.userName').html();
    $scope.currentPage = $('.currentPage').html();
    $scope.userList = [];
    $scope.userUnblockList = [];
    $scope.userStorage = '';
    $scope.userFree = '';
    $scope.userLimit = '';
    $scope.userUsed = '';
    $scope.skipValue = 0;
    $scope.pageNumber = 1;
    $scope.policyconfiguration = '';
    $scope.currentUser = [];
    $scope.currentOs = $('.currentOs').html();
    $scope.userDevices = [];
    $scope.searchUserName = '';
    $scope.assignDevices = [];
    $scope.softBlockList = [];
    $scope.unSelectedUsers = [];
    $scope.selectedUsers = [];
    $scope.not_created = [];
    $scope.limit = 20;
    
    $scope.sendMeTo = function(location){
        window.location.href = location;
    };

    $scope.getAllUnBlockedUsersForSelectionBySearch = function(userName){
        setTimeout(function(){
            if(userName.length > 0){
                $scope.getAllUnBlockedUsersForSelection(userName);
            }else{
                $scope.getAllUnBlockedUsersForSelection('all');
                toastr.info('Please enter 1 or more Characters', 'Information!!!', {allowHtml: true});
            }
        }, 2000);
    };

    $scope.getAllUnBlockedUsersForSelection = function(userName){
        $.ajax({
            url: $scope.BASE_FOLDER+'/user/getAllUnBlockedUsers',
            type: 'GET',
            data: {q: userName}
        }).done(function(data){
            try {
                var jData = JSON.parse(data);
                if(jData.result == 'success'){
                    $scope.unSelectedUsers = jData.users;
                    $scope.$apply();
                }else{
                    toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
                }
            }
            catch(err) {
                toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/logout';
                }, 3000);
            }

        }).fail(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    $scope.addToSelectedUsers = function($index, ignore){
        if(ignore == false){
            if($scope.unSelectedUsers.length >= 1){
                $scope.selectedUsers.push($scope.unSelectedUsers[$index]);
                $scope.unSelectedUsers.splice($index, 1);
            }else{
                toastr.error('Selected User was not found', 'Fail!!!', {allowHtml: true});
            }
        }
    };

    $scope.addToUnSelectedUsers = function($index, ignore){
        if(ignore == false){
            if($scope.selectedUsers.length >= 1){
                $scope.unSelectedUsers.push($scope.selectedUsers[$index]);
                $scope.selectedUsers.splice($index, 1);
            }else{
                toastr.error('Selected User was not found', 'Fail!!!', {allowHtml: true});
            }
        }
    };

    $scope.removeUserGroup = function(groupName, md5GroupName){
        if(groupName.length > 0){
            var html = $('.deleteGroup'+md5GroupName).html();
            $('.deleteGroup'+md5GroupName).attr('disabled','disabled');
            $('.deleteGroup'+md5GroupName).html('Loading... <i class="fa fa-circle-o-notch fa-spin"></i>').animate();
            $.ajax({
                url: $scope.BASE_FOLDER+'/deleteUserGroup',
                data: {groupName: groupName},
                type: 'POST'
            }).done(function(data){
                $('.deleteGroup'+md5GroupName).removeAttr('disabled');
                $('.deleteGroup'+md5GroupName).html(html);
                var jData = JSON.parse(data);
                if(jData.result == 'success'){
                    toastr.success(jData.msg, 'Successful!!!', {allowHtml: true});
                    setTimeout(function(){
                        window.location.reload(true);
                    }, 2000);
                }else{
                    toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
                }
            }).fail(function(data){
                toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
                if(data.status == 424){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/sleep';
                    }, 3000);
                }else if(data.status == 503){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                    }, 3000);
                }
            });
        }
    };

    $scope.$watch('file', function (file) {
        if(file){
            $scope.upload(file);
        }else if(file != undefined || file != null){
            toastr.info('Uploaded File format not supported');
        }
    });

    $scope.upload = function (file) {
        Upload.upload({
            url: $scope.BASE_FOLDER+'/upload',
            fields: {'username': $scope.username},
            file: file
        }).progress(function (evt) {
            var progressPercentage = parseInt(100.0 * evt.loaded / evt.total);
        }).success(function (data, status, headers, config) {
            if(config.file){
                if(!jQuery.isEmptyObject(config.file)){
                    toastr.success(config.file.name, 'Profile Pic Changed');
                }else{
                    toastr.error('Uploaded Format is not supported', 'Error!!');
                }
            }
        }).fail(function (data, status, headers, config) {
            toastr.error(data.message);
        })
    };

    $scope.saveUserDetails = function(){
        $('.loading').html('Loading ...');
        $('.error').hide();
        $('.error').html('');
        if($('.userSettingsForm').parsley().isValid()){
            var html = $('.UserSave').html();
            var displayName = $('#displayName').val();
            var emailId = $('#email_address').val();
            if($('#local_user').val() == 'true'){
                if(isSpecialCharForEmailEdit(emailId) == false){
                $("#email_address").focus();
                $('[name="email_address"]').addClass('parsley-error');
                return;
                }
            }
            /*if(isSpecialCharForDisplayName(displayName) == false){
            $("#displayName").focus();
            $('[name="displayName"]').addClass('parsley-error');
            return;
            }
            $('[name="displayName"]').removeClass('parsley-error');
            $('[name="displayName"]').addClass('parsley-success');*/
            $('[name="email_address"]').removeClass('parsley-error');
            $('[name="email_address"]').addClass('parsley-success');
	    if($("#account_type").val() == 'read_only_admin'){
		if($(".backupPoliciesAdmin").length > 0 && $(".odbPoliciesAdmin").length > 0 && $(".syncPoliciesAdmin").length > 0){		    
			if(!$(".backupPoliciesAdmin").hasClass('hide') && !$(".odbPoliciesAdmin").hasClass('hide') && !$(".syncPoliciesAdmin").hasClass('hide')){
				if($("#backupPoliciesAdmin").val() == '' && $("#odbPoliciesAdmin").val() == '' && $("#odbPoliciesAdmin").val() == ''){
					console.log("1");
					toastr.error('Please select at least one policy to manage by the Delegated Administrator.', 'Error!!');
					return;
				}
			}
		}
		if($(".backupPoliciesAdmin").length > 0 && $(".odbPoliciesAdmin").length > 0){		    
			if(!$(".backupPoliciesAdmin").hasClass('hide') && !$(".odbPoliciesAdmin").hasClass('hide')){
				if($("#backupPoliciesAdmin").val() == '' && $("#odbPoliciesAdmin").val() == ''){
					console.log("2");
					toastr.error('Please select at least one policy to manage by the Delegated Administrator.', 'Error!!');
					return;
				}
			}
		}
		if($(".backupPoliciesAdmin").length > 0 && $(".syncPoliciesAdmin").length > 0){
			if(!$(".backupPoliciesAdmin").hasClass('hide') && !$(".syncPoliciesAdmin").hasClass('hide')){
				if($("#backupPoliciesAdmin").val() == '' && $("#syncPoliciesAdmin").val() == ''){
					console.log("3");
					toastr.error('Please select at least one policy to manage by the Delegated Administrator.', 'Error!!');
					return;
				}
			}
		}
		if($(".backupPoliciesAdmin").length > 0 && $(".syncPoliciesAdmin").length <= 0 && $(".odbPoliciesAdmin").length <= 0){
			if(!$(".backupPoliciesAdmin").hasClass('hide')){
				if($("#backupPoliciesAdmin").val() == ''){
					console.log("4");
					toastr.error('Please select at least one policy to manage by the Delegated Administrator.', 'Error!!');
					return;
				}
			}
		}
		if($(".syncPoliciesAdmin").length > 0 && $(".backupPoliciesAdmin").length <= 0 && $(".odbPoliciesAdmin").length <= 0){
			if(!$(".syncPoliciesAdmin").hasClass('hide')){
				if($("#syncPoliciesAdmin").val() == ''){
					console.log("5");
					toastr.error('Please select at least one policy to manage by the Delegated Administrator.', 'Error!!');
					return;
				}
			}
		}
		if($(".odbPoliciesAdmin").length > 0 && $(".syncPoliciesAdmin").length <= 0 && $(".backupPoliciesAdmin").length <= 0){
			if(!$(".odbPoliciesAdmin").hasClass('hide')){
				if($("#odbPoliciesAdmin").val() == ''){
					console.log("5");
					toastr.error('Please select at least one policy to manage by the Delegated Administrator.', 'Error!!');
					return;
				}
			}
		}
	    }
            $('.UserSave').attr('disabled','disabled');
            $('.UserSave').html('Loading... <i class="fa fa-circle-o-notch fa-spin"></i>').animate();
            $.ajax({
                url: $scope.BASE_FOLDER+'/user/save',
                data: $('form').serialize(),
                type: 'POST'
            }).done(function(data){
                var jData = $.parseJSON(data);
                console.log("hhh" +jData);
                console.log("hhh77" +data);
                if(jData.result == 'success'){
                    toastr.success(jData.message, 'Successful!!!');
                    $('.UserSave').removeAttr('disabled');
                    $('.UserSave').html(html);

                    if(jData.data == 'false'){
                        $('.account_type').addClass('hide');
                        $('.sync_access').addClass('hide');
                        $('.backup').addClass('hide');
                        $('.miniCloudName').addClass('hide');
                        $('.share_enabled').addClass('hide');
                    }else{
                        //$('.account_type').removeClass('hide');
                        //$('.sync_access').removeClass('hide');
                        //$('.backup').removeClass('hide');
                        //$('.miniCloudName').removeClass('hide');
                        //$('.share_enabled').removeClass('hide');
                    }
                    setTimeout(function(){
                       location.reload();
                    }, 3000);

                }else if(jData.result == 'fieldFail'){
                    $('.error').show();
                    for(var key in jData.msg){
                        if (jData.msg.hasOwnProperty(key)) {
                            if($('.error').html() != ''){
                                $('.error').append('<br/>'+jData.msg[key]);
                            }else{
                                $('.error').html(jData.msg[key]);
                            }
                            $('[name="'+key.toLowerCase()+'"]').removeClass('parsley-success');
                            $('[name="'+key.toLowerCase()+'"]').addClass('parsley-error');
                        }
                    }
                    $('.UserSave').removeAttr('disabled');
                    $('.UserSave').html(html);
                }else{
                    $('.UserSave').removeAttr('disabled');
                    $('.UserSave').html(html);
                    $('.error').hide();
                    toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
                }
            }).fail(function(data){
                toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
                if(data.status == 424){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/sleep';
                    }, 3000);
                }else if(data.status == 503){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                    }, 3000);
                }
            });
        }
    };

    $scope.saveNewUserDetails = function(){
        if($('.userCreationFrom').parsley().isValid()) {
            if($('#username').val() == $('#password').val())
        {
            toastr.error('Username and Password should not be same  ', 'Fail!!!', {allowHtml: true});
            return;
        }
            $('.createMiniCloudError').hide();
            var html = $('.userSave').html();
            var userName = $('#username').val();
            var displayName = $('#displayName').val();
            var emailId = $('#email').val();
            if(isSpecialCharForUser(userName) == false){
            $('[name="username"]').addClass('parsley-error');
            return;
            }
            if(isSpecialCharForEmail(emailId) == false){
            $("#email").focus();
            $('[name="email"]').addClass('parsley-error');
            return;
            }
            /*if(isSpecialCharForDisplayName(displayName) == false){
            $("#displayName").focus();
            $('[name="displayName"]').addClass('parsley-error');
            return;
            }*/
            $('[name="username"]').removeClass('parsley-error');
            $('[name="username"]').addClass('parsley-success');
            $('[name="email"]').removeClass('parsley-error');
            $('[name="email"]').addClass('parsley-success');
            /*$('[name="displayName"]').removeClass('parsley-error');
            $('[name="displayName"]').addClass('parsley-success');*/
	    if($("#account_type").val() == 'read_only_admin'){
		if($(".backupPoliciesAdmin").length > 0 && $(".odbPoliciesAdmin").length > 0 && $(".syncPoliciesAdmin").length > 0){		    
			if($(".backupPoliciesAdmin").not('.hide') && $(".odbPoliciesAdmin").not('.hide') && $(".syncPoliciesAdmin").not('.hide')){
				if($("#backupPoliciesAdmin").val() == '' && $("#odbPoliciesAdmin").val() == '' && $("#odbPoliciesAdmin").val() == ''){
					console.log("1");
					toastr.error('Please select at least one policy to manage by the Delegated Administrator.', 'Error!!');
					return;
				}
			}
		}
		if($(".backupPoliciesAdmin").length > 0 && $(".odbPoliciesAdmin").length > 0){		    
			if($(".backupPoliciesAdmin").not('.hide') && $(".odbPoliciesAdmin").not('.hide')){
				if($("#backupPoliciesAdmin").val() == '' && $("#odbPoliciesAdmin").val() == ''){
					console.log("2");
					toastr.error('Please select at least one policy to manage by the Delegated Administrator.', 'Error!!');
					return;
				}
			}
		}
		if($(".backupPoliciesAdmin").length > 0 && $(".syncPoliciesAdmin").length > 0){
			if($(".backupPoliciesAdmin").not('.hide') && $(".syncPoliciesAdmin").not('.hide')){
				if($("#backupPoliciesAdmin").val() == '' && $("#syncPoliciesAdmin").val() == ''){
					console.log("3");
					toastr.error('Please select at least one policy to manage by the Delegated Administrator.', 'Error!!');
					return;
				}
			}
		}
		if($(".backupPoliciesAdmin").length > 0 && $(".syncPoliciesAdmin").length <= 0 && $(".odbPoliciesAdmin").length <= 0){
			if($(".backupPoliciesAdmin").not('.hide')){
				if($("#backupPoliciesAdmin").val() == ''){
					console.log("4");
					toastr.error('Please select at least one policy to manage by the Delegated Administrator.', 'Error!!');
					return;
				}
			}
		}
		if($(".syncPoliciesAdmin").length > 0 && $(".backupPoliciesAdmin").length <= 0 && $(".odbPoliciesAdmin").length <= 0){
			if($(".syncPoliciesAdmin").not('.hide')){
				if($("#syncPoliciesAdmin").val() == ''){
					console.log("5");
					toastr.error('Please select at least one policy to manage by the Delegated Administrator.', 'Error!!');
					return;
				}
			}
		}
		if($(".odbPoliciesAdmin").length > 0 && $(".syncPoliciesAdmin").length <= 0 && $(".backupPoliciesAdmin").length <= 0){
			if($(".odbPoliciesAdmin").not('.hide')){
				if($("#odbPoliciesAdmin").val() == ''){
					console.log("5");
					toastr.error('Please select at least one policy to manage by the Delegated Administrator.', 'Error!!');
					return;
				}
			}
		}
	    }
            $('.userSave').attr('disabled', 'disabled');
            $('.userSave').html('Loading... <i class="fa fa-circle-o-notch fa-spin"></i>').animate();
            $.ajax({
                url: $scope.BASE_FOLDER+'/user/create',
                data: $('form').serialize(),
                type: 'POST'
            }).done(function(data){
                $('.userSave').removeAttr('disabled');
                $('.userSave').html(html);
                var jData = JSON.parse(data);
                if(jData.result == 'success'){
                    toastr.success(jData.msg, 'Successful!!!', {allowHtml: true});
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/users';
                    }, 3000)
                }else{
                    toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
                }
            }).fail(function(data){
                toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
                if(data.status == 424){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/sleep';
                    }, 3000);
                }else if(data.status == 503){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                    }, 3000);
                }
            });
        }
    };
    
    function isSpecialCharForEmail(val) {
        val = val.replace(/\s/g,'');
        var regex = /[*|+=?\/]/gi;
                if(regex.test(val)){
                    $('[name="email"]').popover('show');
                    return false;
                }
                else{
                    $('[name="email"]').popover('hide');
                    return true;
                }
    }
    
    function isSpecialCharForEmailEdit(val) {
        val = val.replace(/\s/g,'');
        var regex = /[*|+=?\/]/gi;
                if(regex.test(val)){
                    $('[name="email_address"]').popover('show');
                    return false;
                }
                else{
                    $('[name="email_address"]').popover('hide');
                    return true;
                }
    }
    
    function isSpecialCharForUser(val) {
        var tr = $.trim(val).length;
        /*val = val.replace(/^\s+|\s+$/g,'');
        if(val && tr) {
            var regex = /[=@$+*|,<>/\\:;?"\[\]]/;
            if(regex.test(val)){
                return false;
            }
        }
        else{
            return false;
        }
        return true;*/
        //val = val.replace(/\s/g,'');
        var regex = /[`~!#$%^&*()|+\-=?;:'",<>\s\{\}\[\]\\\/]/gi;
                if(regex.test(val)){
                    $('[name="username"]').popover('show');
                    return false;
                }
                else{
                    $('[name="username"]').popover('hide');
                    return true;
                }
    }
    
    function isSpecialCharForDisplayName(val) {
        val = val.replace(/\s/g,'');
        var regex = /[`~!#$%^&*()_|+\-=?;:'",<>\{\}\[\]\\\/]/gi;
                if(regex.test(val)){
                    $('[name="displayName"]').popover('show');
                    return false;
                }
                else{
                    $('[name="displayName"]').popover('hide');
                    return true;
                }
    }

    $scope.blockUserProfile = function(selectedUser, confirmed){
        $('.loading').html('Loading ...');
        var userName = '';
        if(isNaN(selectedUser)){
            userName = selectedUser;
        }else{
            userName = selectedUser;
        }
        if(confirmed == 'true'){
            $.ajax({
                url: $scope.BASE_FOLDER+'/user/block',
                data: {userName: userName, blockUser: 'false'},
                type: 'POST'
            }).done(function(data){
                var jData = JSON.parse(data);
                if(jData.result == 'success'){
                    if($scope.userStatus != undefined){
                        $scope.userStatus = false;
                    }else{
                        $scope.users.forEach(function(value, key){
                            if(value.userName == selectedUser){
                                $scope.users[key].isActive = false;
                            }
                        });
                    }
                    $scope.$apply();
                    toastr.success('User "'+userName+'" '+jData.msg, 'Successful!!!', {allowHtml: true});
                }else{
                    toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
                }
            }).fail(function(data){
                toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
                if(data.status == 424){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/sleep';
                    }, 3000);
                }else if(data.status == 503){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                    }, 3000);
                }
            });
        }
    };

    $scope.unBlockUserProfile = function(selectedUser, confirmed){
        $('.loading').html('Loading ...');
        var userName = '';
        if(isNaN(selectedUser)){
            userName = selectedUser;
        }else{
            userName = selectedUser;
        }
        if(confirmed == 'true'){
            $.ajax({
                url: $scope.BASE_FOLDER+'/user/block',
                data: {userName: userName, blockUser: 'true'},
                type: 'POST'
            }).done(function(data){
                var jData = JSON.parse(data);
                if(jData.result == 'success'){
                    if($scope.userStatus != undefined){
                        $scope.userStatus = true;
                    }else{
                        $scope.users.forEach(function(value, key){
                            if(value.userName == selectedUser){
                                $scope.users[key].isActive = true;
                            }
                        });
                    }
                    $scope.$apply();
                    toastr.success('User "'+userName+'" '+jData.msg, 'Successful!!!', {allowHtml: true});
                }else{
                    toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
                }
            }).fail(function(data){
                toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
                if(data.status == 424){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/sleep';
                    }, 3000);
                }else if(data.status == 503){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                    }, 3000);
                }
            });
        }
    };

    $scope.deleteUserProfile = function(selectedUser, confirmed){
        $('.loading').html('Loading ...');
        var userName = '';
        if(isNaN(selectedUser)){
            userName = selectedUser;
        }else{
            userName = selectedUser;
        }
        if(confirmed == 'true'){
            $.ajax({
                url: $scope.BASE_FOLDER+'/user/delete',
                data: {userName: userName, blockUser: 'true'},
                type: 'POST'
            }).done(function(data){
                var jData = JSON.parse(data);
                if(jData.result == 'success'){
                    if(isNaN(selectedUser)){
                        toastr.success('User "'+userName+'" '+jData.message, 'Successful!!!', {allowHtml: true});
                        setTimeout(function(){
                            window.location.href = $scope.BASE_FOLDER+'/users';
                        }, 3000);
                        //window.location.href = $scope.BASE_FOLDER+'/users';
                    }else{
                        $scope.users.forEach(function(value, key){
                            if(value.userName == selectedUser){
                                $scope.users.splice(key, 1);
                            }
                        });
                        toastr.success('User "'+userName+'" '+jData.message, 'Successful!!!', {allowHtml: true});
                    }
                }else{
                    toastr.error(jData.message, 'Fail!!!', {allowHtml: true});
                }
                $scope.$apply();
            }).fail(function(data){
                toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
                if(data.status == 424){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/sleep';
                    }, 3000);
                }else if(data.status == 503){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                    }, 3000);
                }
            });
        }
    };


    $scope.searchUser = function(userName){
        $('[name="searchUsername"]').popover('hide');
        $('.loading').html('Loading ...');
        if(userName.length == 0 || userName == 'all'){
            userName = 'all';
            $scope.users = [];
            $scope.searchUserName='';
            $scope.skipValue = 0;
            $scope.updateUsers('all', 0);
        }else{
            $scope.searchUserName=userName;
            $scope.updateUsers(userName, 0);
         }
    };
    
    $scope.searchUser1 = function(userName){
        userName = userName.join(',');
        $('.loading').html('Loading ...');
        if(userName.length == 0 || userName == 'all'){
            userName = 'all';
            $scope.users = [];
            $scope.searchUserName='';
            $scope.skipValue = 0;
            $scope.updateUsers('all', 1);
        }else{
            $scope.searchUserName=userName;
            //$scope.updateUsers(userName, 0);
            $scope.updateUsers(userName, 1);
         }
    };

    $scope.loadMoreUsers = function(skipValue){
        $('.loadMoreBtn').attr('disabled','disabled');
        $('.loadMoreBtn').html('Loading... <i class="fa fa-circle-o-notch fa-spin"></i>').animate();
        $scope.updateUsers('all', skipValue);
    };

    $scope.users = [];

    $scope.updateUsers = function(userName, pageNumber){
//        console.log({userName: userName, skipValue: skipValue});
console.log("inside usersssssssssssss : "+userName);
var pageNumber = $scope.pageNumber;
$('.first').hide();
//$('.self').hide();
$('.previous').hide();
$('.next').hide();
$('.last').hide();
        $.ajax({
            url: $scope.BASE_FOLDER+'/users',
//            data: {userName: userName, skipValue: skipValue, csrf_token: $('.csrf_token').html()},
data: {userName: userName, pageNumber: pageNumber, csrf_token: $('.csrf_token').html()},
            type: 'POST'
        }).done(function(data){
            $('.loading').hide();
            blockUI.stop();
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
console.log("kkkkkkkkk : "+jData.metadata);
if(jData.metadata != ''){
$('.userListTableNavigate').show();	
$scope.previous = jData.metadata.links.previous;
$scope.next = jData.metadata.links.next;
$scope.last = jData.metadata.links.last;
//$scope.self = jData.metadata.links.self;
$scope.first = jData.metadata.links.first;
$scope.currentpageCount = jData.metadata.pageNumber;
$scope.totalpageCount = Math.ceil(jData.metadata.totalCount/jData.metadata.recordsPerPage);
}else{
$('.userListTableNavigate').hide();
}
if($scope.first){
$('.first').show();
}
/*if($scope.self){
$('.self').show();
}*/
if($scope.previous){
$('.previous').show();
}
if($scope.next){
$('.next').show();
}
if($scope.last){
$('.last').show();
}
/*console.log("prev : "+jData.metadata.links.previous);
console.log("next : "+jData.metadata.links.next);
console.log("last : "+jData.metadata.links.last);*/
//console.log("self : "+jData.metadata.links.self);
//console.log("first : "+jData.metadata.links.first);
                $('.userListTable').show();
                $('.nouser').hide();
if(userName == 'all'){
$scope.users = jData.users;
                        $scope.$apply();
}else{
$scope.users = jData.users;
                        $scope.$apply();
}
		  if(jData.users.length > 0){
			$('.userListTable').show();
			$('.userListTableNavigate').show();
			$('.nouserListTable').hide();
		  }else{
			$('.userListTable').hide();
			$('.userListTableNavigate').hide();
			$('.nouserListTable').show();
		  }
/*                if(userName == 'all'){
                    if(jData.users.length <= 0){
                        $scope.$applyAsync(function () { blockUI.stop(); });
                        $('.nouser').show();
                    }
                    if(jData.users.length > 0){
                        $('.loading').hide();                        
                        $scope.skipValue = $scope.skipValue+1;
                            jData.users.forEach(function($value){
                                $scope.users.push($value);
                            });
                        $scope.$apply();
                        $('.loading').hide();
                        $('.userListTable').show();
                        $('.loadMoreBtn').removeAttr('disabled');
                        $('.loadMoreBtn').html('Load More ...');
                        $('.loadMoreBtn').show();
                        $('.loadMore').show();
                    }else{
                        $('.loadMore').hide();
                        $('.nouser').hide();
                    }
                }else{
                    if(jData.users.length > 0){
                        $scope.users = jData.users;
                        $scope.$apply();
                        $('.loadMore').hide();
                        $('.nouser').hide();
                    }else{
                        $('.loading').hide();
                        $('.nouser').show();
                        $('.userListTable').hide();
                        $('[name="searchUsername"]').popover('show');
                    }
                }*/
            }/*else{
                toastr.error('Due to some technical issues complete details was not retrieved, please try again later', 'Fail!!!', {allowHtml: true});
                $scope.$apply();
                $('.loadMoreBtn').removeAttr('disabled');
                $('.loadMoreBtn').html('Load More ...');
                $('.loadMoreBtn').show();
                $('.loadMore').hide();
                $('.nouser').show();
            }*/
        }).fail(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

//    $scope.updateUsers = function(userName, skipValue){
$scope.updateUsersNavigate = function(userName, url){
//        console.log({userName: userName, skipValue: skipValue});
console.log("inside usersssssssssssss");
var pageNumber = $scope.pageNumber;
$('.first').hide();
//$('.self').hide();
$('.previous').hide();
$('.next').hide();
$('.last').hide();
        $.ajax({
            url: $scope.BASE_FOLDER+'/users1',
//            data: {userName: userName, skipValue: skipValue, csrf_token: $('.csrf_token').html()},
data: {userName: userName, url: url, csrf_token: $('.csrf_token').html()},
            type: 'POST'
        }).done(function(data){
            $('.loading').hide();
            blockUI.stop();
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
if(jData.metadata != ''){
$('.userListTableNavigate').show();		    
$scope.previous = jData.metadata.links.previous;
$scope.next = jData.metadata.links.next;
$scope.last = jData.metadata.links.last;
//$scope.self = jData.metadata.links.self;
$scope.first = jData.metadata.links.first;
$scope.currentpageCount = jData.metadata.pageNumber;
$scope.totalpageCount = Math.ceil(jData.metadata.totalCount/jData.metadata.recordsPerPage);
}else{
$('.userListTableNavigate').hide();
}		    
if($scope.first){
$('.first').show();
}
/*if($scope.self){
$('.self').show();
}*/
if($scope.previous){
$('.previous').show();
}
if($scope.next){
$('.next').show();
}
if($scope.last){
$('.last').show();
}
console.log("prev : "+jData.metadata.links.previous);
console.log("next : "+jData.metadata.links.next);
console.log("last : "+jData.metadata.links.last);
//console.log("self : "+jData.metadata.links.self);
console.log("first : "+jData.metadata.links.first);
                $('.userListTable').show();
                $('.nouser').hide();
if(userName == 'all'){
$scope.users = jData.users;
                        $scope.$apply();
}else{
$scope.users = jData.users;
                        $scope.$apply();
}
  		  if(jData.users.length > 0){
			$('.userListTable').show();
			$('.userListTableNavigate').show();
			$('.nouserListTable').hide();
		  }else{
			$('.userListTable').hide();
			$('.userListTableNavigate').hide();
			$('.nouserListTable').show();
		  }
/*                if(userName == 'all'){
                    if(jData.users.length <= 0){
                        $scope.$applyAsync(function () { blockUI.stop(); });
                        $('.nouser').show();
                    }
                    if(jData.users.length > 0){
                        $('.loading').hide();                        
                        $scope.skipValue = $scope.skipValue+1;
                            jData.users.forEach(function($value){
                                $scope.users.push($value);
                            });
                        $scope.$apply();
                        $('.loading').hide();
                        $('.userListTable').show();
                        $('.loadMoreBtn').removeAttr('disabled');
                        $('.loadMoreBtn').html('Load More ...');
                        $('.loadMoreBtn').show();
                        $('.loadMore').show();
                    }else{
                        $('.loadMore').hide();
                        $('.nouser').hide();
                    }
                }else{
                    if(jData.users.length > 0){
                        $scope.users = jData.users;
                        $scope.$apply();
                        $('.loadMore').hide();
                        $('.nouser').hide();
                    }else{
                        $('.loading').hide();
                        $('.nouser').show();
                        $('.userListTable').hide();
                        $('[name="searchUsername"]').popover('show');
                    }
                }*/
            }/*else{
                toastr.error('Due to some technical issues complete details was not retrieved, please try again later', 'Fail!!!', {allowHtml: true});
                $scope.$apply();
                $('.loadMoreBtn').removeAttr('disabled');
                $('.loadMoreBtn').html('Load More ...');
                $('.loadMoreBtn').show();
                $('.loadMore').hide();
                $('.nouser').show();
            }*/
        }).fail(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    $scope.exportUsersToExcel = function(){
    userName=$scope.searchUserName;
        $.ajax({
            url: $scope.BASE_FOLDER+'/user/exportUsers',
            data: {csrf_token: $('.csrf_token').html() , userName : userName},
            type: 'POST'
        }).done(function(data){
            blockUI.stop();
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
                window.location.href = $scope.BASE_FOLDER+'/user/downloadUsersExcel';
                toastr.success('Users list export generated', {allowHtml: true}); 
            }else{
                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
            }
        }).fail(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    $scope.updateUserDevices = function(username){
        $('.loading').html('Loading ...');
        if(username){
            $.ajax({
                url: $scope.BASE_FOLDER+'/user/devices',
                data: {userName: username},
                type: 'POST'
            }).done(function(data){
                blockUI.stop();
                var jData = JSON.parse(data);
                console.log(jData);
                if(jData.result == 'success'){
                    $('.userDevices').show();
                    if(jData.devices == 0){
                        $('.userDevices').hide();
                        $('.loading').show();
                        $('.loading').html('<br/>No Devices have been configured');
                    }else{
                        $('.loading').hide();
                    }
                    if(jData.assignDevices.length > 0){
                        $('.assignDevices').show();
                    }
                    if(jData.blockedDevices.length > 0){
                        $('.blockedDevices').show();
                    }
                    if(jData.policyconfiguration){
                        if(jData.policyconfiguration == "false"){
                            $scope.policyconfiguration = jData.policyconfiguration;
                        }
                    }
                    $scope.userDevices = jData.devices;
                    $scope.userStorage = jData.used;
                    $scope.userLimit = jData.limit;
                    $scope.assignDevices = jData.assignDevices;
                    $scope.blockedDevices = jData.blockedDevices;
                    $scope.assignDevices = jData.blockedDevices.concat(jData.assignDevices);
                    $scope.$apply();
                    var storageData = [
                        {
                            value: jData.used,
                            color:"#F7464A",
                            highlight: "#FF5A5E",
                            label: "Used"
                        },
                        {
                            value: jData.free,
                            color:"#2095f2",
                            highlight: "#115d90",
                            label: "Free"
                        }
                    ];

                    var options = {
                        segmentShowStroke : true,
                        segmentStrokeColor : "#fff",
                        segmentStrokeWidth : 2,
                        percentageInnerCutout : 50,
                        animationSteps : 100,
                        animationEasing : "easeOutBounce",
                        animateRotate : true,
                        animateScale : true,
                        legendTemplate : "<ul class=\"<%=name.toLowerCase()%>-legend\"><% for (var i=0; i<segments.length; i++){%><li><span style=\"background-color:<%=segments[i].fillColor%>\"></span><%if(segments[i].label){%><%=segments[i].label%><%}%></li><%}%></ul>"
                    };
                    if(document.getElementById("storage")){
                        var storage = document.getElementById("storage").getContext("2d");
                        var myDoughnutChart = new Chart(storage).Doughnut(storageData,options);
                    }

                }else{
                    //do something to stop displaying the users list
                }
            }).fail(function(data){
                toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
                if(data.status == 424){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/sleep';
                    }, 3000);
                }else if(data.status == 503){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                    }, 3000);
                }
            });
        }
    };

    $scope.updateUserDevicePolicyInfo = function(){
        $('.loading').html('Loading ...');
        $('.loading').show();
        $.ajax({
            url: $scope.BASE_FOLDER+'/user/device/policyInfo',
            data: {token: ''},
            type: 'POST'
        }).done(function(data){
            blockUI.stop();
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
                $scope.currentUser.maxSizeAllowed = jData.maxSizeAllowed;
                $scope.currentUser.defaultFolders = jData.defaultFolders;
                $scope.currentUser.fileTypes = jData.fileTypes;
                $scope.currentUser.filterType = jData.filterType;
                $scope.currentUser.userDefinedFolders = jData.userDefinedFolders;
                $scope.currentUser.userExcludedFolders = jData.userExcludedFolders;
                $scope.$apply();
            }else{
                toastr.error(jData.message, 'Fail!!!', {allowHtml: true});
            }
        }).fail(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    $scope.addInclusionFolder = function(folder){
	if(folder.indexOf('*') > -1){
		$('#inclusionFolderName').attr('data-content', 'Please check the path, special character * is not allowed.');
		$('[name="inclusionFolderName"]').popover('show');
		return;
	}
        if($scope.currentUser.defaultFolders.length > 0){
            $scope.currentUser.defaultFolders.forEach(function(value){
                if(value == folder || value.toLowerCase() == folder.toLowerCase()){
                    folder = 'exist';
		    }

            });
        }
        $scope.currentUser.userDefinedFolders.forEach(function(value){
                        if(value == folder || value.toLowerCase() == folder.toLowerCase()){
                            folder = 'exist';
                        }
        
                    });
        if(folder == 'exist'){
        $('#confirmAdd').modal('show');
        }else{
        $scope.addIt();
        }
    };
    $scope.addIt = function(){
        var folder = $('[name="inclusionFolderName"]').val();
        $('.loading').html('Loading ...');
        $('.loading').show();
        var folder1 = folder;
        if(folder.indexOf('\'') >= 0){
            folder1 = folder.replace(/'/g, "%27");
        }
        if(folder.indexOf('+') >= 0){
            folder1 = folder.replace(/\+/g, "%2B");
        }
        folder1 = folder1.replace(/\u2069 \u25b8 \u2068/g, "/");
        folder1 = folder1.replace(/\u2069/g, "");
        folder1 = folder1.replace(/%E2%81%A9%20%E2%96%B8%20%E2%81%A8/g, "/");
        folder1 = folder1.replace(/%E2%81%A9%2F/g, "/");
        folder1 = encodeURIComponent(folder1);
        $.ajax({
            url: $scope.BASE_FOLDER+'/user/device/policyInfo/addInclusionFolder',
            data: {folder: folder1, csrf_token: $('[name="csrf_token"]').val(),userName : $(".currentUser").html()},
            type: 'POST'
        }).done(function(data){
            blockUI.stop();
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
                $('[name="inclusionFolderName"]').val('');
                $scope.currentUser.userDefinedFolders.push(folder);
                $("#confirmAdd").modal('hide');
                toastr.success(jData.msg, 'Successful!!!', {allowHtml: true});
            }else{
                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
            }
        }).fail(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    $scope.removeInclusionFolder = function($index, confirmed){
        if(confirmed == 'true'){
            var folder = $scope.currentUser.userDefinedFolders[$index];
                if(folder.indexOf('\'') >= 0){
                folder = folder.replace(/'/g, "%27");
                }
                if(folder.indexOf('+') >= 0){
                folder = folder.replace(/\+/g, "%2B");
            }
            folder = folder.replace(/\u2069 \u25b8 \u2068/g, "/");
            folder = folder.replace(/\u2069/g, "");
            folder = folder.replace(/%E2%81%A9%20%E2%96%B8%20%E2%81%A8/g, "/");
            folder = folder.replace(/%E2%81%A9%2F/g, "/");
            folder = encodeURIComponent(folder);
            $.ajax({
                url: $scope.BASE_FOLDER+'/user/device/policyInfo/removeInclusionFolder',
                data: {folder: folder, csrf_token: $('[name="csrf_token"]').val(),userName : $(".currentUser").html()},
                type: 'POST'
            }).done(function(data){
                blockUI.stop();
                var jData = JSON.parse(data);
                if(jData.result == 'success'){
                    $scope.currentUser.userDefinedFolders.splice($index, 1);
                    toastr.success(jData.msg, 'Successful!!!', {allowHtml: true});
                }else{
                    toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
                }
            }).fail(function(data){
                toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
                if(data.status == 424){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/sleep';
                    }, 3000);
                }else if(data.status == 503){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                    }, 3000);
                }
            });
        }
    };

    $scope.addDefaultFolderConfirm = function($value){
        var pattern = new RegExp(':');
        var value = $('[name="inclusionFolderName"]').val();
        if($('[name="osType"]').val() == 'windows'){
            value = value.replace(/\/+$/,'');
            value = value.replace(/\\+$/,'');
            value = value.concat('\\');
            value = value.replace(/\//g, '\\')
            $scope.currentUser.userDefinedFolders.push(value);
        }else if($('[name="osType"]').val() == 'universal'){
            if(pattern.test(value)){
                value = value.replace(/\/+$/,'');
                value = value.replace(/\\+$/,'');
                value = value.concat('\\');
                value = value.replace(/\//g, '\\')
            }else{
                value = value.replace(/\/+$/,'');
                value = value.replace(/\\+$/,'');
                value = value.concat('\/');
                value = value.replace(/\\/g, "/");
            }
            $scope.currentUser.userDefinedFolders.push(value);
        }else if($('[name="osType"]').val() == 'mac'){
            value = value.replace(/\/+$/,'');
            value = value.replace(/\\+$/,'');
            value = value.concat('\/');
            value = value.replace(/\\/g, "/");
            $scope.currentUser.userDefinedFolders.push(value);
        }
                            toastr.success('Selected Folder has been added successfully', 'Success!!!', {allowHtml: true});
        $('#confirmAdd').modal('hide');
        $('[name="inclusionFolderName"]').val('');
    };

    function sanitizeValues(folder, $folders){
		$scope.child = 'false';
		$scope.parent = 'false';
        var pattern = new RegExp(':');
        var result = '';
        var home = '{user.home}';
        if($scope.currentOs == 'windows') {
            if(folder == '' || folder == null){
                return false;
            }else{
                if(pattern.test(folder)){
                    if(folder.split(':', 1).join(':').length == 1){
                        folder = folder.replace(/\/+$/,'');
                        folder = folder.replace(/\\+$/,'');
                        folder = folder.concat('\\');
                        folder = folder.replace(/\//g, '\\');
                        //folder = folder.toLowerCase();
                        $folders.forEach(function(value){
                            console.log("Folder : "+folder+ " Value : "+value);
                            //if(folder.indexOf(value.toLowerCase()) > -1 || value.indexOf(folder.toLowerCase()) > -1){
                            if(folder.indexOf(value) > -1 || value.indexOf(folder) > -1 || folder.indexOf(value.toLowerCase()) > -1 || value.indexOf(folder.toLowerCase()) > -1){
                                console.log("Res : True");
                                result = 'exist';
								$("#confirmAdd").modal('show');
                            }
							//if(value.indexOf(folder.toLowerCase()) > -1){
							if(value.indexOf(folder) > -1 || value.indexOf(folder.toLowerCase()) > -1){
							console.log('inside new');
							$("#confirmAdd").modal('show');
							$scope.child = 'true';
							}
						});

                        if(result != 'exist'){ return folder; }else{ return result; }

                    }else{
						$('[name="inclusionFolderName"]').popover('show');
                        return false;
                    }
                }else{
                    if(folder.includes(home) || folder == 'ALL'){
                    //if(folder == '{user.home}' || folder == 'ALL'){
                        $folders.forEach(function(value){
                            //if(folder.indexOf(value.toLowerCase()) > -1 || value.indexOf(folder.toLowerCase()) > -1){
                            if(folder.indexOf(value) > -1 || value.indexOf(folder) > -1 || folder.indexOf(value.toLowerCase()) > -1 || value.indexOf(folder.toLowerCase()) > -1){
                                result = 'exist'
                            }
                        });

                        if(result != 'exist'){ return folder; }else{ return result; }
                    }else{
						$('[name="inclusionFolderName"]').popover('show');
                        return false;
                    }
                }
            }
        }else if($scope.currentOs == 'universal'){
            if(pattern.test(folder)){
                    if(folder.split(':', 1).join(':').length == 1){
                        folder = folder.replace(/\/+$/,'');
                        folder = folder.replace(/\\+$/,'');
                        folder = folder.concat('\\');
                        folder = folder.replace(/\//g, '\\');
                        //folder = folder.toLowerCase();
                        $folders.forEach(function(value){
                            console.log("Folder : "+folder+ " Value : "+value);
                            //if(folder.indexOf(value.toLowerCase()) > -1 || value.indexOf(folder.toLowerCase()) > -1){
                            if(folder.indexOf(value) > -1 || value.indexOf(folder) > -1 || folder.indexOf(value.toLowerCase()) > -1 || value.indexOf(folder.toLowerCase()) > -1){
                                console.log("Res : True");
                                result = 'exist';
								$("#confirmAdd").modal('show');
                            }
							//if(value.indexOf(folder.toLowerCase()) > -1){
							if(value.indexOf(folder) > -1 || value.indexOf(folder.toLowerCase()) > -1){
							console.log('inside new');
							$("#confirmAdd").modal('show');
							$scope.child = 'true';
							}
						});

                        if(result != 'exist'){ return folder; }else{ return result; }

                    }else{
						$('[name="inclusionFolderName"]').popover('show');
                        return false;
                    }
                }else if(folder.includes(home) || folder == 'ALL'){
                        //if(folder == '{user.home}' || folder == 'ALL'){
                        $folders.forEach(function(value){
                            //if(folder.indexOf(value.toLowerCase()) > -1 || value.indexOf(folder.toLowerCase()) > -1){
                            if(folder.indexOf(value) > -1 || value.indexOf(folder) > -1 || folder.indexOf(value.toLowerCase()) > -1 || value.indexOf(folder.toLowerCase()) > -1){
                                result = 'exist';
								$('#confirmAdd').modal('show');
                            }
                        });

                        if(result != 'exist'){ return folder; }else{ return result; }
                }else if(!pattern.test(folder)){
                    if(folder.split(':', 1).join(':').length != 1){
                        folder = folder.replace(/\/+$/,'');
                        folder = folder.replace(/\\+$/,'');
                        folder = folder.concat('\/');
                        folder = folder.replace(/\\/g, "/");
                        //folder = folder.toLowerCase();
                        $folders.forEach(function(value){
                            //if(folder.indexOf(value.toLowerCase()) > -1){
                            if(folder.indexOf(value) > -1 || folder.indexOf(value.toLowerCase()) > -1){
                                result = 'exist'
								$('#confirmAdd').modal('show');
                            }
							//if(value.indexOf(folder.toLowerCase()) > -1){
							if(value.indexOf(folder) > -1 || value.indexOf(folder.toLowerCase()) > -1){
							console.log('inside new');
							$scope.child = 'true';
							$('#confirmAdd').modal('show');
							}
                        });
						$scope.userExcludedFoldersMac.forEach(function(value){
							if(folder.includes(value) == true || folder.toLowerCase().includes(value.toLowerCase()) == true){
							    result = "exist";
							$('#confirmAdd').modal('show');
							$scope.parent = 'true';
							    }
                        });

                        if(result != 'exist'){ return folder; }else{ return result; }

                    }else{
						$('[name="inclusionFolderName"]').popover('show');
                        return false;
                    }
                }
                else {
                		$('[name="inclusionFolderName"]').popover('show');
                        return false;
                }
        }else{
            if(folder == '' || folder == null){
                return false;
            }else{
                if(folder == '{user.home}' || folder == 'ALL'){
                        $folders.forEach(function(value){
                            //if(folder.indexOf(value.toLowerCase()) > -1){
                            if(folder.indexOf(value) > -1 || folder.indexOf(value.toLowerCase()) > -1){
                                result = 'exist'
								$('#confirmAdd').modal('show');
                            }
                        });

                        if(result != 'exist'){ return folder; }else{ return result; }
                    }
                else if(!pattern.test(folder)){
                    if(folder.split(':', 1).join(':').length != 1){
                        folder = folder.replace(/\/+$/,'');
                        folder = folder.replace(/\\+$/,'');
                        folder = folder.concat('\/');
                        folder = folder.replace(/\\/g, "/");
                        //folder = folder.toLowerCase();
                        $folders.forEach(function(value){
                            //if(folder.indexOf(value.toLowerCase()) > -1){
                            if(folder.indexOf(value) > -1 || folder.indexOf(value.toLowerCase()) > -1){
                                result = 'exist'
								$('#confirmAdd').modal('show');
                            }
							//if(value.indexOf(folder.toLowerCase()) > -1){
							if(value.indexOf(folder) > -1 || value.indexOf(folder.toLowerCase()) > -1){
							console.log('inside new');
							$scope.child = 'true';
							$('#confirmAdd').modal('show');
							}
                        });

                        if(result != 'exist'){ return folder; }else{ return result; }

                    }else{
						$('[name="inclusionFolderName"]').popover('show');
                        return false;
                    }
                }else{
						$('[name="inclusionFolderName"]').popover('show');
                        return false;
                }
            }
        }
    }

    $scope.addExclusionFolder = function(folder){
	if(folder.indexOf('*') > -1){
		$('#exclusionFolderName').attr('data-content', 'Please check the path, special character * is not allowed.');
		$('[name="exclusionFolderName"]').popover('show');
		return;
	}
        $scope.currentUser.userExcludedFolders.forEach(function(value){
                        if(value == folder || value.toLowerCase() == folder.toLowerCase()){
                            folder = 'exist';
                        }
        
                    });
        if(folder == 'exist'){
        $('#confirmAdd1').modal('show');
        }else{
        $scope.addEx();
        }
    };
    $scope.addEx = function(){
        var folder = $('[name="exclusionFolderName"]').val();
        $('.loading').html('Loading ...');
        $('.loading').show();
        var folder1 = folder;
        if(folder.indexOf('\'') >= 0){
            folder1 = folder.replace(/'/g, "%27");
        }
        if(folder.indexOf('+') >= 0){
            folder1 = folder.replace(/\+/g, "%2B");
        }
        folder1 = folder1.replace(/\u2069 \u25b8 \u2068/g, "/");
            folder1 = folder1.replace(/\u2069/g, "");
            folder1 = folder1.replace(/%E2%81%A9%20%E2%96%B8%20%E2%81%A8/g, "/");
            folder1 = folder1.replace(/%E2%81%A9%2F/g, "/");
            folder1 = encodeURIComponent(folder1);
        $.ajax({
            url: $scope.BASE_FOLDER+'/user/device/policyInfo/addExclusionFolder',
            data: {folder: folder1, csrf_token: $('[name="csrf_token"]').val(),userName : $(".currentUser").html()},
            type: 'POST'
        }).done(function(data){
            blockUI.stop();
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
                $('[name="exclusionFolderName"]').val('');
                $scope.currentUser.userExcludedFolders.push(folder);
                $('#confirmAdd1').modal('hide');
                toastr.success(jData.msg, 'Successful!!!', {allowHtml: true});
            }else{
                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
            }
        }).fail(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    $scope.addExclusionFolderConfirm = function($value){
        var pattern = new RegExp(':');
        var value = $('[name="exclusionFolderName"]').val();
        if($('[name="osType"]').val() == 'windows'){
            value = value.replace(/\/+$/,'');
            value = value.replace(/\\+$/,'');
            value = value.concat('\\');
            value = value.replace(/\//g, '\\')
            $scope.currentUser.userExcludedFolders.push(value);
        }else if($('[name="osType"]').val() == 'universal'){
            if(pattern.test(value)){
                value = value.replace(/\/+$/,'');
                value = value.replace(/\\+$/,'');
                value = value.concat('\\');
                value = value.replace(/\//g, '\\')
            }else{
                value = value.replace(/\/+$/,'');
                value = value.replace(/\\+$/,'');
                value = value.concat('\/');
                value = value.replace(/\\/g, "/");
            }
            $scope.currentUser.userExcludedFolders.push(value);
        
        }else if($('[name="osType"]').val() == 'mac'){
            value = value.replace(/\/+$/,'');
            value = value.replace(/\\+$/,'');
            value = value.concat('\/');
            value = value.replace(/\\/g, "/");
            $scope.currentUser.userExcludedFolders.push(value);
        }
        toastr.success('Selected Folder has been added successfully', 'Success!!!', {allowHtml: true});
        $('#confirmAdd1').modal('hide');
        $('[name="exclusionFolderName"]').val('');
    };

    $scope.removeExclusionFolder = function($index, confirmed){
        if(confirmed == 'true'){
            var folder = $scope.currentUser.userExcludedFolders[$index];
            if(folder.indexOf('\'') >= 0){
                folder = folder.replace(/'/g, "%27");
            }
            if(folder.indexOf('+') >= 0){
                folder = folder.replace(/\+/g, "%2B");
            }
            folder = folder.replace(/\u2069 \u25b8 \u2068/g, "/");
            folder = folder.replace(/\u2069/g, "");
            folder = folder.replace(/%E2%81%A9%20%E2%96%B8%20%E2%81%A8/g, "/");
            folder = folder.replace(/%E2%81%A9%2F/g, "/");
            folder = encodeURIComponent(folder);
            $.ajax({
                url: $scope.BASE_FOLDER+'/user/device/policyInfo/removeExclusionFolder',
                data: {folder: folder, csrf_token: $('[name="csrf_token"]').val(),userName : $(".currentUser").html()},
                type: 'POST'
            }).done(function(data){
                blockUI.stop();
                var jData = JSON.parse(data);
                if(jData.result == 'success'){
                    $scope.currentUser.userExcludedFolders.splice($index, 1);
                    toastr.success(jData.msg, 'Successful!!!', {allowHtml: true});
                }else{
                    toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
                }
            }).fail(function(data){
                toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
                if(data.status == 424){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/sleep';
                    }, 3000);
                }else if(data.status == 503){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                    }, 3000);
                }
            });
        }
    };

    function checkForValidPath(folder, $folders){
		$scope.child = 'false';
		$scope.parent = 'false';
        var pattern = new RegExp(':');
        var result = '';
        var home = '{user.home}';
        if($scope.currentOs == 'windows') {
            if(folder == '' || folder == null){
                return false;
            }else{
                if(pattern.test(folder)){
                    if(folder.split(':', 1).join(':').length == 1){
                        folder = folder.replace(/\/+$/,'');
                        folder = folder.replace(/\\+$/,'');
                        folder = folder.concat('\\');
                        folder = folder.replace(/\//g, '\\');
                        //folder = folder.toLowerCase();
                        $folders.forEach(function(value){
                            console.log("Folder : "+folder+ " Value : "+value);
                            //if(folder.indexOf(value.toLowerCase()) > -1 || value.indexOf(folder.toLowerCase()) > -1){
                            if(folder.indexOf(value) > -1 || value.indexOf(folder) > -1 || folder.indexOf(value.toLowerCase()) > -1 || value.indexOf(folder.toLowerCase()) > -1){
                                console.log("Res : True");
                                result = 'exist';
								$("#confirmAdd1").modal('show');
                            }
							//if(value.indexOf(folder.toLowerCase()) > -1){
							if(value.indexOf(folder) > -1 || value.indexOf(folder.toLowerCase()) > -1){
							console.log('inside new');
							$("#confirmAdd1").modal('show');
							$scope.child = 'true';
							}
						});
						$scope.currentUser.userExcludedFolders.forEach(function(value){
							if(folder.includes(value) == true || folder.toLowerCase().includes(value.toLowerCase()) == true){
							    result = "exist";
							$("#confirmAdd1").modal('show');
							$scope.parent = 'true';
							    }
						});

                        if(result != 'exist'){ return folder; }else{ return result; }

                    }else{
						$('[name="exclusionFolderName"]').popover('show');
                        return false;
                    }
                }else{
                    if(folder.includes(home) || folder == 'ALL'){
                    //if(folder == '{user.home}' || folder == 'ALL'){
                        $folders.forEach(function(value){
                            //if(folder.indexOf(value.toLowerCase()) > -1 || value.indexOf(folder.toLowerCase()) > -1){
                            if(folder.indexOf(value) > -1 || value.indexOf(folder) > -1 || folder.indexOf(value.toLowerCase()) > -1 || value.indexOf(folder.toLowerCase()) > -1){
                                result = 'exist'
                            }
                        });

                        if(result != 'exist'){ return folder; }else{ return result; }
                    }else{
						$('[name="exclusionFolderName"]').popover('show');
                        return false;
                    }
                }
            }
        }else if($scope.currentOs == 'universal'){
            if(pattern.test(folder)){
                    if(folder.split(':', 1).join(':').length == 1){
                        folder = folder.replace(/\/+$/,'');
                        folder = folder.replace(/\\+$/,'');
                        folder = folder.concat('\\');
                        folder = folder.replace(/\//g, '\\');
                        //folder = folder.toLowerCase();
                        $folders.forEach(function(value){
                            console.log("Folder : "+folder+ " Value : "+value);
                            //if(folder.indexOf(value.toLowerCase()) > -1 || value.indexOf(folder.toLowerCase()) > -1){
                            if(folder.indexOf(value) > -1 || value.indexOf(folder) > -1 || folder.indexOf(value.toLowerCase()) > -1 || value.indexOf(folder.toLowerCase()) > -1){
                                console.log("Res : True");
                                result = 'exist';
								$("#confirmAdd1").modal('show');
                            }
							//if(value.indexOf(folder.toLowerCase()) > -1){
							if(value.indexOf(folder) > -1 || value.indexOf(folder.toLowerCase()) > -1){
							console.log('inside new');
							$("#confirmAdd1").modal('show');
							$scope.child = 'true';
							}
						});
						$scope.currentUser.userExcludedFolders.forEach(function(value){
							if(folder.includes(value) == true || folder.toLowerCase().includes(value.toLowerCase()) == true){
							    result = "exist";
							$("#confirmAdd1").modal('show');
							$scope.parent = 'true';
							    }
						});

                        if(result != 'exist'){ return folder; }else{ return result; }

                    }else{
						$('[name="exclusionFolderName"]').popover('show');
                        return false;
                    }
                }else if(folder.includes(home) || folder == 'ALL'){
                        //if(folder == '{user.home}' || folder == 'ALL'){
                        $folders.forEach(function(value){
                            //if(folder.indexOf(value.toLowerCase()) > -1 || value.indexOf(folder.toLowerCase()) > -1){
                            if(folder.indexOf(value) > -1 || value.indexOf(folder) > -1 || folder.indexOf(value.toLowerCase()) > -1 || value.indexOf(folder.toLowerCase()) > -1){
                                result = 'exist';
								$('#confirmAdd1').modal('show');
                            }
                        });

                        if(result != 'exist'){ return folder; }else{ return result; }
                }else if(!pattern.test(folder)){
                    if(folder.split(':', 1).join(':').length != 1){
                        folder = folder.replace(/\/+$/,'');
                        folder = folder.replace(/\\+$/,'');
                        folder = folder.concat('\/');
                        folder = folder.replace(/\\/g, "/");
                        //folder = folder.toLowerCase();
                        $folders.forEach(function(value){
                            //if(folder.indexOf(value.toLowerCase()) > -1){
                            if(folder.indexOf(value) > -1 || folder.indexOf(value.toLowerCase()) > -1){
                                result = 'exist'
								$('#confirmAdd1').modal('show');
                            }
							//if(value.indexOf(folder.toLowerCase()) > -1){
							if(value.indexOf(folder) > -1 || value.indexOf(folder.toLowerCase()) > -1){
							console.log('inside new');
							$scope.child = 'true';
							$('#confirmAdd1').modal('show');
							}
                        });
						$scope.currentUser.userExcludedFolders.forEach(function(value){
							if(folder.includes(value) == true || folder.toLowerCase().includes(value.toLowerCase()) == true){
							    result = "exist";
							$('#confirmAdd1').modal('show');
							$scope.parent = 'true';
							    }
                        });

                        if(result != 'exist'){ return folder; }else{ return result; }

                    }else{
						$('[name="exclusionFolderName"]').popover('show');
                        return false;
                    }
                }
                else {
                		$('[name="exclusionFolderName"]').popover('show');
                        return false;
                }

        }else{
            if(folder == '' || folder == null){
                return false;
            }else{
                if(folder == '{user.home}' || folder == 'ALL'){
                        $folders.forEach(function(value){
                            //if(folder.indexOf(value.toLowerCase()) > -1){
                            if(folder.indexOf(value) > -1 || folder.indexOf(value.toLowerCase()) > -1){
                                result = 'exist'
								$('#confirmAdd1').modal('show');
                            }
                        });

                        if(result != 'exist'){ return folder; }else{ return result; }
                    }
                else if(!pattern.test(folder)){
                    if(folder.split(':', 1).join(':').length != 1){
                        folder = folder.replace(/\/+$/,'');
                        folder = folder.replace(/\\+$/,'');
                        folder = folder.concat('\/');
                        folder = folder.replace(/\\/g, "/");
                        //folder = folder.toLowerCase();
                        $folders.forEach(function(value){
                            //if(folder.indexOf(value.toLowerCase()) > -1){
                            if(folder.indexOf(value) > -1 || folder.indexOf(value.toLowerCase()) > -1){
                                result = 'exist'
								$('#confirmAdd1').modal('show');
                            }
							//if(value.indexOf(folder.toLowerCase()) > -1){
							if(value.indexOf(folder) > -1 || value.indexOf(folder.toLowerCase()) > -1){
							console.log('inside new');
							$scope.child = 'true';
							$('#confirmAdd1').modal('show');
							}
                        });
						$scope.currentUser.userExcludedFolders.forEach(function(value){
							if(folder.includes(value) == true || folder.toLowerCase().includes(value.toLowerCase()) == true){
							    result = "exist";
							$('#confirmAdd1').modal('show');
							$scope.parent = 'true';
							    }
                        });

                        if(result != 'exist'){ return folder; }else{ return result; }

                    }else{
						$('[name="exclusionFolderName"]').popover('show');
                        return false;
                    }
                }else{
						$('[name="exclusionFolderName"]').popover('show');
                        return false;
                }
            }
        }
    }

    $scope.viewDeviceDetails = function($index, deviceUUID, type, deviceType){
        /*if($('.userDevice'+$index).hasClass('expand')){
            $('.userDevice'+$index).removeClass('expand');
            $('.userDevice'+$index).addClass('col-lg-4');
            $('.userDevice'+$index+' .eye i').addClass('fa-eye');
            $('.userDevice'+$index+' .eye i').removeClass('fa-times');
            $('.expandDetails'+$index).hide();
            $('.fileListBtn'+$index).show();
        }else{
            $('.userDevice'+$index).removeClass('col-lg-4');
            $('.userDevice'+$index).addClass('expand');
            $('.userDevice'+$index+' .eye i').removeClass('fa-eye');
            $('.userDevice'+$index+' .eye i').addClass('fa-times');
            var myBlockUI = blockUI.instances.get('myBlockUI'+$index);*/
            if($('.userDevice'+type+$index).hasClass('expand')){
            $scope.limit = 20;
            $('.userDevice'+type+$index).removeClass('expand');
            $('.userDevice'+type+$index).addClass('col-lg-4');
            $('.userDevice'+type+$index+' .eye i').addClass('fa-eye');
            $('.userDevice'+type+$index+' .eye i').removeClass('fa-times');
            $('.expandDetails'+type+$index).hide();
            $('.fileListBtn'+type+$index).show();
        }else{
            $scope.limit = 100;
            $('.userDevice'+type+$index).removeClass('col-lg-4');
            $('.userDevice'+type+$index).addClass('expand');
            $('.userDevice'+type+$index+' .eye i').removeClass('fa-eye');
            $('.userDevice'+type+$index+' .eye i').addClass('fa-times');
            var myBlockUI = blockUI.instances.get('myBlockUI'+type+$index);
            myBlockUI.start();
            $.ajax({
                url: $scope.BASE_FOLDER+'/user/device/deviceDetails',
                data: {deviceUUID: deviceUUID, csrf_token: $('[name="csrf_token"]').val()},
                type: 'POST'
            }).done(function(data){
                myBlockUI.stop();
                var jData = JSON.parse(data);
                if(jData.result == 'success'){
                    $scope.deviceDetails = jData.deviceDetails;
                    $scope.$apply();
                    $('.expandDetails'+type+$index).show();
                    $('.fileListBtn'+type+$index).show();
                    $('.fileListBtn'+type+$index+' a').attr('href', $scope.BASE_FOLDER+'/backup/files/'+jData.deviceDetails.deviceId+'/'+jData.deviceDetails.deviceName+'/'+deviceUUID+'/'+deviceType);
                }else{
                    toastr.error(jData.message, 'Fail!!!', {allowHtml: true});
                }
            }).fail(function(data){
                toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
                if(data.status == 424){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/sleep';
                    }, 3000);
                }else if(data.status == 503){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                    }, 3000);
                }
            });
        }
    };

    $scope.viewDeviceDetailsFileList = function(deviceUUID, deviceType, deviceOs, userName, blocked){            
            var blockedkey;
            if(blocked == 'blocked'){
            blockedkey = 'blocked';
            }else{
            blockedkey = 'active';
            }
            console.log("blockedkey : "+blockedkey);
            $.ajax({
                url: $scope.BASE_FOLDER+'/user/device/deviceDetails',
                data: {deviceUUID: deviceUUID, csrf_token: $('[name="csrf_token"]').val()},
                type: 'POST'
            }).done(function(data){
                var jData = JSON.parse(data);
                if(jData.result == 'success'){
                    $scope.deviceDetails = jData.deviceDetails;
                    $scope.$apply();
                   $('.fileListBtn').attr('href', $scope.BASE_FOLDER+'/backup/files/'+jData.deviceDetails.deviceId+'/'+jData.deviceDetails.deviceName+'/'+deviceUUID+'/'+deviceType+'/'+deviceOs+'/'+userName+'/'+blockedkey);
                    window.location.href = $scope.BASE_FOLDER+'/backup/files/'+jData.deviceDetails.deviceId+'/'+jData.deviceDetails.deviceName+'/'+deviceUUID+'/'+deviceType+'/'+deviceOs+'/'+userName+'/'+blockedkey;
                }else{
                    toastr.error(jData.message, 'Fail!!!', {allowHtml: true});
                }
            }).fail(function(data){
                toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
                if(data.status == 424){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/sleep';
                    }, 3000);
                }else if(data.status == 503){
                setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                    }, 3000);
                }
            });
   };

    $scope.changePassword = function(){
        var password = $('#password').val();
        var rePassword = $('#rePassword').val();
        var html = $('#changePasswordBtn').html();
        $('#changePasswordBtn').attr('disabled','disabled');
        $('#changePasswordBtn').html('Loading... <i class="fa fa-circle-o-notch fa-spin"></i>').animate();
        if ( $('#changePasswordForm').parsley().isValid() && password == rePassword) {
            $.ajax({
                url: $scope.BASE_FOLDER+'/user/changePassword',
                data: $('#changePasswordForm').serialize(),
                type: 'POST'
            }).done(function(data){
                var jData = JSON.parse(data);
                if(jData.result == 'success'){
                    $('#changePassword').modal('hide');
                    $('#changePasswordBtn').html('Saved <i class="fa fa-check"></i>').animate();
                    toastr.success('Password Successfully changed', 'Success!!!');
                    $('#changePasswordBtn').html(html);
                    $('#changePasswordBtn').removeAttr('disabled');
                    $('#oldpassword').val('');
                    $('#password').val("");
                    $('#rePassword').val("");
                    setTimeout(function(){
                        location.reload();
                    }, 3000);
                    /*setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/logout';
                    }, 3000);*/
                }else if(jData.result == 'oldNotMatched'){
                    $('#changePasswordBtn').html('Failed <i class="fa fa-times"></i>').animate();
                    setTimeout(function(){
                        toastr.error('Old password did not match', 'Fail!!!');
                        $('#oldpassword').addClass('parsley-error');
                        $('#oldpassword').val('');
                        $('#changePasswordBtn').html(html);
                        $('#changePasswordBtn').removeAttr('disabled');
                    }, 1000);
                }else if(jData.result == 'oldNewSame'){
                    $('#changePasswordBtn').html('Failed <i class="fa fa-times"></i>').animate();
                    setTimeout(function(){
                        toastr.error('Old & New password cannot be same', 'Fail!!!');
                        $('#password').addClass('parsley-error');
                        $('#rePassword').addClass('parsley-error');
                        $('#password').val("");
                        $('#rePassword').val("");
                        $('#changePasswordBtn').html(html);
                        $('#changePasswordBtn').removeAttr('disabled');
                    }, 1000);
                }else{
                    $('#changePasswordBtn').html('Failed <i class="fa fa-times"></i>').animate();
                    setTimeout(function(){
                        toastr.error('Old & New password cannot be same', 'Fail!!!');
                        $('#password').addClass('parsley-error');
                        $('#rePassword').addClass('parsley-error');
                        $('#password').val("");
                        $('#rePassword').val("");
                        $('#changePasswordBtn').html(html);
                        $('#changePasswordBtn').removeAttr('disabled');
                    }, 1000);
                }
            }).fail(function(data){
                toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
                if(data.status == 424){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/sleep';
                    }, 3000);
                }else if(data.status == 503){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                    }, 3000);
                }
            });
        }
    };

    $scope.resetPassword = function(){
        var password = $('#password').val();
        var rePassword = $('#rePassword').val();
        var html = $('#changePasswordBtn').html();
        $('#changePasswordBtn').attr('disabled','disabled');
        $('#changePasswordBtn').html('Loading... <i class="fa fa-circle-o-notch fa-spin"></i>').animate();
        if ( $('#changePasswordForm').parsley().isValid() && password == rePassword) {
            $.ajax({
                url: $scope.BASE_FOLDER+'/user/resetPassword',
                data: $('#changePasswordForm').serialize(),
                type: 'POST'
            }).done(function(data){
                var jData = JSON.parse(data);
                if(jData.result == 'success'){
                    $('#changePassword').modal('hide');
                    $('#changePasswordBtn').html('Saved <i class="fa fa-check"></i>').animate();
                    toastr.success('Password Successfully changed', 'Success!!!');
                    $('#changePasswordBtn').html(html);
                    $('#changePasswordBtn').removeAttr('disabled');
                    $('#password').val("");
                    $('#rePassword').val("");
                    setTimeout(function(){
                    location.reload();
                    }, 3000);
                    /*setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/logout';
                    }, 3000);*/
                }else if(jData.result == 'oldNotMatched'){
                    $('#changePasswordBtn').html('Failed <i class="fa fa-times"></i>').animate();
                    setTimeout(function(){
                        toastr.error('Old password did not match', 'Fail!!!');
                        $('#oldpassword').addClass('parsley-error');
                        $('#oldpassword').val('');
                        $('#changePasswordBtn').html(html);
                        $('#changePasswordBtn').removeAttr('disabled');
                    }, 1000);
                }else{
                    $('#changePasswordBtn').html('Failed <i class="fa fa-times"></i>').animate();
                    setTimeout(function(){
                        toastr.error('Old & New password cannot be same', 'Fail!!!');
                        $('#password').addClass('parsley-error');
                        $('#rePassword').addClass('parsley-error');
                        $('#password').val("");
                        $('#rePassword').val("");
                        $('#changePasswordBtn').html(html);
                        $('#changePasswordBtn').removeAttr('disabled');
                    }, 1000);
                }
            }).fail(function(data){
                toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
                if(data.status == 424){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/sleep';
                    }, 3000);
                }else if(data.status == 503){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                    }, 3000);
                }
            });
        }
    };
    
    $scope.changePasswordForGuest = function(){

        var passwordGuest = $('#passwordGuest').val();
        var rePasswordGuest = $('#rePasswordGuest').val();
        console.log("passwordGuest : "+passwordGuest)

        var html = $('#changePasswordBtnGuest').html();
        $('#changePasswordBtnGuest').attr('disabled','disabled');
        $('#changePasswordBtnGuest').html('Loading... <i class="fa fa-circle-o-notch fa-spin"></i>').animate();

        if ( $('#changePasswordFormGuest').parsley().isValid() && passwordGuest == rePasswordGuest) {
            $.ajax({
                url: $scope.BASE_FOLDER+'/user/changePasswordForGuest',
                data: $('#changePasswordFormGuest').serialize(),
                type: 'POST'
            }).done(function(data){
                var jData = JSON.parse(data);
                if(jData.result == 'success'){
                    $('#changePasswordForGuest').modal('hide');
                    $('#changePasswordBtnGuest').html('Saved <i class="fa fa-check"></i>').animate();
                    setTimeout(function(){
                        toastr.success('Password Successfully changed', 'Success!!!');
                        $('#changePasswordBtnGuest').html(html);
                        $('#changePasswordBtnGuest').removeAttr('disabled');
                    }, 1000);
                    $('#passwordGuest').val("");
                    $('#rePasswordGuest').val("");
                    // location.reload();
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/logout';
                    }, 3000);
                }else{
                    $('#changePasswordBtnGuest').html('Failed <i class="fa fa-times"></i>').animate();
                    setTimeout(function(){
                        toastr.error('old & new password cannot be same', 'Fail!!!');
                        $('#passwordGuest').val("");
                        $('#rePasswordGuest').val("");
                        $('#changePasswordBtnGuest').html(html);
                        $('#changePasswordBtnGuest').removeAttr('disabled');
                    }, 1000);
                }
            }).fail(function(data){
                toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
                if(data.status == 424){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/sleep';
                    }, 3000);
                }else if(data.status == 503){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                    }, 3000);
                }
            });
        }
    };

    $scope.blockUnBlockMultipleUsers = function(active){
        var users;
        var arr = $('input.select-item:checkbox:checked').map(function () {
            return this.value;
           }).get();
        users = arr;
        //console.log('users_block '+users);
        if(users != null){
            var html;
            if(active == true){
                html = $('.unblock').html();
                $('.unblock').attr('disabled','disabled');
                $('.unblock').html('Loading... <i class="fa fa-circle-o-notch fa-spin"></i>').animate();
            }else{
                html = $('.block').html();
                $('.block').attr('disabled','disabled');
                $('.block').html('Loading... <i class="fa fa-circle-o-notch fa-spin"></i>').animate();
            }
            //console.log("usersD " +users);
            $.ajax({
                url: $scope.BASE_FOLDER+'/users/blockMultipleUsers',
                data: {users: users, active: active, csrf_token: $('.csrf_token').html()},
                type: 'POST'
            }).done(function(data){
                var jData = JSON.parse(data);
                if(jData.result == 'success'){
                    if(active == true){
                        $('#blockUserNames').tagsinput('removeAll');
                        $('.deleteUserNames').val(null).trigger("change");
                        $('.unblock').html(html);
                        $('.unblock').removeAttr('disabled');
                    }else{
                        $('#blockUserNames').tagsinput('removeAll');
                        $('.blockUserNames').val(null).trigger("change");
                        $('.block').html(html);
                        $('.block').removeAttr('disabled');
                    }
                    toastr.success(jData.msg, 'Successful!!!', {allowHtml: true});
                    setTimeout(function(){
                        window.location.reload(true);
                    }, 5000);
                }else{
                        if(active == true){
                            //toastr.error('Please select a user to Unblock', 'Fail!!!', {allowHtml: true});
                            toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
                            setTimeout(function(){
                                    window.location.reload(true);
                                }, 5000);
                        }else{
                            //toastr.error('Please select a user to block', 'Fail!!!', {allowHtml: true});
                            toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
                            setTimeout(function(){
                                    window.location.reload(true);
                                }, 5000);
                        }
                }
            }).fail(function(data){
                toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
                if(data.status == 424){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/sleep';
                    }, 3000);
                }else if(data.status == 503){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                    }, 3000);
                }
            });
        }else{
            if(active == true){
                toastr.error('Please select a user to Unblock', 'Fail!!!', {allowHtml: true});
            }else{
                toastr.error('Please select a user to block', 'Fail!!!', {allowHtml: true});
            }
        }
    };
    
    $scope.blockUsers = function(users){
	    $('.blockUsersPanel').show();
	    var luCount = 0;
	    document.getElementById("blockStatement").innerHTML = "";
	    $('#blockDump').hide();
        var myBlockUI = blockUI.instances.get('myBlockUI');
	    var type = $('.type').html(); 
        if(users != null){
            var html;
            $.ajax({
                url: $scope.BASE_FOLDER+'/blockUsers',
                data: {users: users, csrf_token: $('.csrf_token').html()},
                type: 'POST'
            }).done(function(data){
                blockUI.stop();
		    myBlockUI.stop();
                var jData = JSON.parse(data);
                $scope.userList = jData.naveen;
		    if(jData.naveen.length > 10){
			        $('.blockUsersPanel').css('overflowY', 'scroll');
                    $('.blockUsersPanel').height('500px');
                }
		    jData.naveen.forEach(function(value){
                 if(value.localUser != true || value.status == 'DELETED' || value.status == 'BLOCKED' || value.status == 'INVALID' || value.status == 'CurrentUser' || value.status == 'User does not exist or invalid'){
                     luCount = luCount+1;
                 }
                });
		    if(luCount > 0){
                document.getElementById("blockStatement").innerHTML = "One or more users cannot be blocked. Click on Download list to view details.";
			    $('#blockDump').show();
		    }
                if(jData.result == 'success'){
myBlockUI.stop();
                    $('.blockusers').show();
                    $('.block').removeAttr('disabled');
                }else{
                    toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
                }
		    $scope.$apply();
            }).fail(function(data){
                toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
                if(data.status == 424){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/sleep';
                    }, 3000);
                }else if(data.status == 503){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                    }, 3000);
                }
            });
        }else{
            if(active == true){
                toastr.error('Please select a user to Unblock', 'Fail!!!', {allowHtml: true});
            }else{
                toastr.error('Please select a user to block', 'Fail!!!', {allowHtml: true});
            }
        }
    };

    $scope.deleteMultipleUsers = function(){
        var users;
        var arr = $('input.select-item:checkbox:checked').map(function () {
  return this.value;
}).get();
        users = arr;
        //console.log('users_delete '+users);
        if(users != null){
            var html = $('.delete').html();
            $('.delete').attr('disabled','disabled');
            $('.delete').html('Loading... <i class="fa fa-circle-o-notch fa-spin"></i>').animate();
            $.ajax({
                url: $scope.BASE_FOLDER+'/users/deleteMultipleUsers',
                data: {users: users, csrf_token: $('.csrf_token').html()},
                type: 'POST'
            }).done(function(data){
                var jData = JSON.parse(data);
                //console.log('bbbb'+data);
                if(jData.result == 'success'){
                    $('.deleteUserNames').val(null).trigger("change");
                    $('.delete').html(html);
                    $('.delete').removeAttr('disabled');
                    toastr.success(jData.msg, 'Successful!!!', {allowHtml: true});
                    setTimeout(function(){
                        window.location.reload(true);
                    }, 5000);
                
                }else{
                    toastr.error('Please select a user to delete', 'Fail!!!', {allowHtml: true});
                setTimeout(function(){
                        window.location.reload(true);
                    }, 5000);
                }
            }).fail(function(data){
                toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
                if(data.status == 424){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/sleep';
                    }, 3000);
                }else if(data.status == 503){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                    }, 3000);
                }
            });
        }else{
            toastr.error('Please select a user to delete', 'Fail!!!', {allowHtml: true});
        }
    };
    
    $scope.unblockUsers = function(users){
	    $('.unblockUsersPanel').show();
	    var luCount = 0;
        var myBlockUI = blockUI.instances.get('myBlockUI');
	    document.getElementById("unblockStatement").innerHTML = "";
            $('#unblockDump').hide();
        if(users != null){
            var html;
            $.ajax({
                url: $scope.BASE_FOLDER+'/unblockUsers',
                data: {users: users, csrf_token: $('.csrf_token').html()},
                type: 'POST'
            }).done(function(data){
                blockUI.stop();
		    myBlockUI.stop();
                var jData = JSON.parse(data);
                $scope.userUnblockList = jData.naveen;
		    if(jData.naveen.length > 10){
                    $('.unblockUsersPanel').css('overflowY', 'scroll');
                    $('.unblockUsersPanel').height('500px');
                }
		     jData.naveen.forEach(function(value){
		    if(value.localUser != true || value.status == 'DELETED' || value.status == 'ACTIVE' || value.status == 'INVALID' || value.status == 'CurrentUser' || value.status == 'User does not exist or invalid'){
                     luCount = luCount+1;
                 }
                });
                    if(luCount > 0){
                        document.getElementById("unblockStatement").innerHTML = "One or more users cannot be ubblocked or deleted. Click on Download list to view details.";
                        $('#unblockDump').show();
                    }
                if(jData.result == 'success'){
                    myBlockUI.stop();
                    $('.unblockdeleteusers').show();
                    $('.unblock').removeAttr('disabled');
                    $('.delete').removeAttr('disabled');
                }else{
                    toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
                }
            }).fail(function(data){
                toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
                if(data.status == 424){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/sleep';
                    }, 3000);
                }else if(data.status == 503){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                    }, 3000);
                }
            });
        }else{
            if(active == true){
                toastr.error('Please select a user to Unblock', 'Fail!!!', {allowHtml: true});
            }else{
                toastr.error('Please select a user to block', 'Fail!!!', {allowHtml: true});
            }
        }
    };

    $scope.bulkCreate = function(devices){
        var devices = devices;
        if(devices != null){
            var html;
            console.log("bulk_create_1 " +devices);
            $.ajax({
                url: $scope.BASE_FOLDER+'/bulkCreate',
                data: {devices: devices, csrf_token: $('.csrf_token').html()},
                type: 'POST'
            }).done(function(data){
                blockUI.stop();
                var jData = JSON.parse(data);
                console.log("inside jData : "+jData)
                if(jData.result == 'success'){
                    toastr.success(jData.msg, 'Successful!!!', {allowHtml: true});
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/users';
                    }, 3000);
                    }
                else if(jData.result == 'Not_created'){
                    toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
                    $scope.not_created = jData.users;
                    $('.uncreatedUsers').show();
                    $('#uncreatedDump').show();
                    document.getElementById("uncreatedDumpStatement").innerHTML = "One or more users cannot be created. Click on Download list to view details.";
                    }
                else if(jData.result == 'User_Limit_Exceeded'){
                    $('.uncreatedUsers').hide();
                    toastr.error(jData.msg+'<b>The number of permissible users is '+jData.noOfPossibleUsers+ '</b>', 'Fail!!!', {allowHtml: true});
                    }
                else{
                    $('.uncreatedUsers').hide();
                    toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
                }
            }).fail(function(data){
                toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
                if(data.status == 424){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/sleep';
                    }, 3000);
                }else if(data.status == 503){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                    }, 3000);
                }
            });
        }else{
            if(active == true){
                toastr.error('Please select a user to Unblock', 'Fail!!!', {allowHtml: true});
            }else{
                toastr.error('Please select a user to block', 'Fail!!!', {allowHtml: true});
            }
        }
    };

    $scope.redirectTo = function(url){
        window.location.href = url;
    };

    angular.element(document).ready(function(){
        $('.loading').html('Loading ...');

        //if($scope.currentPage == 'createUserGroup'){
        //    $scope.getAllUnBlockedUsersForSelection('all');
        //}
        if($scope.currentPage == 'myaccount'){
            setTimeout(function(){
                var x = $('div[id^=userDevice]').length;
                if(x == 0){
                    document.getElementById("final").innerHTML = "No Devices have been configured";
                }
            }, 5000);
        }

        if(!$scope.selectedUser && $scope.currentPage == 'users'){
            blockUI.start();
            $scope.updateUsers('all', 1);
        }
        if($scope.selectedUser) {
            blockUI.start();
            $scope.updateUserDevices($scope.selectedUser);
        }
        if($scope.currentPage == 'policyInfo'){
            blockUI.start();
            $scope.updateUserDevicePolicyInfo();
        }

        var error = $('.resultError').html();
        if(error){
            if(error.length > 0){
                toastr.error(error, 'Fail');
            }
        }

        var success = $('.resultSuccess').html();
        if(success){
            if(success.length > 0){
                toastr.success(success, 'Successful');
            }
        }

    });

    $scope.readUserNamesFromExcel = function(files) {

        angular.forEach(files, function(file, key) {

            if (file && !file.$error) {

                file.upload = Upload.upload({
                    url: $scope.BASE_FOLDER+'/readExcelFromUpload',
                    fields: {csrf_token: $('.csrf_token').html(), path: $scope.crumbString},
                    file: file
                });

                file.upload.then(function (response) {
                    $timeout(function () {
                        file.result = response.data;
                        console.log('data_users : '+JSON.stringify(response.data.userNames));
                        if(response.data.result == 'success'){
                            if(response.data.userNames.length > 0){
                                response.data.userNames.forEach(function(value, key){
                                    if(value.length > 1 ){
                                        $('#blockUserNames').tagsinput('add', value);
                                        //blockUI.start();
                                    }
                                });                               
                                $scope.blockUsers(JSON.stringify(response.data.userNames));
                                toastr.success('Usernames has been imported from the excel, please continue with the desired operation', 'Successfully!!!', {allowHtml: true});
                            }else{
                                toastr.error('There was no usernames column in the selected excel file', 'Fail!!!', {allowHtml: true});
                            }
                        }else{
                            toastr.error(file.name, response.data.msg, 'Fail!!!', {allowHtml: true});
                        }
                    });
                }, function (response) {
                    if (response.status > 0)
                        $scope.errorMsg = response.status + ': ' + response.data;
                });

                file.upload.progress(function (evt) {
                    file.progress = Math.min(100, parseInt(100.0 *
                        evt.loaded / evt.total));
                });

            }
        });
    };
    
    $scope.readUserNamesFromExcel1 = function(files) {

        angular.forEach(files, function(file, key) {

            if (file && !file.$error) {

                file.upload = Upload.upload({
                    url: $scope.BASE_FOLDER+'/readExcelFromUpload',
                    fields: {csrf_token: $('.csrf_token').html(), path: $scope.crumbString},
                    file: file
                });

                file.upload.then(function (response) {
                    $timeout(function () {
                        file.result = response.data;
                        console.log('data : '+JSON.stringify(response.data));
                        if(response.data.result == 'success'){
                            if(response.data.userNames.length > 0){
                                response.data.userNames.forEach(function(value, key){
                                    if(value.length > 1 ){
                                        //$('#deleteUserNames').tagsinput('add', value);
                                        //blockUI.start();
                                    }
                                });
                                $scope.unblockUsers(JSON.stringify(response.data.userNames));
                                toastr.success('Usernames has been imported from the excel, please continue with the desired operation', 'Successfully!!!', {allowHtml: true});
                            }else{
                                toastr.error('There was no usernames column in the selected excel file', 'Fail!!!', {allowHtml: true});
                            }
                        }else{
                            toastr.error(file.name, response.data.msg, 'Fail!!!', {allowHtml: true});
                        }
                    });
                }, function (response) {
                    if (response.status > 0)
                        $scope.errorMsg = response.status + ': ' + response.data;
                });

                file.upload.progress(function (evt) {
                    file.progress = Math.min(100, parseInt(100.0 *
                        evt.loaded / evt.total));
                });

            }
        });
    };
    
    $scope.downloadSample = function(type){
        switch (type) {
            case 'bulkcreateusers':
                window.location.href = $scope.BASE_FOLDER+'/user/downloadBulkcreateusersSample';
                break;
            case 'bulkblockusers':
                window.location.href = $scope.BASE_FOLDER+'/user/downloadBlockUnblockDeleteusersSample';
                break;
            case 'bulkdeleteunblockusers':
                window.location.href = $scope.BASE_FOLDER+'/user/downloadBlockUnblockDeleteusersSample';
                break;
            case 'downloadDump':
                window.location.href = $scope.BASE_FOLDER+'/user/downloadDump';
                break;
        }

    };

    $scope.readUserNamesFromExcelCreateUsers = function(files) {

        angular.forEach(files, function(file, key) {

            if (file && !file.$error) {

                file.upload = Upload.upload({
                    url: $scope.BASE_FOLDER+'/readExcelFromUploadCreateUsers',
                    fields: {csrf_token: $('.csrf_token').html(), path: $scope.crumbString},
                    file: file
                });

                file.upload.then(function (response) {
                    $timeout(function () {
                        file.result = response.data;
                        console.log('data : '+JSON.stringify(response.data));
                        if(response.data.result == 'success'){
                            if(response.data.userNames.length > 0){
                                response.data.userNames.forEach(function(value, key){
                                    if(value.length > 1 ){
                                        //$('#deleteUserNames').tagsinput('add', value);
                                        //blockUI.start();
                                    }
                                });
                                $scope.bulkCreate(JSON.stringify(response.data.userList));
                                //toastr.success('Usernames have been imported from the excel. Please continue with the desired operation.', 'Successfully!!!', {allowHtml: true});
                            }else{
                                toastr.error('There was no usernames column in the selected excel file', 'Fail!!!', {allowHtml: true});
                            }
                        }
                        else if(response.data.result == 'empty_excel'){
                            toastr.error(file.name, response.data.msg, 'Fail!!!', {allowHtml: true});
                        }
                        else if(response.data.result == 'information_missing'){
                            toastr.error(file.name, response.data.msg, 'Fail!!!', {allowHtml: true});
                        }
                        else if(response.data.result == 'fail'){
                            toastr.error(file.name, response.data.msg, 'Fail!!!', {allowHtml: true});
                        }
                        else{
                            toastr.error(file.name, response.data.msg, 'Fail!!!', {allowHtml: true});
                        }
                    });
                }, function (response) {
                    if (response.status > 0)
                        $scope.errorMsg = response.status + ': ' + response.data;
                });

                file.upload.progress(function (evt) {
                    file.progress = Math.min(100, parseInt(100.0 *
                        evt.loaded / evt.total));
                });

            }
        });
    };
    
    /*muxing start*/

    $scope.muxUsers = function(){
        $('#multiplexed').modal('show');
        $scope.muxedUsersList();
    };

    $scope.muxedUsers = [];

    $scope.muxedUsersList = function(){
        $.ajax({
            url: $scope.BASE_FOLDER+'/muxedUsersList',
            data: {csrf_token: $('.csrf_token').html()},
            type: 'POST'
        }).done(function(data){
            var jData = JSON.parse(data);
            console.log("data : "+data);
            console.log("jData : "+jData.users);
            if(jData.result == 'success'){
                if(jData.users.length >= 1){
                    $('.usersFound').show();
                    $('.noUsers').hide();
                }else{
                    $('.usersFound').hide();
                    $('.noUsers').show();
                }
                $scope.muxedUsers = jData.users;
                if(jData.users.length > 10){
                    $('.usersTable').scroll();
                    $('.usersTable').height('400px');
                }
                $scope.$apply();
            }
        }).fail(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    $scope.startMuxing = function(){
        var usersSelected;
        var arr = $('input.select-itemmux:checkbox:checked').map(function () {
            return this.value;
           }).get();
        usersSelected = arr;
        $.ajax({
            type: 'POST',
            url: $scope.BASE_FOLDER+'/startMuxing',
            data: {users : usersSelected, bucketName : $('.bucketName').val(), csrf_token: $('.csrf_token').html()}
        }).done(function(data){
            var jData = $.parseJSON(data);
            if(jData.result == 'success'){
                $scope.$apply();
                    $('#multiplexed').modal('hide');
                    toastr.success(jData.msg, 'Successful!!!', {allowHtml: true});
                    setTimeout(function(){
                        window.location.reload(true);
                    }, 3000)
            }else{
                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
            }
        }).fail(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    $scope.itemSelect = function(){
        var all = $("input.select-allmux")[0];
        var total = $("input.select-itemmux").length;
        var len = $("input.select-itemmux:checked:checked").length;
        all.checked = len===total;
        var usersSelected;
        var arr = $('input.select-itemmux:checkbox:checked').map(function () {
            return this.value;
            }).get();
        usersSelected = arr;
        $('.selectedUsers').tagsinput('removeAll');
        $('.selectedUsers').tagsinput('add', usersSelected.join());
    };
        /*muxing end*/
	
    $scope.getUsersSoftDelete = function(){
            $('#softblockStatement').hide();
            $.ajax({
                url: $scope.BASE_FOLDER+'/user/getSoftDeleteUsers',
                data: {csrf_token: $('[name="csrf_token"]').val()},
                type: 'POST'
            }).done(function(data){
                var jData = JSON.parse(data);
                if(jData.result == 'success'){
                    if(jData.users.length > 0){
                        $('.softBlockUsers').show();
                        $('.softblockUsersPanel').show();
                        $('.softBlock').removeAttr('disabled');
                        $scope.softBlockList = jData.users;
                            if(jData.users.length > 10 ){
                                $('.softblockUsersPanel').css('overflowY', 'scroll');
                                $('.softblockUsersPanel').height('500px');
                            }else{
                                $('.softblockUsersPanel').css('overflowY', 'unset');
                                $('.softblockUsersPanel').height('inherit');
                            }
                    }else{
                        $('.softBlockUsers').hide();
                        $('.softblockUsersPanel').hide();
                        $('.softBlock').attr('disabled', 'disabled');
                        $scope.softBlockList = [];
                        toastr.error('No users were found.', 'Fail!!!', {allowHtml: true});
                    }
                    $scope.$apply();
                }else{
                    toastr.error(jData.message, 'Fail!!!', {allowHtml: true});
                }
            }).fail(function(data){
                toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
                if(data.status == 424){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/sleep';
                    }, 3000);
                }else if(data.status == 503){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                    }, 3000);
                }
            });
        };

        $scope.softBlockUsers = function(active){
            var users;
            var arr = $('input.select-itemsoft:checkbox:checked').map(function () {
                return this.value;
            }).get();
            users = arr;
            console.log("got users : "+users);
            if(users.length <= 0){
                toastr.error('Please select at least one user to block.', 'Fail!!!', {allowHtml: true});
                return;
            }
            $.ajax({
                url: $scope.BASE_FOLDER+'/users/blockMultipleUsers',
                data: {users: users, active: active, csrf_token: $('.csrf_token').html()},
                type: 'POST'
            }).done(function(data){
                var jData = JSON.parse(data);
                if(jData.result == 'success'){                    
                    toastr.success(jData.msg, 'Successful!!!', {allowHtml: true});
                    if($scope.softBlockList.length == users.length){
                        setTimeout(function(){
                            window.location.reload(true);
                        }, 5000);
                    }else{
                        $('#softblockStatement').show();
                        document.getElementById("softblockStatement").innerHTML = "One or more users are still in an unapproved state.  For consistency, please approve the blocking operation.  Or, if you wish for these users to remain active, please add them back into the AD or AAD Group.";
                        $('.softBlockUsers').hide();
                        $('.softblockUsersPanel').hide();
                        $('.softBlock').attr('disabled', 'disabled');
                        $scope.softBlockList = [];
                    }       
                }
            }).fail(function(data){
                toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
                if(data.status == 424){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/sleep';
                    }, 3000);
                }else if(data.status == 503){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                    }, 3000);
                }
            });
        };	

}]);

