/**
 * Created by parablu-dev on 8/5/15.
 */

app.controller('HistoryController', ['$scope', 'toastr', '$http', '$ngBootbox', 'blockUI', 'BASE_FOLDER', function($scope, toastr, $http, $ngBootbox, blockUI,BASE_FOLDER) {

    $scope.BASE_FOLDER = BASE_FOLDER;
    $scope.currentPage = $('.currentPage').html();
    $scope.sortReverse = true;
    $scope.sortType = 'endTimeLong';
    $scope.summary = {};
    $scope.history = '';
    $scope.historyDetails = '';
    $scope.pageNumber = 1;
    $scope.limitNumber = 50;
    $scope.audits = [];
    $scope.historyDetailsType = '';
    $scope.skipValue = 0;
    $scope.currentpageCount = '';
    $scope.totalpageCount = '';
    
    $scope.updateDeviceBackupHistory = function(){
        $('.first').hide();
        $('.self').hide();
        $('.previous').hide();
        $('.next').hide();
        $('.last').hide();
        $.ajax({
            url: $scope.BASE_FOLDER+'/user/backupHistory',
            data: {secret: '',csrf_token: $('.token').html()},
            type: 'POST'
        }).done(function(data){
            blockUI.stop();
            $('.loading').hide();
            $('.deviceHistoryTable').show();
            var jData = JSON.parse(data);
            $scope.previous = jData.metadata.links.previous;
            $scope.next = jData.metadata.links.next;
            $scope.last = jData.metadata.links.last;
            $scope.self = jData.metadata.links.self;
            $scope.first = jData.metadata.links.first;
            $scope.currentpageCount = jData.metadata.pageNumber;
            $scope.totalpageCount = Math.ceil(jData.metadata.totalCount/jData.metadata.recordsPerPage);
            if($scope.first){
            $('.first').show();
            }
            if($scope.self){
            $('.self').show();
            }
            if($scope.previous){
            $('.previous').show();
            }
            if($scope.next){
            $('.next').show();
            }
            if($scope.last){
            $('.last').show();
            }
            $scope.summary.completedPercentage      = jData.summary.completedPercentage;
            $scope.summary.totalNoOfFiles           = jData.summary.totalNoOfFiles;
            $scope.summary.noOfFilesToBeUploaded    = jData.summary.noOfFilesToBeUploaded;
            if(jData.history.length > 0){
                $scope.history = jData.history;
            }else{
                $('.deviceHistoryTable').hide();
                $('.loading').show();
                $('.loading').html('There is no history of backup...!');
            }
            $scope.$apply();
        }).fail(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    $scope.updateDeviceBackupHistoryNavigate = function(url){
        $('.first').hide();
        $('.self').hide();
        $('.previous').hide();
        $('.next').hide();
        $('.last').hide();
        $.ajax({
            url: $scope.BASE_FOLDER+'/user/backupHistory1',
            data: {secret: '',csrf_token: $('.token').html(),url:url},
            type: 'POST'
        }).done(function(data){
            blockUI.stop();
            $('.loading').hide();
            $('.deviceHistoryTable').show();
            var jData = JSON.parse(data);
            $scope.previous = jData.metadata.links.previous;
            $scope.next = jData.metadata.links.next;
            $scope.last = jData.metadata.links.last;
            $scope.self = jData.metadata.links.self;
            $scope.first = jData.metadata.links.first;
            $scope.currentpageCount = jData.metadata.pageNumber;
            $scope.totalpageCount = Math.ceil(jData.metadata.totalCount/jData.metadata.recordsPerPage);
            if($scope.first){
            $('.first').show();
            }
            if($scope.self){
            $('.self').show();
            }
            if($scope.previous){
            $('.previous').show();
            }
            if($scope.next){
            $('.next').show();
            }
            if($scope.last){
            $('.last').show();
            }
            $scope.summary.completedPercentage      = jData.summary.completedPercentage;
            $scope.summary.totalNoOfFiles           = jData.summary.totalNoOfFiles;
            $scope.summary.noOfFilesToBeUploaded    = jData.summary.noOfFilesToBeUploaded;
            if(jData.history.length > 0){
                $scope.history = jData.history;
            }else{
                $('.deviceHistoryTable').hide();
                $('.loading').show();
                $('.loading').html('There is no history of backup...!');
            }
            $scope.$apply();
        }).fail(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    $scope.showHistoryDetails = function(batchId, type, count){
        if(count != '0' && count != '0 (0 %)' ){
            blockUI.start();
            $scope.historyDetailsType = type;
            $.ajax({
                url: $scope.BASE_FOLDER+'/user/backupHistoryDetails',
                data: {batchId: batchId, csrf_token: $('.token').html()},
                type: 'POST'
            }).done(function(data){
                blockUI.stop();
                var jData = JSON.parse(data);
                $('.loading').hide();
                $('.deviceHistoryDetailsTable').show();
                if(jData.historyDetails != null){
                    $scope.historyDetails = jData.historyDetails;
                }else{
                    $('.deviceHistoryDetailsTable').hide();
                    $('.loading').show();
                    $('.loading').html('There is no details for the selected backup history...');
                }
                $scope.$apply();
                $('.backupHistoryDetailsModal').modal('show');
            }).fail(function(data){
                toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
                if(data.status == 424){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/sleep';
                    }, 3000);
                }else if(data.status == 503){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                    }, 3000);
                }
            });
        }else{
            toastr.info('There are no files to show details about', 'Information!!!', {allowHtml: true});
        }
    };

    //$scope.updateBackupActivityDetails = function(rows, pbAuditUserName, pbAuditDeviceName, pageNumber){
    $scope.updateBackupActivityDetails = function(pbAuditUserName, pbAuditDeviceName, pageNumber){
        var pageNumber = $scope.pageNumber;
console.log("calling page num : "+pageNumber);
$('.first').hide();
$('.self').hide();
$('.previous').hide();
$('.next').hide();
$('.last').hide();
        $.ajax({
            url: $scope.BASE_FOLDER+'/activityHistory',
            data: {
//                rows: rows,
                pbAuditUserName: pbAuditUserName,
                pbAuditDeviceName: pbAuditDeviceName,
                pageNumber: pageNumber,
                csrf_token: $('.csrf_token').html()
            },
            type: 'POST'
        }).done(function(data){
            blockUI.stop();
            $('.loading').hide();
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
                console.log("data : "+data);
$scope.previous = jData.metadata.links.previous;
$scope.next = jData.metadata.links.next;
$scope.last = jData.metadata.links.last;
$scope.self = jData.metadata.links.self;
$scope.first = jData.metadata.links.first;
$scope.currentpageCount = jData.metadata.pageNumber;
$scope.totalpageCount = Math.ceil(jData.metadata.totalCount/jData.metadata.recordsPerPage);
console.log("currentpage"+$scope.currentpageCount);
console.log("totalpage"+$scope.totalpageCount);
if($scope.first){
$('.first').show();
}
if($scope.self){
$('.self').show();
}
if($scope.previous){
$('.previous').show();
}
if($scope.next){
$('.next').show();
}
if($scope.last){
$('.last').show();
}
console.log("prev : "+jData.metadata.links.previous);
console.log("next : "+jData.metadata.links.next);
console.log("last : "+jData.metadata.links.last);
console.log("self : "+jData.metadata.links.self);
                if(jData.audits.length > 0){
                    //$scope.audits = $scope.audits.concat(jData.audits);
                    $scope.audits = jData.audits;
                    $scope.pageNumber = pageNumber+1;
                    $('.loadMore').show();
                }else{
                    $('.loadMore').hide();
                }
                $scope.$apply();
            }else{
                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
            }
        }).fail(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };
    
    $scope.navigate = function(url){
//var pageNumber = $scope.pageNumber;
//console.log("calling page num : "+pageNumber);
$('.first').hide();
$('.self').hide();
$('.previous').hide();
$('.next').hide();
$('.last').hide();
        $.ajax({
            url: $scope.BASE_FOLDER+'/activityHistory1',
            data: {
                url: url,
                csrf_token: $('.csrf_token').html()
            },
            type: 'POST'
        }).done(function(data){
            blockUI.stop();
            $('.loading').hide();
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
console.log("data : "+data);
$scope.previous = jData.metadata.links.previous;
$scope.next = jData.metadata.links.next;
$scope.last = jData.metadata.links.last;
$scope.self = jData.metadata.links.self;
$scope.first = jData.metadata.links.first;
$scope.currentpageCount = jData.metadata.pageNumber;
$scope.totalpageCount = Math.ceil(jData.metadata.totalCount/jData.metadata.recordsPerPage);
console.log("currentpage"+$scope.currentpageCount);
console.log("totalpage"+$scope.totalpageCount);
//if($scope.next != 'undefined'){
if($scope.first){
$('.first').show();
}
if($scope.self){
$('.self').show();
}
if($scope.previous){
$('.previous').show();
}
if($scope.next){
$('.next').show();
}
if($scope.last){
$('.last').show();
}
console.log("next : "+jData.metadata.links.next);
console.log("prev : "+jData.metadata.links.previous);
console.log("last : "+jData.metadata.links.last);
console.log("self : "+jData.metadata.links.self);
console.log("first : "+jData.metadata.links.first);
                if(jData.audits.length > 0){
//                    $scope.audits = $scope.audits.concat(jData.audits);
$scope.audits = jData.audits;
//                    $scope.pageNumber = pageNumber+1;
                    $('.loadMore').show();
                }else{
                    $('.loadMore').hide();
                }
//console.log("page num : "+pageNumber);
$scope.$apply();
            }else{
                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
            }
        }).fail(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    $scope.updateShareActivityHistory = function(skipValue){
        var html = $('.loadMoreBtn').html();
        $('.loadMoreBtn').attr('disabled','disabled');
        $('.loadMoreBtn').html('Loading... <i class="fa fa-circle-o-notch fa-spin"></i>').animate();
        var pageNumber = $scope.pageNumber;
        $('.first').hide();
        //$('.self').hide();
        $('.previous').hide();
        $('.next').hide();
        $('.last').hide();
        $.ajax({
            url: $scope.BASE_FOLDER+'/share/activityHistory',
            data: {csrf_token: $('.csrf_token').html(), skipValue: skipValue, pageNumber: pageNumber},
            type: 'POST'
        }).done(function(data){
            $('.loadMoreBtn').removeAttr('disabled');
            $('.loadMoreBtn').html(html);
            blockUI.stop();
            $('.loading').hide();
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
                if(jData.metadata != '' && jData.audits.length > 0){
                    $('.Navigate').show();
                    $('.status').hide();
                    $scope.previous = jData.metadata.links.previous;
                    $scope.next = jData.metadata.links.next;
                    $scope.last = jData.metadata.links.last;
                    //$scope.self = jData.metadata.links.self;
                    $scope.first = jData.metadata.links.first;
                    $scope.currentpageCount = jData.metadata.pageNumber;
                    $scope.totalpageCount = Math.ceil(jData.metadata.totalCount/jData.metadata.recordsPerPage);
                    if($scope.first){
                    $('.first').show();
                    }
                    if($scope.previous){
                    $('.previous').show();
                    }
                    if($scope.next){
                    $('.next').show();
                    }
                    if($scope.last){
                    $('.last').show();
                    }
                    $scope.audits = jData.audits;
                 }else{
                    $('.Navigate').hide();
                    $('.status').show();
                 }                
                $scope.$apply();
            }else{
                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
            }
        }).fail(function(data){
	    toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    $scope.updateShareActivityHistoryNavigate = function(url){
            var html = $('.loadMoreBtn').html();
            $('.loadMoreBtn').attr('disabled','disabled');
            $('.loadMoreBtn').html('Loading... <i class="fa fa-circle-o-notch fa-spin"></i>').animate();
            $('.first').hide();
            //$('.self').hide();
            $('.previous').hide();
            $('.next').hide();
            $('.last').hide();
            $.ajax({
                url: $scope.BASE_FOLDER+'/share/activityHistory1',
                data: {csrf_token: $('.csrf_token').html(), url: url},
                type: 'POST'
            }).done(function(data){
                $('.loadMoreBtn').removeAttr('disabled');
                $('.loadMoreBtn').html(html);
                blockUI.stop();
                $('.loading').hide();
                var jData = JSON.parse(data);
                if(jData.result == 'success'){
                    if(jData.metadata != '' && jData.audits.length > 0){
                        $('.Navigate').show();
                        $('.status').hide();
                        $scope.previous = jData.metadata.links.previous;
                        $scope.next = jData.metadata.links.next;
                        $scope.last = jData.metadata.links.last;
                        //$scope.self = jData.metadata.links.self;
                        $scope.first = jData.metadata.links.first;
                        $scope.currentpageCount = jData.metadata.pageNumber;
                        $scope.totalpageCount = Math.ceil(jData.metadata.totalCount/jData.metadata.recordsPerPage);
                        if($scope.first){
                        $('.first').show();
                        }
                        /*if($scope.self){
                        $('.self').show();
                        }*/
                        if($scope.previous){
                        $('.previous').show();
                        }
                        if($scope.next){
                        $('.next').show();
                        }
                        if($scope.last){
                        $('.last').show();
                        }
                        $scope.audits = jData.audits;
                     }else{
                        $('.Navigate').hide();
                        $('.status').show();
                     }
                    $scope.$apply();
                }else{
                    toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
            }
            }).fail(function(data){
                toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
                if(data.status == 424){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/sleep';
                    }, 3000);
                }else if(data.status == 503){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                    }, 3000);
                }
            });
    };
    
    $scope.downloadLogFile = function(log1,log2){
        var log = log1+"/"+log2;
            $.ajax({
                url: $scope.BASE_FOLDER+'/checkFile',
                data: {id: log1, name : log2,csrf_token: $('.token').html()},
                type: 'POST'
            }).done(function(data){
                var jData = JSON.parse(data);
                if(jData.result == 'success'){
                    window.location.href = $scope.BASE_FOLDER+'/downloadLogOne'+'/'+log1+'/'+log2;
                    toastr.success(jData.msg, 'Successful!!!', {allowHtml: true});
                }else{
                    toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
                }
            }).fail(function(data){
                toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
                if(data.status == 424){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/sleep';
                    }, 3000);
                }else if(data.status == 503){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                    }, 3000);
                }
            });
     };
    
    $scope.showDetailedAnalysis = function(batchId){
        $.ajax({
            url: $scope.BASE_FOLDER+'/report/backupAttemps',
            data: {secret: '',csrf_token: $('.token').html(),batchId:batchId},
            type: 'POST'
        }).done(function(data){
            $('.detailedAnalysis').modal('show');
            var jData = JSON.parse(data);
            $scope.batchElements = jData.batchElements;
            $scope.$apply();
        }).fail(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    angular.element(document).ready(function(){
        $('.loading').html('Loading ...');
        if($scope.currentPage == 'shareActivityHistory'){
            blockUI.start();
            $scope.updateShareActivityHistory();
        }
        if($scope.currentPage == 'deviceBackupHistory'){
            blockUI.start();
            $scope.updateDeviceBackupHistory();
        }
        if($scope.currentPage == 'backupActivityHistory'){
            blockUI.start();
            //$scope.updateBackupActivityDetails(50, '', '', 0);
            $scope.updateBackupActivityDetails('', '', 1);
        }
        if($scope.currentPage == 'dashboard'){
            blockUI.start();
            $scope.updateBackupActivityDetails(5, '', '', 0);
        }
    });

}]);

app.filter('filterStatusType', function(){
    return function(data, type){
        var filtered = [];
        if(type){
            for (var i = 0; i < data.length; i++){
                var value = data[i];
                if(value.status == type){
                    filtered.push(value);
                }
            }
            return filtered;
        }else{
            return data;
        }
    }
});
