/*
 * Decompiled with CFR 0.152.
 */
package org.dom4j;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.dom4j.DocumentFactory;
import org.dom4j.Namespace;
import org.dom4j.tree.QNameCache;

public class QName
implements Serializable {
    protected static transient QNameCache cache = new QNameCache();
    private String name;
    private String qualifiedName;
    private transient Namespace namespace;
    private int hashCode;
    private DocumentFactory documentFactory;

    public QName(String name) {
        this(name, Namespace.NO_NAMESPACE);
    }

    public QName(String name, Namespace namespace) {
        this.name = name == null ? "" : name;
        this.namespace = namespace == null ? Namespace.NO_NAMESPACE : namespace;
    }

    public QName(String name, Namespace namespace, String qualifiedName) {
        this.name = name == null ? "" : name;
        this.qualifiedName = qualifiedName;
        this.namespace = namespace == null ? Namespace.NO_NAMESPACE : namespace;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof QName) {
            QName that = (QName)object;
            if (this.hashCode() == that.hashCode()) {
                return this.getName().equals(that.getName()) && this.getNamespaceURI().equals(that.getNamespaceURI());
            }
        }
        return false;
    }

    public static synchronized QName get(String name) {
        return cache.get(name);
    }

    public static synchronized QName get(String qualifiedName, String uri) {
        return cache.get(qualifiedName, uri);
    }

    public static synchronized QName get(String name, String prefix, String uri) {
        return cache.get(name, Namespace.get(prefix, uri));
    }

    public static synchronized QName get(String name, Namespace namespace) {
        return cache.get(name, namespace);
    }

    public static synchronized QName get(String localName, Namespace namespace, String qualifiedName) {
        return cache.get(localName, namespace, qualifiedName);
    }

    public DocumentFactory getDocumentFactory() {
        return this.documentFactory;
    }

    public String getName() {
        return this.name;
    }

    public Namespace getNamespace() {
        return this.namespace;
    }

    public String getNamespacePrefix() {
        if (this.namespace == null) {
            return "";
        }
        return this.namespace.getPrefix();
    }

    public String getNamespaceURI() {
        if (this.namespace == null) {
            return "";
        }
        return this.namespace.getURI();
    }

    public String getQualifiedName() {
        if (this.qualifiedName == null) {
            String prefix = this.getNamespacePrefix();
            this.qualifiedName = prefix != null && prefix.length() > 0 ? String.valueOf(prefix) + ":" + this.name : this.name;
        }
        return this.qualifiedName;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = this.getName().hashCode() ^ this.getNamespaceURI().hashCode();
            if (this.hashCode == 0) {
                this.hashCode = 47806;
            }
        }
        return this.hashCode;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        String prefix = (String)in.readObject();
        String uri = (String)in.readObject();
        in.defaultReadObject();
        this.namespace = Namespace.get(prefix, uri);
    }

    public void setDocumentFactory(DocumentFactory documentFactory) {
        this.documentFactory = documentFactory;
    }

    public String toString() {
        return String.valueOf(super.toString()) + " [name: " + this.getName() + " namespace: \"" + this.getNamespace() + "\"]";
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.namespace.getPrefix());
        out.writeObject(this.namespace.getURI());
        out.defaultWriteObject();
    }
}

