/*
 * Decompiled with CFR 0.152.
 */
package Utility.com.parablu;

import Utility.com.parablu.HttpClientUtil;
import Utility.com.parablu.MD5Generator;
import Utility.com.parablu.Office365;
import com.mongodb.BasicDBObject;
import com.mongodb.DBRef;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientURI;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.parablu.pcbd.domain.PciAuthorizationTokenElement;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.util.EntityUtils;
import org.bson.Document;
import org.json.JSONObject;

public class UpdateCloudStorgeSize {
    private static final String PERSONAL_URL = "/personal/";
    private static final String BEARER = "Bearer ";
    public static final String HEADER_KEY_ACCEPT = "Accept";
    public static final String HEADER_VALUE_APPLICATION_JSON = "application/json;odata=verbose";
    public static final String HEADER_KEY_CONTENT_TYPE = "Content-Type";

    public static void main(String[] args) throws ConfigurationException {
        PropertiesConfiguration config = null;
        config = new PropertiesConfiguration(args[0]);
        String mongoIP = config.getProperty("mongoIP").toString();
        String mongoPort = config.getProperty("mongoPort").toString();
        String deviceUUID = config.getProperty("deviceUUID").toString();
        boolean isMultiplexAccount = Boolean.parseBoolean(config.getProperty("isMultiplexAccount").toString());
        if (StringUtils.isEmpty(mongoIP)) {
            System.out.println("mongoIP or port cannot be empty in config file...Please configure and run again :)");
            throw new ArrayIndexOutOfBoundsException();
        }
        System.out.println("mongo IP:" + mongoIP);
        MongoClientURI uri = new MongoClientURI("mongodb://neil:parablu@" + mongoIP + ":" + mongoPort + "/parablu001");
        MongoClient client = new MongoClient(uri);
        MongoDatabase db = client.getDatabase(uri.getDatabase());
        MongoClientURI uriPar = new MongoClientURI("mongodb://neil:parablu@" + mongoIP + ":" + mongoPort + "/parablu");
        MongoClient clientPar = new MongoClient(uriPar);
        MongoDatabase dbPar = clientPar.getDatabase(uriPar.getDatabase());
        MongoCollection<Document> cloudCollection = dbPar.getCollection("CLOUD");
        MongoCollection<Document> cloudCustomiCollection = dbPar.getCollection("CLOUD_CUSTOMIZABLE_DETAILS");
        Document cloud = (Document)cloudCollection.find().first();
        List customaizable = (List)cloud.get("cloudCustomisableDetails");
        boolean isOdbEnabled = false;
        for (DBRef cust : customaizable) {
            Document cu = (Document)cloudCustomiCollection.find(new BasicDBObject("_id", cust.getId())).first();
            if (cu == null || !StringUtils.isNotEmpty(cu.getString("name")) || !cu.getString("name").equals("ODB Enabled")) continue;
            isOdbEnabled = true;
            break;
        }
        if (!isOdbEnabled) {
            System.out.println("ODB Enabled is false.... so return");
            return;
        }
        MongoCollection<Document> tokenCollection = db.getCollection("PCI_AUTHORIZATION_TOKENS");
        Document tokenDoc = (Document)tokenCollection.find().first();
        PciAuthorizationTokenElement pciAuthorizationTokenElement = new PciAuthorizationTokenElement();
        pciAuthorizationTokenElement.setAccessToken(tokenDoc.getString("accessToken"));
        pciAuthorizationTokenElement.setAuthenticationToken(tokenDoc.getString("authenticationToken"));
        pciAuthorizationTokenElement.setClientId(tokenDoc.getString("clientId"));
        pciAuthorizationTokenElement.setSharePointUrl(tokenDoc.getString("sharePointUrl"));
        pciAuthorizationTokenElement.setClientSecret(tokenDoc.getString("clientSecret"));
        pciAuthorizationTokenElement.setCloudName(tokenDoc.getString("cloudName"));
        pciAuthorizationTokenElement.setRefreshToken(tokenDoc.getString("refreshToken"));
        pciAuthorizationTokenElement.setSharePointUrl(tokenDoc.getString("sharePointUrl"));
        MongoCollection<Document> userDBCollection = db.getCollection("USER");
        MongoCollection<Document> deviceDBCollection = db.getCollection("DEVICE");
        MongoCollection<Document> deviceBkpDBCollection = db.getCollection("DEVICE_BACKUP_OVERVIEW");
        if (StringUtils.isNotEmpty(deviceUUID)) {
            Document device = (Document)deviceDBCollection.find(new Document("deviceUUID", deviceUUID)).first();
            if (device != null) {
                String userODBID = "";
                Document user = null;
                if (StringUtils.isEmpty(device.getString("userName"))) {
                    DBRef userDBRef = (DBRef)device.get("user");
                    user = (Document)((Object)userDBCollection.find(new Document("_id", userDBRef.getId())));
                } else {
                    user = (Document)userDBCollection.find(new Document("userName", device.getString("userName"))).first();
                }
                userODBID = !StringUtils.isEmpty(user.getString("odbLoginId")) ? user.getString("odbLoginId") : user.getString("emailId");
                pciAuthorizationTokenElement.setAccountId(userODBID);
                pciAuthorizationTokenElement.setEmailId(userODBID);
                long storageSize = 0L;
                if (isMultiplexAccount) {
                    String uniqueId = UpdateCloudStorgeSize.getUniqueODUserFolder(device.getString("deviceUUID"));
                    storageSize = UpdateCloudStorgeSize.getSizeOfFolder(pciAuthorizationTokenElement, uniqueId);
                    System.out.println(storageSize);
                } else {
                    storageSize = UpdateCloudStorgeSize.getSizeOfFolder(pciAuthorizationTokenElement, "");
                }
                if (storageSize != 0L) {
                    BasicDBObject bkpSearchQuery = new BasicDBObject();
                    if (device.get("deviceBackupOverView") != null) {
                        DBRef bkpOverDBRef = (DBRef)device.get("deviceBackupOverView");
                        bkpSearchQuery.append("id", bkpOverDBRef.getId());
                    } else {
                        bkpSearchQuery.append("deviceUUID", device.getString("deviceUUID"));
                    }
                    long sizeInKB = storageSize / 1024L;
                    BasicDBObject sizeUpdateFields = new BasicDBObject();
                    sizeUpdateFields.append("storageUtilizedInCloud", sizeInKB);
                    BasicDBObject updateDeviceQuery = new BasicDBObject();
                    updateDeviceQuery.append("$set", sizeUpdateFields);
                    deviceBkpDBCollection.updateOne(bkpSearchQuery, updateDeviceQuery);
                }
            } else {
                System.out.println("No device found with deviceUUID so return");
                System.exit(0);
            }
            System.exit(0);
        }
        FindIterable<Document> userList = userDBCollection.find(new Document("deleted", false));
        for (Document user : userList) {
            try {
                long storageSize;
                BasicDBObject andQuery = new BasicDBObject();
                ArrayList<BasicDBObject> whereQuery = new ArrayList<BasicDBObject>();
                DBRef userDBRef = new DBRef("USER", user.getObjectId("_id"));
                whereQuery.add(new BasicDBObject("user", userDBRef));
                whereQuery.add(new BasicDBObject("userName", user.getString("userName")));
                andQuery.put("$or", whereQuery);
                long deviceCount = deviceDBCollection.count(andQuery);
                String userODBID = "";
                userODBID = !StringUtils.isEmpty(user.getString("odbLoginId")) ? user.getString("odbLoginId") : user.getString("emailId");
                if (!StringUtils.isNotEmpty(userODBID)) continue;
                if (isMultiplexAccount) {
                    pciAuthorizationTokenElement.setAccountId(userODBID);
                    pciAuthorizationTokenElement.setEmailId(userODBID);
                    FindIterable<Document> deviceList = deviceDBCollection.find(new Document("userName", user.getString("userName")));
                    for (Document device : deviceList) {
                        String uniqueId = UpdateCloudStorgeSize.getUniqueODUserFolder(device.getString("deviceUUID"));
                        storageSize = UpdateCloudStorgeSize.getSizeOfFolder(pciAuthorizationTokenElement, uniqueId);
                        if (storageSize == 0L) continue;
                        BasicDBObject bkpSearchQuery = new BasicDBObject();
                        bkpSearchQuery.append("deviceUUID", device.getString("deviceUUID"));
                        long sizeInKB = storageSize / 1024L;
                        BasicDBObject sizeUpdateFields = new BasicDBObject();
                        sizeUpdateFields.append("storageUtilizedInCloud", sizeInKB);
                        BasicDBObject updateDeviceQuery = new BasicDBObject();
                        updateDeviceQuery.append("$set", sizeUpdateFields);
                        deviceBkpDBCollection.updateOne(bkpSearchQuery, updateDeviceQuery);
                        System.out.println("For the user " + user.getString("userName") + " storage size " + storageSize + " is updated.");
                    }
                    continue;
                }
                andQuery = new BasicDBObject();
                whereQuery = new ArrayList();
                whereQuery.add(new BasicDBObject("emailId", userODBID));
                whereQuery.add(new BasicDBObject("odbLoginId", userODBID));
                andQuery.put("$or", whereQuery);
                long count = userDBCollection.count(andQuery);
                if (count > 1L) {
                    System.out.println(String.valueOf(userODBID) + " Is mapped to " + count + " users so skip");
                    continue;
                }
                pciAuthorizationTokenElement.setAccountId(userODBID);
                pciAuthorizationTokenElement.setEmailId(userODBID);
                long count1 = deviceDBCollection.count(new Document("userName", user.getString("userName")));
                if (count1 > 1L) {
                    System.out.println(String.valueOf(user.getString("userName")) + " user have more than one device so skip..");
                    continue;
                }
                storageSize = UpdateCloudStorgeSize.getSizeOfFolder(pciAuthorizationTokenElement, "");
                if (storageSize == 0L) {
                    System.out.println(" No size to update so skip ....");
                    continue;
                }
                if (storageSize > 0L) {
                    long sizeInKB = storageSize / 1024L;
                    andQuery = new BasicDBObject();
                    whereQuery = new ArrayList();
                    whereQuery.add(new BasicDBObject("user", userDBRef));
                    whereQuery.add(new BasicDBObject("userName", user.getString("userName")));
                    andQuery.put("$or", whereQuery);
                    Document device = (Document)deviceDBCollection.find(andQuery).first();
                    if (!StringUtils.isEmpty(device.getString("userName"))) {
                        BasicDBObject bkpSearchQuery = new BasicDBObject();
                        bkpSearchQuery.append("userName", device.getString("userName"));
                        BasicDBObject sizeUpdateFields = new BasicDBObject();
                        sizeUpdateFields.append("storageUtilizedInCloud", sizeInKB);
                        BasicDBObject updateDeviceQuery = new BasicDBObject();
                        updateDeviceQuery.append("$set", sizeUpdateFields);
                        deviceBkpDBCollection.updateOne(bkpSearchQuery, updateDeviceQuery);
                    } else if (device.get("deviceBackupOverView") != null) {
                        DBRef bkpOverDBRef = (DBRef)device.get("deviceBackupOverView");
                        BasicDBObject bkpSearchQuery = new BasicDBObject();
                        bkpSearchQuery.append("id", bkpOverDBRef.getId());
                        BasicDBObject sizeUpdateFields = new BasicDBObject();
                        sizeUpdateFields.append("storageUtilizedInCloud", sizeInKB);
                        BasicDBObject updateDeviceQuery = new BasicDBObject();
                        updateDeviceQuery.append("$set", sizeUpdateFields);
                        deviceBkpDBCollection.updateOne(bkpSearchQuery, updateDeviceQuery);
                    }
                }
                System.out.println("For the user " + user.getString("userName") + " storage size " + storageSize + " is updated.");
            }
            catch (Exception e) {
                System.out.println("...................." + user.getString("userName"));
                e.printStackTrace();
            }
        }
        System.out.println("Its completed... Well done, keep it up..");
    }

    public static long getSizeOfFolder(PciAuthorizationTokenElement ppciTokenElement, String cloudStoragePath) {
        String userNameToGetUrl = "";
        PciAuthorizationTokenElement pciTokenElement = ppciTokenElement;
        String paraBluFolderPath = UpdateCloudStorgeSize.getParabluLibrarySizeUrl(pciTokenElement.getSharePointUrl(), pciTokenElement.getAccountId(), userNameToGetUrl, cloudStoragePath, "");
        long count = 0L;
        String fileUrl = paraBluFolderPath;
        HttpGet httpGet = new HttpGet(fileUrl);
        httpGet.addHeader("Authorization", BEARER + pciTokenElement.getAccessToken());
        httpGet.addHeader(HEADER_KEY_ACCEPT, HEADER_VALUE_APPLICATION_JSON);
        HttpResponse result = null;
        try {
            HttpClient httpclient = HttpClientUtil.getSSlConnection();
            result = httpclient.execute(httpGet);
            int statusCode = result.getStatusLine().getStatusCode();
            if (statusCode == 401) {
                pciTokenElement = Office365.getAccessToken(pciTokenElement);
                long l = UpdateCloudStorgeSize.getSizeOfFolder(pciTokenElement, cloudStoragePath);
                return l;
            }
            if (statusCode != 200) {
                System.out.println("Response code " + statusCode);
                long l = count;
                return l;
            }
            try {
                String json = EntityUtils.toString(result.getEntity());
                JSONObject jsonObject = new JSONObject(json);
                String itemCount = jsonObject.optString("d");
                if (itemCount != null) {
                    jsonObject = new JSONObject(new String(itemCount));
                    String StorageMetrics = jsonObject.optString("StorageMetrics");
                    jsonObject = new JSONObject(new String(StorageMetrics));
                    itemCount = jsonObject.optString("TotalFileStreamSize");
                    count = Long.parseLong(itemCount);
                }
            }
            catch (Exception e) {
                System.out.println(String.valueOf(Thread.currentThread().getName()) + " " + e);
                System.out.println(String.valueOf(Thread.currentThread().getName()) + " Exception While Getting Count of Files In Folder :" + e.getMessage());
            }
        }
        finally {
            httpGet.releaseConnection();
        }
        return count;
    }

    public static String getParabluLibrarySizeUrl(String office365baseUrl, String accountId, String paramUserName, String suffixFolderPath, String pbFolderName1) {
        String pbFolderName = pbFolderName1;
        pbFolderName = "";
        String userName = paramUserName;
        if (!userName.isEmpty()) {
            userName = "/" + userName;
        }
        if (StringUtils.isEmpty(pbFolderName)) {
            pbFolderName = "PB";
        }
        String personalSite = UpdateCloudStorgeSize.getPersonalSite(office365baseUrl, accountId);
        String personalUrl = PERSONAL_URL;
        if (accountId.contains("sites/")) {
            personalUrl = "/";
        }
        return String.valueOf(personalSite) + "/_api/web/getFolderByServerRelativeUrl('" + personalUrl + UpdateCloudStorgeSize.getEmailId(accountId) + "/" + pbFolderName + userName + "/" + suffixFolderPath + "/')?$select=StorageMetrics&$expand=StorageMetrics";
    }

    private static String getUniqueODUserFolder(String deviceUUID) {
        String convertedString = "";
        if (!StringUtils.isEmpty(deviceUUID)) {
            String md5Val = MD5Generator.generateMD5OfString(deviceUUID);
            Long l = ByteBuffer.wrap(md5Val.toString().getBytes()).getLong();
            convertedString = Long.toString(l, 36);
        }
        return convertedString;
    }

    public static String getPersonalSite(String office365baseUrl, String accountId) {
        if (accountId.contains("sites/")) {
            return String.valueOf(office365baseUrl) + "/" + UpdateCloudStorgeSize.getEmailId(accountId);
        }
        return String.valueOf(office365baseUrl) + PERSONAL_URL + UpdateCloudStorgeSize.getEmailId(accountId);
    }

    private static String getEmailId(String emailId) {
        String replacedEmailId = emailId.replace(".", "_");
        replacedEmailId = replacedEmailId.replace("@", "_");
        return replacedEmailId;
    }
}

