#!/bin/bash
#                                                                                       #
# DATE:   20-Feb-2019                                                                   #
# REV:    2.0                                                                           #
# DEVELOPED BY: Parablu Systems                                                         #
# DEVELOPER: VAIBHAV K                                                                  #
# PLATFORM: Ubuntu

PARABLU_CONFIG_SCRIPT_PATH=../config/parablu_config.sh
PARABLU_COMPONENT_SCRIPT_PATH=../config/parablu_component_config.sh

source $PARABLU_CONFIG_SCRIPT_PATH 2> /dev/null
source $PARABLU_COMPONENT_SCRIPT_PATH 2> /dev/null

export PATH="/usr/local/sbin:/usr/local/bin:/usr/sbin:/usr/bin:/sbin:/bin:$PATH"
date_time="`date '+%Y%m%d'`.zip"
SCRIPT_PATH=`pwd`
dbport=$(grep port: /etc/mongod.conf)
MONGODB_PORT=$(echo $dbport | sed -e 's/port://' | sed 's/"//g' | tr -d ' ')

function get_backblaze_creds ()
{
        echo 'use parablu001

db.MONGO_PROPERTIES.find({}).forEach(function(e){print("P_BKID=" +e.backblaze_id)})
db.MONGO_PROPERTIES.find({}).forEach(function(e){print("P_APPKEY=" +e.application_key)})
db.MONGO_PROPERTIES.find({}).forEach(function(e){print("P_BUCKET=" +e.backblaze_bucket)})' >mongobklser_properties.js

        cp mongobklser_properties.js mongobklser_properties_install.js
        sudo mongo localhost:$DBPORT -u "neil" -p "parablu" --authenticationDatabase "admin" < mongobklser_properties_install.js > mongobklser_properties


        BACKBLAZE_ID_VAL=$(grep "P_BKID" mongobklser_properties | sed -e 's/P_BKID=//')
        APPLICATION_KEY_VAL=$(grep "P_APPKEY" mongobklser_properties | sed -e 's/P_APPKEY=//')
        BACKBLAZE_BUCKET_VAL=$(grep "P_BUCKET" mongobklser_properties | sed -e 's/P_BUCKET=//')

        if [ "$BACKBLAZE_ID_VAL" == "undefined" ]; then

                BACKBLAZE_ID="000b8da189f151b0000000001"

        elif [ ! -z "$BACKBLAZE_ID_VAL" ]; then

                BACKBLAZE_ID=$BACKBLAZE_ID_VAL

        else

                BACKBLAZE_ID="000b8da189f151b0000000001"

        fi

        if [ "$APPLICATION_KEY_VAL" == "undefined" ]; then

	decrypt_key=$(java -jar EncryptAndDecypt.jar dec SzAwMCtvcGNiZU13cW1tcFdSREp6dGpkUjYrNUNtWQ==)
                decrypt_key_val=$(echo $decrypt_key | sed -e 's/Result=//')
                APPLICATION_KEY="$decrypt_key_val"

        elif [ ! -z "$APPLICATION_KEY_VAL" ]; then
                decrypt_key=$(java -jar EncryptAndDecypt.jar dec $APPLICATION_KEY_VAL)
                decrypt_key_val=$(echo $decrypt_key | sed -e 's/Result=//')

                APPLICATION_KEY=$decrypt_key_val

        else

                decrypt_key=$(java -jar EncryptAndDecypt.jar dec SzAwMCtvcGNiZU13cW1tcFdSREp6dGpkUjYrNUNtWQ==)
                decrypt_key_val=$(echo $decrypt_key | sed -e 's/Result=//')
                APPLICATION_KEY="$decrypt_key_val"

        fi


        if [ "$BACKBLAZE_BUCKET_VAL" == "undefined" ]; then

                BACKBLAZE_BUCKET="CUST-Mongodbbackup"

        elif [ ! -z "$BACKBLAZE_BUCKET_VAL" ]; then

                BACKBLAZE_BUCKET=$BACKBLAZE_BUCKET_VAL

        else

                BACKBLAZE_BUCKET="CUST-Mongodbbackup"

        fi



}

function get_ip_list ()
{
if [ "$SERVER_TYPE" == "3 1" ]; then

echo 'use parablu001
db.PRIVACY_GATEWAY.distinct("gatewayName");' >iplist.js
else

echo 'use parablu001
db.PRIVACY_GATEWAY.distinct("gatewayName")

db.BLUVAULT.distinct("bluVaultName");' >iplist.js

fi

	sudo mongo localhost:$MONGODB_PORT -u "neil" -p "parablu" --authenticationDatabase "admin" < iplist.js >iplist.log

	grep '"' iplist.log | sed -e 's/\[//' | sed -e 's/\]//' | sed -e 's/"//g' | sed -e 's/,//g'  >sorted_iplist.log
	sed -i "/Implicit/d" sorted_iplist.log
	final_iplist=`cat sorted_iplist.log`
	OTHER_WATCHDOG_IP=$(echo "$final_iplist" | xargs -n1 | sort -u | xargs)

}

function get_cust_name ()
{

	CUSTOMER_NAME=$CLOUD_NAME

}

function check_patch_backblaze ()
{
	get_cust_name
	backblaze-b2 authorize-account $BACKBLAZE_ID $APPLICATION_KEY

	backblaze-b2 ls $BACKBLAZE_BUCKET $CUSTOMER_NAME | grep -oh UpgradeServer-$date_time
	if [ $? -eq 0 ]; then
        	GET_FILE_NAME=`backblaze-b2 ls $BACKBLAZE_BUCKET $CUSTOMER_NAME | grep -oh UpgradeServer-$date_time`

	        echo "NEW SERVER UPDATE AVAILABLE : $GET_FILE_NAME"
        	backblaze-b2 download-file-by-name $BACKBLAZE_BUCKET $CUSTOMER_NAME/UpgradeServer-$date_time UpgradeServer-$date_time
	        if [ $? -eq 0 ]; then

			echo "SERVER UPDATE DOWNLOADED SUCCESSFULLY"
		else
			echo "DOWNLOAD FAILED FROM BACKBLAZE"
	        fi

	else
        	echo "NO NEW SERVER UPDATES AVAILABLE"
		exit
	fi

}

function patch_distribute ()
{
	get_ip_list
	for each_ip in ${OTHER_WATCHDOG_IP[@]}
        	do
                	scp -P $SSH_PORT UpgradeServer-$date_time $SSH_USERNAME@$each_ip:$SCRIPT_PATH/
                done
}

function start_server_upgrade ()
{

	if [ -f UpgradeServer-$date_time ]; then
		unzip -o UpgradeServer-$date_time
        	sleep 2s
	        bash UpgradeServer.sh

		sleep 5s
		rm UpgradeServer-$date_time
		rm UpgradeServer.sh
		rm -rf read_input*
	fi
}

if [ "$KEY_BASED_SSH" == "true" ]; then
        ssh-agent
        eval $(ssh-agent)
        ssh-add $SSH_KEY_FILE
fi

if [ "$SERVER_TYPE" == "0" ]; then
	get_backblaze_creds
	check_patch_backblaze
	start_server_upgrade
elif [ "$SERVER_TYPE" == "3" ] || [ "$SERVER_TYPE" == "3 1" ]; then
	get_backblaze_creds
	check_patch_backblaze
	patch_distribute
	start_server_upgrade
else
	sleep 2m
	start_server_upgrade
fi

if [ "$KEY_BASED_SSH" == "true" ]; then
        killall -9 ssh-agent
fi
