/*
 * Decompiled with CFR 0.152.
 */
package Utility.com.parablu;

import Utility.com.parablu.HttpClientUtil;
import Utility.com.parablu.Office365;
import com.mongodb.BasicDBObject;
import com.mongodb.DBRef;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientURI;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.parablu.pcbd.domain.PciAuthorizationTokenElement;
import java.io.FileWriter;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.util.EntityUtils;
import org.bson.Document;
import org.json.JSONObject;

public class PBFolderSizeDetails {
    private static final String PERSONAL_URL = "/personal/";
    private static final String BEARER = "Bearer ";
    public static final String HEADER_KEY_ACCEPT = "Accept";
    public static final String HEADER_VALUE_APPLICATION_JSON = "application/json;odata=verbose";
    public static final String HEADER_KEY_CONTENT_TYPE = "Content-Type";

    public static void main(String[] args) throws ConfigurationException {
        if (StringUtils.isEmpty(args[0])) {
            System.out.println("mongoIP or port cannot be empty in config file...Please configure and run again :)");
            throw new ArrayIndexOutOfBoundsException();
        }
        System.out.println("mongo IP:Port " + args[0]);
        MongoClientURI uri = new MongoClientURI("mongodb://neil:parablu@" + args[0] + "/parablu001");
        MongoClient client = new MongoClient(uri);
        MongoDatabase db = client.getDatabase(uri.getDatabase());
        MongoClientURI uriPar = new MongoClientURI("mongodb://neil:parablu@" + args[0] + "/parablu");
        MongoClient clientPar = new MongoClient(uriPar);
        MongoDatabase dbPar = clientPar.getDatabase(uriPar.getDatabase());
        MongoCollection<Document> cloudCollection = dbPar.getCollection("CLOUD");
        MongoCollection<Document> cloudCustomiCollection = dbPar.getCollection("CLOUD_CUSTOMIZABLE_DETAILS");
        Document cloud = (Document)cloudCollection.find().first();
        List customaizable = (List)cloud.get("cloudCustomisableDetails");
        boolean isOdbEnabled = false;
        for (DBRef cust : customaizable) {
            Document cu = (Document)cloudCustomiCollection.find(new BasicDBObject("_id", cust.getId())).first();
            if (cu == null || !StringUtils.isNotEmpty(cu.getString("name")) || !cu.getString("name").equals("ODB Enabled")) continue;
            isOdbEnabled = true;
            break;
        }
        if (!isOdbEnabled) {
            System.out.println("ODB Enabled is false.... so return");
            return;
        }
        MongoCollection<Document> tokenCollection = db.getCollection("PCI_AUTHORIZATION_TOKENS");
        Document tokenDoc = (Document)tokenCollection.find().first();
        if (tokenDoc == null) {
            System.out.println("PCI_AUTHORIZATION_TOKENS is null so return");
            return;
        }
        PciAuthorizationTokenElement pciAuthorizationTokenElement = new PciAuthorizationTokenElement();
        pciAuthorizationTokenElement.setAccessToken(tokenDoc.getString("accessToken"));
        pciAuthorizationTokenElement.setAuthenticationToken(tokenDoc.getString("authenticationToken"));
        pciAuthorizationTokenElement.setClientId(tokenDoc.getString("clientId"));
        pciAuthorizationTokenElement.setSharePointUrl(tokenDoc.getString("sharePointUrl"));
        pciAuthorizationTokenElement.setClientSecret(tokenDoc.getString("clientSecret"));
        pciAuthorizationTokenElement.setCloudName(tokenDoc.getString("cloudName"));
        pciAuthorizationTokenElement.setRefreshToken(tokenDoc.getString("refreshToken"));
        pciAuthorizationTokenElement.setSharePointUrl(tokenDoc.getString("sharePointUrl"));
        MongoCollection<Document> userDBCollection = db.getCollection("USER");
        BasicDBObject andQuery = new BasicDBObject();
        ArrayList<BasicDBObject> whereQuery = new ArrayList<BasicDBObject>();
        whereQuery.add(new BasicDBObject("deleted", false));
        andQuery.put("$and", whereQuery);
        FindIterable<Document> users = userDBCollection.find(andQuery);
        StringBuilder builder = new StringBuilder();
        builder.append("User Name,ODB loginId,StatusCode,% Over all quota Used,Over all storage Size,PB folder Size\n");
        for (Document user : users) {
            try {
                String userODBID = "";
                userODBID = !StringUtils.isEmpty(user.getString("odbLoginId")) ? user.getString("odbLoginId") : user.getString("emailId");
                pciAuthorizationTokenElement.setAccountId(userODBID);
                pciAuthorizationTokenElement.setEmailId(userODBID);
                long storageSize = 0L;
                Object[] result = PBFolderSizeDetails.getSiteUsage(pciAuthorizationTokenElement, "");
                storageSize = PBFolderSizeDetails.getSizeOfFolder(pciAuthorizationTokenElement, "");
                builder.append(String.valueOf(user.getString("userName")) + ",");
                builder.append(String.valueOf(userODBID) + ",");
                if ((Integer)result[0] != 200) {
                    builder.append(String.valueOf((Integer)result[0]) + ",,,");
                } else {
                    String pattern = "##.###";
                    DecimalFormat decimalFormat = new DecimalFormat(pattern);
                    String format = decimalFormat.format((Float)result[1]);
                    builder.append(String.valueOf((Integer)result[0]) + "," + format + "%," + PBFolderSizeDetails.formatFileSize((Long)result[2] / 1024L) + ",");
                }
                if (storageSize != 0L) {
                    builder.append(PBFolderSizeDetails.formatFileSize(storageSize /= 1024L));
                } else {
                    builder.append("No pb folder");
                }
                builder.append("\n");
                System.out.println(builder.toString());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        try {
            System.out.println(builder.toString());
            FileWriter fw = new FileWriter("Report.csv");
            fw.write(builder.toString());
            fw.close();
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public static long getSizeOfFolder(PciAuthorizationTokenElement ppciTokenElement, String cloudStoragePath) {
        String userNameToGetUrl = "";
        PciAuthorizationTokenElement pciTokenElement = ppciTokenElement;
        String paraBluFolderPath = PBFolderSizeDetails.getParabluLibrarySizeUrl(pciTokenElement.getSharePointUrl(), pciTokenElement.getAccountId(), userNameToGetUrl, cloudStoragePath, "");
        long count = 0L;
        String fileUrl = paraBluFolderPath;
        HttpGet httpGet = new HttpGet(fileUrl);
        httpGet.addHeader("Authorization", BEARER + pciTokenElement.getAccessToken());
        httpGet.addHeader(HEADER_KEY_ACCEPT, HEADER_VALUE_APPLICATION_JSON);
        HttpResponse result = null;
        try {
            HttpClient httpclient = HttpClientUtil.getSSlConnection();
            result = httpclient.execute(httpGet);
            int statusCode = result.getStatusLine().getStatusCode();
            if (statusCode == 401) {
                pciTokenElement = Office365.getAccessToken(pciTokenElement);
                long l = PBFolderSizeDetails.getSizeOfFolder(pciTokenElement, cloudStoragePath);
                return l;
            }
            if (statusCode != 200) {
                long l = count;
                return l;
            }
            try {
                String json = EntityUtils.toString(result.getEntity());
                JSONObject jsonObject = new JSONObject(json);
                String itemCount = jsonObject.optString("d");
                if (itemCount != null) {
                    jsonObject = new JSONObject(new String(itemCount));
                    String StorageMetrics = jsonObject.optString("StorageMetrics");
                    jsonObject = new JSONObject(new String(StorageMetrics));
                    itemCount = jsonObject.optString("TotalFileStreamSize");
                    count = Long.parseLong(itemCount);
                }
            }
            catch (Exception e) {
                System.out.println(String.valueOf(Thread.currentThread().getName()) + " " + e);
                System.out.println(String.valueOf(Thread.currentThread().getName()) + " Exception While Getting Count of Files In Folder :" + e.getMessage());
            }
        }
        finally {
            httpGet.releaseConnection();
        }
        return count;
    }

    public static Object[] getSiteUsage(PciAuthorizationTokenElement ppciTokenElement, String cloudStoragePath) {
        Object[] resultValues = new Object[3];
        int statusCode = 0;
        resultValues[0] = statusCode;
        String userNameToGetUrl = "";
        PciAuthorizationTokenElement pciTokenElement = ppciTokenElement;
        String paraBluFolderPath = PBFolderSizeDetails.getParabluLibraryUsageURL(pciTokenElement.getSharePointUrl(), pciTokenElement.getAccountId(), userNameToGetUrl, cloudStoragePath, "");
        long count = 0L;
        String fileUrl = paraBluFolderPath;
        HttpGet httpGet = new HttpGet(fileUrl);
        httpGet.addHeader("Authorization", BEARER + pciTokenElement.getAccessToken());
        httpGet.addHeader(HEADER_KEY_ACCEPT, HEADER_VALUE_APPLICATION_JSON);
        HttpResponse result = null;
        try {
            HttpClient httpclient = HttpClientUtil.getSSlConnection();
            result = httpclient.execute(httpGet);
            statusCode = result.getStatusLine().getStatusCode();
            if (statusCode == 401) {
                pciTokenElement = Office365.getAccessToken(pciTokenElement);
                Object[] objectArray = PBFolderSizeDetails.getSiteUsage(pciTokenElement, cloudStoragePath);
                return objectArray;
            }
            if (statusCode != 200) {
                System.out.println("Response code " + statusCode);
                resultValues[0] = statusCode;
                Object[] objectArray = resultValues;
                return objectArray;
            }
            try {
                resultValues[0] = statusCode;
                String json = EntityUtils.toString(result.getEntity());
                JSONObject jsonObject = new JSONObject(json);
                String itemCount = jsonObject.optString("d");
                if (itemCount != null) {
                    System.out.println(itemCount);
                    jsonObject = new JSONObject(new String(itemCount));
                    String StorageMetrics = jsonObject.optString("Usage");
                    jsonObject = new JSONObject(new String(StorageMetrics));
                    itemCount = jsonObject.optString("StoragePercentageUsed");
                    resultValues[1] = Float.valueOf(Float.parseFloat(itemCount));
                    itemCount = jsonObject.optString("Storage");
                    count = Long.parseLong(itemCount);
                    resultValues[2] = count;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                System.out.println(String.valueOf(Thread.currentThread().getName()) + " " + e);
                System.out.println(String.valueOf(Thread.currentThread().getName()) + " Exception While Getting Count of Files In Folder :" + e.getMessage());
            }
        }
        finally {
            httpGet.releaseConnection();
        }
        return resultValues;
    }

    public static String getParabluLibrarySizeUrl(String office365baseUrl, String accountId, String paramUserName, String suffixFolderPath, String pbFolderName1) {
        String pbFolderName = pbFolderName1;
        pbFolderName = "";
        String userName = paramUserName;
        if (!userName.isEmpty()) {
            userName = "/" + userName;
        }
        if (StringUtils.isEmpty(pbFolderName)) {
            pbFolderName = "PB";
        }
        String personalSite = PBFolderSizeDetails.getPersonalSite(office365baseUrl, accountId);
        String personalUrl = PERSONAL_URL;
        if (accountId.contains("sites/")) {
            personalUrl = "/";
        }
        return String.valueOf(personalSite) + "/_api/web/getFolderByServerRelativeUrl('" + personalUrl + PBFolderSizeDetails.getEmailId(accountId) + "/" + pbFolderName + userName + "/" + suffixFolderPath + "/')?$select=StorageMetrics&$expand=StorageMetrics";
    }

    public static String getParabluLibraryUsageURL(String office365baseUrl, String accountId, String paramUserName, String suffixFolderPath, String pbFolderName1) {
        String pbFolderName = pbFolderName1;
        pbFolderName = "";
        String userName = paramUserName;
        if (!userName.isEmpty()) {
            userName = "/" + userName;
        }
        if (StringUtils.isEmpty(pbFolderName)) {
            pbFolderName = "PB";
        }
        String personalSite = PBFolderSizeDetails.getPersonalSite(office365baseUrl, accountId);
        String personalUrl = PERSONAL_URL;
        if (accountId.contains("sites/")) {
            personalUrl = "/";
        }
        return String.valueOf(personalSite) + "/_api/site/usage";
    }

    public static String getPersonalSite(String office365baseUrl, String accountId) {
        if (accountId.contains("sites/")) {
            return String.valueOf(office365baseUrl) + "/" + PBFolderSizeDetails.getEmailId(accountId);
        }
        return String.valueOf(office365baseUrl) + PERSONAL_URL + PBFolderSizeDetails.getEmailId(accountId);
    }

    private static String getEmailId(String emailId) {
        String replacedEmailId = emailId.replace(".", "_");
        replacedEmailId = replacedEmailId.replace("@", "_");
        return replacedEmailId;
    }

    public static String formatFileSize(long size) {
        double m = (double)size / 1024.0;
        double g = (double)size / 1024.0 / 1024.0;
        double t = (double)size / 1024.0 / 1024.0 / 1024.0;
        DecimalFormat dec = new DecimalFormat("0.00");
        String hrSize = t > 1.0 ? dec.format(t).concat(" TB") : (g > 1.0 ? dec.format(g).concat(" GB") : dec.format(m).concat(" MB"));
        return hrSize;
    }
}

