/*
 * Decompiled with CFR 0.152.
 */
package lite;

import com.mongodb.BasicDBObject;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientURI;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.result.UpdateResult;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.bson.Document;
import org.bson.conversions.Bson;

public class UpdateFirstBkpEndTime {
    public static void main(String[] args) {
        if (StringUtils.isEmpty(args[0])) {
            System.out.println("Give mongo details input");
            throw new ArrayIndexOutOfBoundsException();
        }
        boolean canUpdate = Boolean.parseBoolean(args[1]);
        System.out.println("mongo IP:" + args[0]);
        MongoClientURI uri = new MongoClientURI("mongodb://neil:parablu@" + args[0] + "/parablu001");
        MongoClient client = new MongoClient(uri);
        MongoDatabase db = client.getDatabase(uri.getDatabase());
        System.out.println("mongo connectivity success  " + db.getName());
        MongoCollection<Document> bkpBatchDBCollection = db.getCollection("BACKUP_BATCH");
        MongoCollection<Document> deviceBkpCollection = db.getCollection("DEVICE_BACKUP_OVERVIEW");
        FindIterable<Document> devicebkps = deviceBkpCollection.find();
        for (Document bkpOverview : devicebkps) {
            if (bkpOverview.get("firstBkpEndTime") != null && !StringUtils.isEmpty(bkpOverview.getString("firstBkpEndTime"))) continue;
            BasicDBObject andQuery = new BasicDBObject();
            ArrayList<BasicDBObject> whereQuery = new ArrayList<BasicDBObject>();
            whereQuery.add(new BasicDBObject("deviceUUID", bkpOverview.getString("deviceUUID")));
            whereQuery.add(new BasicDBObject("jobType", "BACKUP"));
            andQuery.put("$and", whereQuery);
            long batchsCount = bkpBatchDBCollection.count(andQuery);
            if (batchsCount >= 2L) {
                Document batch = (Document)bkpBatchDBCollection.find(andQuery).sort(new BasicDBObject("batchStartTimestamp", (Object)1)).limit(1).first();
                if (batch != null) {
                    Long long1 = batch.getLong("batchEndTimestamp");
                    String firstSuccessfulEndBkp = UpdateFirstBkpEndTime.getDateInFormat(long1);
                    System.out.println("firstSuccessfulEndBkp :" + firstSuccessfulEndBkp);
                    if (canUpdate) {
                        BasicDBObject updateFields = new BasicDBObject();
                        BasicDBObject updateQuery = new BasicDBObject();
                        updateFields.append("firstBkpEndTime", firstSuccessfulEndBkp);
                        updateQuery.append("$set", updateFields);
                        BasicDBObject query = new BasicDBObject("deviceUUID", bkpOverview.getString("deviceUUID"));
                        UpdateResult updateOne = deviceBkpCollection.updateOne((Bson)query, updateQuery);
                        if (updateOne == null) continue;
                        System.out.println("Updating result...:" + updateOne.toString());
                        continue;
                    }
                    System.out.println("Can update is false...." + bkpOverview.getString("userName"));
                    continue;
                }
                System.out.println("Batch is empty.." + bkpOverview.getString("userName"));
                continue;
            }
            System.out.println("Batch count :" + batchsCount);
        }
    }

    private static String getDateInFormat(Long deviceCreatedDate) {
        SimpleDateFormat df2 = new SimpleDateFormat("dd-MMM-yyyy HH:mm:ss");
        Date dateD = new Date(deviceCreatedDate);
        return df2.format(dateD);
    }
}

