/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ultradns.ws.xml;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableSortedSet;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.ultradns.ws.domain.DirectionalGroup;
import org.jclouds.util.SaxUtils;
import org.xml.sax.Attributes;

public class DirectionalGroupHandler
extends ParseSax.HandlerForGeneratedRequestWithResult<DirectionalGroup> {
    private final DirectionalGroup.Builder group = DirectionalGroup.builder();

    @Override
    public DirectionalGroup getResult() {
        return this.group.build();
    }

    @Override
    public void startElement(String url, String name, String qName, Attributes attrs) {
        if (SaxUtils.equalsOrSuffix(qName, "DirectionalDNSGroupDetail")) {
            this.group.name(attrs.getValue("GroupName"));
            this.group.description(attrs.getValue("Description"));
        } else if (SaxUtils.equalsOrSuffix(qName, "RegionForNewGroups")) {
            String regionName = attrs.getValue("RegionName");
            Iterable<String> territories = Splitter.on(';').split(attrs.getValue("TerritoryName"));
            this.group.mapRegionToTerritories(regionName, ImmutableSortedSet.copyOf(territories));
        }
    }
}

