/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ultradns.ws.predicates;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import org.jclouds.ultradns.ws.domain.Zone;

public class ZonePredicates {
    public static Predicate<Zone> typeEqualTo(Zone.Type type) {
        return new TypeEqualToPredicate(type);
    }

    private static final class TypeEqualToPredicate
    implements Predicate<Zone> {
        private final Zone.Type type;

        public TypeEqualToPredicate(Zone.Type type) {
            this.type = Preconditions.checkNotNull(type, "type");
        }

        @Override
        public boolean apply(Zone input) {
            return input != null && this.type.equals((Object)input.getType());
        }

        public String toString() {
            return "TypeEqualTo(" + (Object)((Object)this.type) + ")";
        }
    }
}

