/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.s3.xml;

import com.google.common.collect.ImmutableSet;
import com.google.common.io.BaseEncoding;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import org.jclouds.date.DateService;
import org.jclouds.http.Uris;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.s3.domain.CanonicalUser;
import org.jclouds.s3.domain.ListBucketResponse;
import org.jclouds.s3.domain.ObjectMetadata;
import org.jclouds.s3.domain.ObjectMetadataBuilder;
import org.jclouds.s3.domain.internal.ListBucketResponseImpl;
import org.jclouds.util.SaxUtils;
import org.jclouds.util.Strings2;
import org.xml.sax.Attributes;

public class ListBucketHandler
extends ParseSax.HandlerWithResult<ListBucketResponse> {
    private ImmutableSet.Builder<ObjectMetadata> contents = ImmutableSet.builder();
    private ImmutableSet.Builder<String> commonPrefixes = ImmutableSet.builder();
    private CanonicalUser currentOwner;
    private StringBuilder currentText = new StringBuilder();
    private ObjectMetadataBuilder builder = new ObjectMetadataBuilder();
    private final DateService dateParser;
    private String bucketName;
    private String prefix;
    private String marker;
    private int maxResults;
    private String delimiter;
    private boolean isTruncated;
    private static final Pattern ETAG_CONTENT_MD5_PATTERN = Pattern.compile("\"([0-9a-f]+)\"");
    private boolean inCommonPrefixes;
    private String currentKey;
    private String nextMarker;

    @Inject
    public ListBucketHandler(DateService dateParser) {
        this.dateParser = dateParser;
    }

    @Override
    public ListBucketResponse getResult() {
        return new ListBucketResponseImpl(this.bucketName, this.contents.build(), this.prefix, this.marker, this.isTruncated && this.nextMarker == null ? this.currentKey : this.nextMarker, this.maxResults, this.delimiter, this.isTruncated, (Set<String>)((Object)this.commonPrefixes.build()));
    }

    @Override
    public void startElement(String uri, String name, String qName, Attributes attrs) {
        if (qName.equals("CommonPrefixes")) {
            this.inCommonPrefixes = true;
        }
        this.currentText.setLength(0);
    }

    @Override
    public void endElement(String uri, String name, String qName) {
        if (qName.equals("ID")) {
            this.currentOwner = new CanonicalUser(SaxUtils.currentOrNull(this.currentText));
        } else if (qName.equals("DisplayName")) {
            this.currentOwner.setDisplayName(SaxUtils.currentOrNull(this.currentText));
        } else if (qName.equals("Key")) {
            if (this.currentText.length() == 0) {
                throw new RuntimeException("Object store returned empty key name");
            }
            this.currentKey = this.currentText.toString();
            this.builder.key(this.currentKey);
            this.builder.uri(Uris.uriBuilder(this.getRequest().getEndpoint()).clearQuery().appendPath(Strings2.urlEncode(this.currentKey, new char[0])).build());
        } else if (qName.equals("LastModified")) {
            this.builder.lastModified(this.dateParser.iso8601DateOrSecondsDateParse(SaxUtils.currentOrNull(this.currentText)));
        } else if (qName.equals("ETag")) {
            String currentETag = SaxUtils.currentOrNull(this.currentText);
            this.builder.eTag(currentETag);
            Matcher matcher = ETAG_CONTENT_MD5_PATTERN.matcher(currentETag);
            if (matcher.matches()) {
                this.builder.contentMD5(BaseEncoding.base16().lowerCase().decode(matcher.group(1)));
            }
        } else if (qName.equals("Size")) {
            this.builder.contentLength(Long.valueOf(SaxUtils.currentOrNull(this.currentText)));
        } else if (qName.equals("Owner")) {
            this.builder.owner(this.currentOwner);
            this.currentOwner = null;
        } else if (qName.equals("StorageClass")) {
            this.builder.storageClass(ObjectMetadata.StorageClass.valueOf(SaxUtils.currentOrNull(this.currentText)));
        } else if (qName.equals("Contents")) {
            this.contents.add((Object)this.builder.build());
            this.builder = new ObjectMetadataBuilder().bucket(this.bucketName);
        } else if (qName.equals("Name")) {
            this.bucketName = SaxUtils.currentOrNull(this.currentText);
            this.builder.bucket(this.bucketName);
        } else if (qName.equals("Prefix")) {
            String prefix = SaxUtils.currentOrNull(this.currentText);
            if (this.inCommonPrefixes) {
                this.commonPrefixes.add((Object)prefix);
            } else {
                this.prefix = prefix;
            }
        } else if (qName.equals("Delimiter")) {
            this.delimiter = SaxUtils.currentOrNull(this.currentText);
        } else if (qName.equals("Marker")) {
            this.marker = SaxUtils.currentOrNull(this.currentText);
        } else if (qName.equals("NextMarker")) {
            this.nextMarker = SaxUtils.currentOrNull(this.currentText);
        } else if (qName.equals("MaxKeys")) {
            this.maxResults = Integer.parseInt(SaxUtils.currentOrNull(this.currentText));
        } else if (qName.equals("IsTruncated")) {
            this.isTruncated = Boolean.parseBoolean(SaxUtils.currentOrNull(this.currentText));
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        this.currentText.append(ch, start, length);
    }
}

