/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.s3.blobstore.config;

import com.google.common.base.Function;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.LoadingCache;
import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.TypeLiteral;
import java.util.concurrent.TimeUnit;
import javax.inject.Singleton;
import org.jclouds.blobstore.BlobRequestSigner;
import org.jclouds.blobstore.BlobStore;
import org.jclouds.blobstore.attr.ConsistencyModel;
import org.jclouds.domain.Location;
import org.jclouds.s3.S3Client;
import org.jclouds.s3.blobstore.S3BlobRequestSigner;
import org.jclouds.s3.blobstore.S3BlobStore;
import org.jclouds.s3.blobstore.functions.LocationFromBucketName;
import org.jclouds.s3.blobstore.internal.BackoffOnNotFoundWhenGetBucketACL;
import org.jclouds.s3.domain.AccessControlList;

public class S3BlobStoreContextModule
extends AbstractModule {
    @Override
    protected void configure() {
        this.bind(ConsistencyModel.class).toInstance(ConsistencyModel.EVENTUAL);
        this.bind(BlobStore.class).to(S3BlobStore.class).in(Scopes.SINGLETON);
        this.bind(new TypeLiteral<Function<String, Location>>(){}).to(LocationFromBucketName.class);
        this.bindRequestSigner();
    }

    protected void bindRequestSigner() {
        this.bind(BlobRequestSigner.class).to((TypeLiteral<BlobRequestSigner>)new TypeLiteral<S3BlobRequestSigner<S3Client>>(){});
    }

    @Provides
    @Singleton
    protected final LoadingCache<String, AccessControlList> bucketAcls(BackoffOnNotFoundWhenGetBucketACL loader) {
        return CacheBuilder.newBuilder().expireAfterWrite(30L, TimeUnit.SECONDS).build(loader);
    }
}

