/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.route53.xml;

import org.jclouds.http.functions.ParseSax;
import org.jclouds.route53.domain.HostedZone;
import org.jclouds.util.SaxUtils;
import org.xml.sax.Attributes;

public class HostedZoneHandler
extends ParseSax.HandlerForGeneratedRequestWithResult<HostedZone> {
    private StringBuilder currentText = new StringBuilder();
    private HostedZone.Builder builder = HostedZone.builder();

    @Override
    public HostedZone getResult() {
        try {
            HostedZone hostedZone = this.builder.build();
            return hostedZone;
        }
        finally {
            this.builder = HostedZone.builder();
        }
    }

    @Override
    public void startElement(String url, String name, String qName, Attributes attributes) {
    }

    @Override
    public void endElement(String uri, String name, String qName) {
        if (qName.equals("Id")) {
            this.builder.id(SaxUtils.currentOrNull(this.currentText).replace("/hostedzone/", ""));
        } else if (qName.equals("Name")) {
            this.builder.name(SaxUtils.currentOrNull(this.currentText));
        } else if (qName.equals("CallerReference")) {
            this.builder.callerReference(SaxUtils.currentOrNull(this.currentText));
        } else if (qName.equals("Comment")) {
            this.builder.comment(SaxUtils.currentOrNull(this.currentText));
        } else if (qName.equals("ResourceRecordSetCount")) {
            this.builder.resourceRecordSetCount(Integer.parseInt(SaxUtils.currentOrNull(this.currentText)));
        }
        this.currentText.setLength(0);
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        this.currentText.append(ch, start, length);
    }
}

