/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rest.internal;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Multimap;
import java.net.URI;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpRequestFilter;
import org.jclouds.io.Payload;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.reflect.Invocation;

public final class GeneratedHttpRequest
extends HttpRequest {
    private final Invocation invocation;
    private final Optional<Invocation> caller;

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Builder toBuilder() {
        return new Builder().fromGeneratedHttpRequest(this);
    }

    protected GeneratedHttpRequest(String method, URI endpoint, Multimap<String, String> headers, @Nullable Payload payload, Iterable<HttpRequestFilter> filters, Invocation invocation, Optional<Invocation> caller) {
        super(method, endpoint, headers, payload, filters);
        this.invocation = Preconditions.checkNotNull(invocation, "invocation");
        this.caller = Preconditions.checkNotNull(caller, "caller");
    }

    public Invocation getInvocation() {
        return this.invocation;
    }

    public Optional<Invocation> getCaller() {
        return this.caller;
    }

    public static final class Builder
    extends HttpRequest.Builder<Builder> {
        private Invocation invocation;
        private Optional<Invocation> caller = Optional.absent();

        public Builder invocation(Invocation invocation) {
            this.invocation = Preconditions.checkNotNull(invocation, "invocation");
            return this;
        }

        public Builder caller(@Nullable Invocation caller) {
            this.caller = Optional.fromNullable(caller);
            return this;
        }

        @Override
        public GeneratedHttpRequest build() {
            return new GeneratedHttpRequest(this.method, this.endpoint, this.headers.build(), this.payload, this.filters.build(), this.invocation, this.caller);
        }

        public Builder fromGeneratedHttpRequest(GeneratedHttpRequest in) {
            return ((Builder)super.fromHttpRequest(in)).invocation(in.invocation).caller(in.getCaller().orNull());
        }

        @Override
        protected Builder self() {
            return this;
        }
    }
}

