/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rackspace.cloudloadbalancers.v1.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.util.Map;
import javax.inject.Inject;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.HttpResponseException;
import org.jclouds.http.functions.ParseJson;
import org.jclouds.rest.InvocationContext;

public class ParseNestedString
implements Function<HttpResponse, String>,
InvocationContext<ParseNestedString> {
    private final ParseJson<Map<String, Map<String, String>>> json;

    @Inject
    ParseNestedString(ParseJson<Map<String, Map<String, String>>> json) {
        this.json = Preconditions.checkNotNull(json, "json");
    }

    @Override
    public String apply(HttpResponse response) {
        Map<String, Map<String, String>> map = this.json.apply(response);
        if (map == null || map.isEmpty()) {
            throw new HttpResponseException("Unexpected JSON format returned.", null, response);
        }
        return Iterables.get(Iterables.get(map.values(), 0).values(), 0);
    }

    @Override
    public ParseNestedString setContext(HttpRequest request) {
        return this;
    }
}

