/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.packet.filters;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.http.HttpException;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpRequestFilter;
import org.jclouds.rest.annotations.ApiVersion;

@Singleton
public class AddApiVersionToRequest
implements HttpRequestFilter {
    private final String apiVersion;

    @Inject
    AddApiVersionToRequest(@ApiVersion String apiVersion) {
        this.apiVersion = apiVersion;
    }

    @Override
    public HttpRequest filter(HttpRequest request) throws HttpException {
        Collection<String> accept = Preconditions.checkNotNull(request.getHeaders().get("Accept"), "accept header must not be null");
        String versionHeader = Joiner.on("; ").join(((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(accept)).add(String.format("version=%s", this.apiVersion))).build());
        return ((HttpRequest.Builder)request.toBuilder().replaceHeader("Accept", versionHeader)).build();
    }
}

