/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.neutron.v2.functions;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import javax.inject.Inject;
import org.jclouds.collect.IterableWithMarker;
import org.jclouds.collect.internal.Arg0ToPagedIterable;
import org.jclouds.openstack.neutron.v2.NeutronApi;
import org.jclouds.openstack.neutron.v2.domain.SecurityGroup;
import org.jclouds.openstack.neutron.v2.features.SecurityGroupApi;
import org.jclouds.openstack.v2_0.options.PaginationOptions;

public class SecurityGroupsToPagedIterable
extends Arg0ToPagedIterable.FromCaller<SecurityGroup, SecurityGroupsToPagedIterable> {
    private final NeutronApi api;

    @Inject
    protected SecurityGroupsToPagedIterable(NeutronApi api) {
        this.api = Preconditions.checkNotNull(api, "api");
    }

    @Override
    protected Function<Object, IterableWithMarker<SecurityGroup>> markerToNextForArg0(Optional<Object> arg0) {
        String region = arg0.isPresent() ? arg0.get().toString() : null;
        final SecurityGroupApi securityGroupApi = this.api.getSecurityGroupApi(region);
        return new Function<Object, IterableWithMarker<SecurityGroup>>(){

            @Override
            public IterableWithMarker<SecurityGroup> apply(Object input) {
                PaginationOptions paginationOptions = (PaginationOptions)PaginationOptions.class.cast(input);
                return (IterableWithMarker)IterableWithMarker.class.cast(securityGroupApi.listSecurityGroups(paginationOptions));
            }

            public String toString() {
                return "listSecurityGroups()";
            }
        };
    }
}

