/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.keystone.auth.functions;

import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.openstack.keystone.auth.AuthenticationApi;
import org.jclouds.openstack.keystone.auth.config.CredentialType;
import org.jclouds.openstack.keystone.auth.domain.AuthInfo;
import org.jclouds.openstack.keystone.auth.domain.TenantOrDomainAndCredentials;
import org.jclouds.openstack.keystone.auth.domain.TokenCredentials;
import org.jclouds.openstack.keystone.auth.functions.BaseAuthenticator;

@CredentialType(value="tokenCredentials")
@Singleton
public class AuthenticateTokenCredentials
extends BaseAuthenticator<TokenCredentials> {
    private final AuthenticationApi auth;

    @Inject
    AuthenticateTokenCredentials(AuthenticationApi auth) {
        this.auth = auth;
    }

    @Override
    public TokenCredentials createCredentials(String identity, String credential) {
        return TokenCredentials.builder().id(credential).build();
    }

    @Override
    public AuthInfo authenticate(TenantOrDomainAndCredentials<TokenCredentials> credentials) {
        return this.auth.authenticateToken(credentials);
    }
}

