/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.json.internal;

import com.google.common.reflect.Invokable;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import org.jclouds.reflect.Reflection2;

public class EnumTypeAdapterThatReturnsFromValue<T extends Enum<T>>
implements JsonSerializer<T>,
JsonDeserializer<T> {
    @Override
    public JsonElement serialize(T src, Type typeOfSrc, JsonSerializationContext context) {
        return new JsonPrimitive(((Enum)src).toString());
    }

    @Override
    public T deserialize(JsonElement json, Type classOfT, JsonDeserializationContext context) throws JsonParseException {
        try {
            return Enum.valueOf((Class)classOfT, json.getAsString());
        }
        catch (IllegalArgumentException e) {
            try {
                Invokable converter = Reflection2.method((Class)classOfT, "fromValue", String.class);
                return (T)((Enum)converter.invoke(null, json.getAsString()));
            }
            catch (Exception e1) {
                throw e;
            }
        }
    }
}

