/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.googlecloudstorage;

import com.google.common.collect.ImmutableSet;
import java.net.URI;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.jclouds.blobstore.BlobStoreContext;
import org.jclouds.googlecloudstorage.GoogleCloudStorageApi;
import org.jclouds.googlecloudstorage.blobstore.config.GoogleCloudStorageBlobStoreContextModule;
import org.jclouds.googlecloudstorage.config.GoogleCloudStorageHttpApiModule;
import org.jclouds.googlecloudstorage.config.GoogleCloudStorageParserModule;
import org.jclouds.oauth.v2.config.OAuthModule;
import org.jclouds.reflect.Reflection2;
import org.jclouds.rest.internal.BaseHttpApiMetadata;

public class GoogleCloudStorageApiMetadata
extends BaseHttpApiMetadata<GoogleCloudStorageApi> {
    public Builder toBuilder() {
        return (Builder)new Builder().fromApiMetadata(this);
    }

    public GoogleCloudStorageApiMetadata() {
        this(new Builder());
    }

    protected GoogleCloudStorageApiMetadata(Builder builder) {
        super(builder);
    }

    public static Properties defaultProperties() {
        Properties properties = BaseHttpApiMetadata.defaultProperties();
        properties.put("oauth.endpoint", "https://accounts.google.com/o/oauth2/token");
        properties.put("jclouds.oauth.audience", "https://accounts.google.com/o/oauth2/token");
        properties.put("jclouds.oauth.jws-alg", "RS256");
        properties.put("jclouds.session-interval", (Object)3600);
        properties.put("jclouds.google-cloud-storage.operation-complete-interval", (Object)2000);
        properties.put("jclouds.google-cloud-storage.operation-complete-timeout", (Object)600000);
        properties.setProperty("jclouds.idempotent-methods", "DELETE,GET,HEAD,OPTIONS,POST,PUT");
        properties.setProperty("jclouds.retries-delay-start", String.valueOf(TimeUnit.SECONDS.toMillis(1L)));
        return properties;
    }

    public static class Builder
    extends BaseHttpApiMetadata.Builder<GoogleCloudStorageApi, Builder> {
        protected Builder() {
            ((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)this.id("google-cloud-storage")).name("Google Cloud Storage Api")).identityName("client_email which usually looks like project_id@developer.gserviceaccount.com or project_id-extended_uid@developer.gserviceaccount.com or account@project_id.company_domain.iam.gserviceaccount.com or account@project_id.iam.gserviceaccount.com.")).credentialName("PEM encoded P12 private key associated with client_email")).documentation(URI.create("https://developers.google.com/storage/docs/json_api"))).version("v1")).defaultEndpoint("https://www.googleapis.com")).defaultProperties(GoogleCloudStorageApiMetadata.defaultProperties())).view(Reflection2.typeToken(BlobStoreContext.class))).defaultModules((Set)((Object)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)ImmutableSet.builder().add(GoogleCloudStorageParserModule.class)).add(OAuthModule.class)).add(GoogleCloudStorageHttpApiModule.class)).add(GoogleCloudStorageBlobStoreContextModule.class)).build()));
        }

        @Override
        public GoogleCloudStorageApiMetadata build() {
            return new GoogleCloudStorageApiMetadata(this);
        }

        @Override
        protected Builder self() {
            return this;
        }
    }
}

