/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.compute.strategy;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.inject.Inject;
import java.util.Collection;
import java.util.Set;
import javax.annotation.Resource;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.aws.util.AWSUtils;
import org.jclouds.compute.domain.ComputeMetadata;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.predicates.NodePredicates;
import org.jclouds.compute.strategy.ListNodesStrategy;
import org.jclouds.ec2.EC2Api;
import org.jclouds.ec2.domain.Reservation;
import org.jclouds.ec2.domain.RunningInstance;
import org.jclouds.location.Region;
import org.jclouds.logging.Logger;

@Singleton
public class EC2ListNodesStrategy
implements ListNodesStrategy {
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;
    @Inject(optional=true)
    @Named(value="jclouds.request-timeout")
    protected static Long maxTime;
    protected final EC2Api client;
    protected final Supplier<Set<String>> regions;
    protected final Function<RunningInstance, NodeMetadata> runningInstanceToNodeMetadata;
    protected final ListeningExecutorService userExecutor;

    @Inject
    protected EC2ListNodesStrategy(EC2Api client, @Region Supplier<Set<String>> regions, Function<RunningInstance, NodeMetadata> runningInstanceToNodeMetadata, @Named(value="jclouds.user-threads") ListeningExecutorService userExecutor) {
        this.client = Preconditions.checkNotNull(client, "client");
        this.regions = Preconditions.checkNotNull(regions, "regions");
        this.runningInstanceToNodeMetadata = Preconditions.checkNotNull(runningInstanceToNodeMetadata, "runningInstanceToNodeMetadata");
        this.userExecutor = Preconditions.checkNotNull(userExecutor, "userExecutor");
    }

    public Set<? extends ComputeMetadata> listNodes() {
        return this.listDetailsOnNodesMatching(NodePredicates.all());
    }

    public Set<? extends NodeMetadata> listNodesByIds(Iterable<String> ids) {
        ImmutableListMultimap<String, String> idsByHandles = Multimaps.index(ids, this.splitHandle(1));
        Multimap<String, String> idsByRegions = Multimaps.transformValues(idsByHandles, this.splitHandle(0));
        Multimap<String, String> idsByConfiguredRegions = Multimaps.filterKeys(idsByRegions, Predicates.in((Collection)this.regions.get()));
        if (idsByConfiguredRegions.isEmpty()) {
            return ImmutableSet.of();
        }
        Iterable<? extends RunningInstance> instances = this.pollRunningInstancesByRegionsAndIds(idsByConfiguredRegions);
        Iterable<NodeMetadata> nodes = Iterables.transform(Iterables.filter(instances, Predicates.notNull()), this.runningInstanceToNodeMetadata);
        return ImmutableSet.copyOf(nodes);
    }

    public Set<? extends NodeMetadata> listDetailsOnNodesMatching(Predicate<? super NodeMetadata> filter) {
        Iterable<? extends RunningInstance> instances = this.pollRunningInstances();
        Iterable<? super NodeMetadata> nodes = Iterables.filter(Iterables.transform(Iterables.filter(instances, Predicates.notNull()), this.runningInstanceToNodeMetadata), Predicates.and(Predicates.notNull(), filter));
        return ImmutableSet.copyOf(nodes);
    }

    protected Iterable<? extends RunningInstance> pollRunningInstances() {
        Iterable<Set<? extends Reservation<? extends RunningInstance>>> reservations = Iterables.transform((Iterable)this.regions.get(), this.allInstancesInRegion());
        return Iterables.concat(Iterables.concat(reservations));
    }

    protected Iterable<? extends RunningInstance> pollRunningInstancesByRegionsAndIds(Multimap<String, String> idsByRegions) {
        Iterable<Set<? extends Reservation<? extends RunningInstance>>> reservations = Iterables.transform(idsByRegions.keySet(), this.instancesByIdInRegion(idsByRegions));
        return Iterables.concat(Iterables.concat(reservations));
    }

    protected Function<String, String> splitHandle(final int pos) {
        return new Function<String, String>(){

            @Override
            public String apply(String handle) {
                return AWSUtils.parseHandle(handle)[pos];
            }
        };
    }

    protected Function<String, Set<? extends Reservation<? extends RunningInstance>>> allInstancesInRegion() {
        return new Function<String, Set<? extends Reservation<? extends RunningInstance>>>(){

            @Override
            public Set<? extends Reservation<? extends RunningInstance>> apply(String from) {
                return EC2ListNodesStrategy.this.client.getInstanceApi().get().describeInstancesInRegion(from, new String[0]);
            }
        };
    }

    protected Function<String, Set<? extends Reservation<? extends RunningInstance>>> instancesByIdInRegion(final Multimap<String, String> idsByRegions) {
        return new Function<String, Set<? extends Reservation<? extends RunningInstance>>>(){

            @Override
            public Set<? extends Reservation<? extends RunningInstance>> apply(String from) {
                return EC2ListNodesStrategy.this.client.getInstanceApi().get().describeInstancesInRegion(from, Iterables.toArray(idsByRegions.get(from), String.class));
            }
        };
    }
}

