/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudwatch.options;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import java.util.Date;
import org.jclouds.cloudwatch.domain.HistoryItemType;
import org.jclouds.date.DateService;
import org.jclouds.date.internal.SimpleDateFormatDateService;
import org.jclouds.http.options.BaseHttpRequestOptions;

@Beta
public class ListAlarmHistoryOptions
extends BaseHttpRequestOptions {
    private static final DateService dateService = new SimpleDateFormatDateService();

    public ListAlarmHistoryOptions alarmName(String alarmName) {
        Preconditions.checkNotNull(alarmName, "alarmName");
        Preconditions.checkArgument(alarmName.length() <= 255, "alarmName must be between 1 and 255 characters in length");
        this.formParameters.put("AlarmName", alarmName);
        return this;
    }

    public ListAlarmHistoryOptions endDate(Date endDate) {
        this.formParameters.put("EndDate", dateService.iso8601DateFormat(Preconditions.checkNotNull(endDate, "endDate")));
        return this;
    }

    public ListAlarmHistoryOptions historyItemType(HistoryItemType historyItemType) {
        Preconditions.checkNotNull(historyItemType, "historyItemType");
        Preconditions.checkArgument(historyItemType != HistoryItemType.UNRECOGNIZED, "historyItemType unrecognized");
        this.formParameters.put("HistoryItemType", historyItemType.toString());
        return this;
    }

    public ListAlarmHistoryOptions maxRecords(int maxRecords) {
        this.formParameters.put("MaxRecords", String.valueOf(maxRecords));
        return this;
    }

    public ListAlarmHistoryOptions startDate(Date startDate) {
        this.formParameters.put("StartDate", dateService.iso8601DateFormat(Preconditions.checkNotNull(startDate, "startDate")));
        return this;
    }
}

