/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.chef.domain;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.gson.annotations.SerializedName;
import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.List;
import org.jclouds.domain.JsonBall;
import org.jclouds.javax.annotation.Nullable;

public class BootstrapConfig {
    @SerializedName(value="run_list")
    private final List<String> runList;
    @Nullable
    private final String environment;
    @Nullable
    private final JsonBall attributes;
    @SerializedName(value="ssl_ca_file")
    @Nullable
    private final String sslCAFile;
    @SerializedName(value="ssl_ca_path")
    @Nullable
    private final String sslCAPath;
    @SerializedName(value="ssl_verify_mode")
    @Nullable
    private final SSLVerifyMode sslVerifyMode;
    @SerializedName(value="verify_api_cert")
    @Nullable
    private final Boolean verifyApiCert;

    public static Builder builder() {
        return new Builder();
    }

    @ConstructorProperties(value={"run_list", "environment", "attributes", "ssl_ca_file", "ssl_ca_path", "ssl_verify_mode", "verify_api_cert"})
    protected BootstrapConfig(List<String> runList, @Nullable String environment, @Nullable JsonBall attributes, @Nullable String sslCAFile, @Nullable String sslCAPath, @Nullable SSLVerifyMode sslVerifyMode, @Nullable Boolean verifyApiCert) {
        this.runList = ImmutableList.copyOf((Collection)Preconditions.checkNotNull(runList, "runList"));
        this.environment = environment;
        this.attributes = attributes;
        this.sslCAFile = sslCAFile;
        this.sslCAPath = sslCAPath;
        this.sslVerifyMode = sslVerifyMode;
        this.verifyApiCert = verifyApiCert;
    }

    public List<String> getRunList() {
        return this.runList;
    }

    @Nullable
    public String getEnvironment() {
        return this.environment;
    }

    @Nullable
    public JsonBall getAttributes() {
        return this.attributes;
    }

    @Nullable
    public String getSslCAFile() {
        return this.sslCAFile;
    }

    @Nullable
    public String getSslCAPath() {
        return this.sslCAPath;
    }

    @Nullable
    public SSLVerifyMode getSslVerifyMode() {
        return this.sslVerifyMode;
    }

    @Nullable
    public Boolean getVerifyApiCert() {
        return this.verifyApiCert;
    }

    public static class Builder {
        private ImmutableList.Builder<String> runList = ImmutableList.builder();
        private String environment;
        private JsonBall attribtues;
        private String sslCAFile;
        private String sslCAPath;
        private SSLVerifyMode sslVerifyMode;
        private Boolean verifyApiCert;

        public Builder runList(Iterable<String> runList) {
            this.runList.addAll((Iterable)Preconditions.checkNotNull(runList, "runList"));
            return this;
        }

        public Builder environment(String environment) {
            this.environment = Preconditions.checkNotNull(environment, "environment");
            return this;
        }

        public Builder attributes(JsonBall attributes) {
            this.attribtues = Preconditions.checkNotNull(attributes, "attributes");
            return this;
        }

        public Builder sslCAFile(String sslCAFile) {
            this.sslCAFile = Preconditions.checkNotNull(sslCAFile, "sslCAFile");
            return this;
        }

        public Builder sslCAPath(String sslCAPath) {
            this.sslCAPath = Preconditions.checkNotNull(sslCAPath, "sslCAPath");
            return this;
        }

        public Builder sslVerifyMode(SSLVerifyMode sslVerifyMode) {
            this.sslVerifyMode = Preconditions.checkNotNull(sslVerifyMode, "sslVerifyMode");
            return this;
        }

        public Builder verifyApiCert(boolean verifyApiCert) {
            this.verifyApiCert = verifyApiCert;
            return this;
        }

        public BootstrapConfig build() {
            return new BootstrapConfig((List<String>)((Object)this.runList.build()), this.environment, this.attribtues, this.sslCAFile, this.sslCAPath, this.sslVerifyMode, this.verifyApiCert);
        }
    }

    public static enum SSLVerifyMode {
        NONE,
        PEER;


        public String toString() {
            return ":verify_" + this.name().toLowerCase();
        }

        public static SSLVerifyMode fromValue(String value) {
            return SSLVerifyMode.valueOf(value.replaceAll(":verify_", "").toUpperCase());
        }
    }
}

