/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azurecompute.arm.domain;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.jclouds.azurecompute.arm.domain.AutoValue_VirtualMachineScaleSetOSProfile;
import org.jclouds.azurecompute.arm.domain.AutoValue_VirtualMachineScaleSetOSProfile_LinuxConfiguration;
import org.jclouds.azurecompute.arm.domain.AutoValue_VirtualMachineScaleSetOSProfile_LinuxConfiguration_SSH;
import org.jclouds.azurecompute.arm.domain.AutoValue_VirtualMachineScaleSetOSProfile_LinuxConfiguration_SSH_SSHPublicKey;
import org.jclouds.azurecompute.arm.domain.AutoValue_VirtualMachineScaleSetOSProfile_WindowsConfiguration;
import org.jclouds.azurecompute.arm.domain.AutoValue_VirtualMachineScaleSetOSProfile_WindowsConfiguration_AdditionalUnattendContent;
import org.jclouds.azurecompute.arm.domain.AutoValue_VirtualMachineScaleSetOSProfile_WindowsConfiguration_WinRM;
import org.jclouds.azurecompute.arm.domain.AutoValue_VirtualMachineScaleSetOSProfile_WindowsConfiguration_WinRM_ProtocolListener;
import org.jclouds.azurecompute.arm.domain.Secrets;
import org.jclouds.azurecompute.arm.util.GetEnumValue;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.json.SerializedNames;

public abstract class VirtualMachineScaleSetOSProfile {
    @Nullable
    public abstract String computerNamePrefix();

    @Nullable
    public abstract String adminUsername();

    @Nullable
    public abstract String adminPassword();

    @Nullable
    public abstract LinuxConfiguration linuxConfiguration();

    @Nullable
    public abstract WindowsConfiguration windowsConfiguration();

    public abstract List<Secrets> secrets();

    @SerializedNames(value={"computerNamePrefix", "adminUsername", "adminPassword", "linuxConfiguration", "windowsConfiguration", "secrets"})
    public static VirtualMachineScaleSetOSProfile create(String computerNamePrefix, String adminUsername, String adminPassword, LinuxConfiguration linuxConfiguration, WindowsConfiguration windowsConfiguration, List<Secrets> secrets) {
        return VirtualMachineScaleSetOSProfile.builder().computerNamePrefix(computerNamePrefix).adminUsername(adminUsername).adminPassword(adminPassword).linuxConfiguration(linuxConfiguration).windowsConfiguration(windowsConfiguration).secrets(secrets != null ? ImmutableList.copyOf(secrets) : ImmutableList.of()).build();
    }

    public abstract Builder toBuilder();

    public static Builder builder() {
        return new AutoValue_VirtualMachineScaleSetOSProfile.Builder();
    }

    public static abstract class Builder {
        public abstract Builder computerNamePrefix(String var1);

        public abstract Builder adminUsername(String var1);

        public abstract Builder adminPassword(String var1);

        public abstract Builder linuxConfiguration(LinuxConfiguration var1);

        public abstract Builder windowsConfiguration(WindowsConfiguration var1);

        public abstract Builder secrets(List<Secrets> var1);

        public abstract VirtualMachineScaleSetOSProfile build();
    }

    public static abstract class WindowsConfiguration {
        public abstract boolean provisionVMAgent();

        @Nullable
        public abstract WinRM winRM();

        public abstract List<AdditionalUnattendContent> additionalUnattendContent();

        public abstract boolean enableAutomaticUpdates();

        @SerializedNames(value={"provisionVMAgent", "winRM", "additionalUnattendContent", "enableAutomaticUpdates"})
        public static WindowsConfiguration create(boolean provisionVMAgent, WinRM winRM, List<AdditionalUnattendContent> additionalUnattendContent, boolean enableAutomaticUpdates) {
            return new AutoValue_VirtualMachineScaleSetOSProfile_WindowsConfiguration(provisionVMAgent, winRM, additionalUnattendContent == null ? ImmutableList.of() : ImmutableList.copyOf(additionalUnattendContent), enableAutomaticUpdates);
        }

        public static abstract class AdditionalUnattendContent {
            public abstract String pass();

            public abstract String component();

            public abstract String settingName();

            public abstract String content();

            @SerializedNames(value={"pass", "component", "settingName", "content"})
            public static AdditionalUnattendContent create(String pass, String component, String settingName, String content) {
                return new AutoValue_VirtualMachineScaleSetOSProfile_WindowsConfiguration_AdditionalUnattendContent(pass, component, settingName, content);
            }
        }

        public static abstract class WinRM {
            public abstract List<ProtocolListener> listeners();

            @SerializedNames(value={"listeners"})
            public static WinRM create(List<ProtocolListener> listeners) {
                return new AutoValue_VirtualMachineScaleSetOSProfile_WindowsConfiguration_WinRM(listeners == null ? ImmutableList.of() : ImmutableList.copyOf(listeners));
            }

            public static abstract class ProtocolListener {
                public abstract Protocol protocol();

                @Nullable
                public abstract String certificateUrl();

                @SerializedNames(value={"protocol", "certificateUrl"})
                public static ProtocolListener create(Protocol protocol, String certificateUrl) {
                    return new AutoValue_VirtualMachineScaleSetOSProfile_WindowsConfiguration_WinRM_ProtocolListener(protocol, certificateUrl);
                }
            }

            public static enum Protocol {
                HTTP("http"),
                HTTPS("https"),
                UNRECOGNIZED("Unrecognized");

                private String value;

                private Protocol(String value) {
                    this.value = value;
                }

                public static Protocol fromValue(String value) {
                    return (Protocol)GetEnumValue.fromValueOrDefault(value, UNRECOGNIZED);
                }

                public String toString() {
                    return this.value;
                }
            }
        }
    }

    public static abstract class LinuxConfiguration {
        public abstract Boolean disablePasswordAuthentication();

        @Nullable
        public abstract SSH ssh();

        @SerializedNames(value={"disablePasswordAuthentication", "ssh"})
        public static LinuxConfiguration create(Boolean disablePasswordAuthentication, SSH ssh) {
            return new AutoValue_VirtualMachineScaleSetOSProfile_LinuxConfiguration(disablePasswordAuthentication, ssh);
        }

        public static abstract class SSH {
            @Nullable
            public abstract List<SSHPublicKey> publicKeys();

            @SerializedNames(value={"publicKeys"})
            public static SSH create(List<SSHPublicKey> publicKeys) {
                return new AutoValue_VirtualMachineScaleSetOSProfile_LinuxConfiguration_SSH(publicKeys);
            }

            public static abstract class SSHPublicKey {
                @Nullable
                public abstract String path();

                @Nullable
                public abstract String keyData();

                @SerializedNames(value={"path", "keyData"})
                public static SSHPublicKey create(String path, String keyData) {
                    return new AutoValue_VirtualMachineScaleSetOSProfile_LinuxConfiguration_SSH_SSHPublicKey(path, keyData);
                }
            }
        }
    }
}

