/*
 * Decompiled with CFR 0.152.
 */
package com.backblaze.b2.util;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class B2Collections {
    public static <T> Set<T> unmodifiableSet(T[] elements) {
        HashSet<T> set = new HashSet<T>(elements.length);
        set.addAll(Arrays.asList(elements));
        return Collections.unmodifiableSet(set);
    }

    public static <K, V> Map<K, V> unmodifiableMap(Map<K, V> orig) {
        TreeMap<K, V> map = new TreeMap<K, V>();
        map.putAll(orig);
        return Collections.unmodifiableMap(map);
    }

    public static <K, V> Map<K, V> mapOf() {
        return new TreeMap();
    }

    public static <K, V> Map<K, V> mapOf(K k1, V v1) {
        TreeMap<K, V> map = new TreeMap<K, V>();
        map.put(k1, v1);
        return map;
    }

    public static <K, V> Map<K, V> mapOf(K k1, V v1, K k2, V v2) {
        TreeMap<K, V> map = new TreeMap<K, V>();
        map.put(k1, v1);
        map.put(k2, v2);
        return map;
    }

    public static <K, V> Map<K, V> mapOf(K k1, V v1, K k2, V v2, K k3, V v3) {
        TreeMap<K, V> map = new TreeMap<K, V>();
        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        return map;
    }

    @SafeVarargs
    public static <T> List<T> listOf(T ... orig) {
        return Arrays.asList(orig);
    }
}

