/*
 * Decompiled with CFR 0.152.
 */
package com.backblaze.b2.json;

import com.backblaze.b2.json.B2JsonException;
import com.backblaze.b2.json.B2JsonHandlerMap;
import com.backblaze.b2.json.B2JsonListHandler;
import com.backblaze.b2.json.B2JsonMapHandler;
import com.backblaze.b2.json.B2JsonObjectHandler;
import com.backblaze.b2.json.B2JsonOptions;
import com.backblaze.b2.json.B2JsonReader;
import com.backblaze.b2.json.B2JsonTypeHandler;
import com.backblaze.b2.json.B2JsonWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.StringReader;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;

public class B2Json {
    private static String UTF8 = "UTF-8";
    private static final B2Json instance = new B2Json();
    @Deprecated
    public static final int ALLOW_EXTRA_FIELDS = 1;
    private final B2JsonHandlerMap handlerMap = new B2JsonHandlerMap();
    static final Class<? extends Annotation>[] ALL_ANNOTATIONS = new Class[]{union.class, required.class, optional.class, optionalWithDefault.class, ignored.class, constructor.class, defaultForInvalidEnumValue.class, firstVersion.class, versionRange.class};

    public static B2Json get() {
        return instance;
    }

    B2Json() {
    }

    public byte[] toJsonUtf8Bytes(Object obj) throws B2JsonException {
        return this.toJsonUtf8Bytes(obj, B2JsonOptions.DEFAULT);
    }

    public byte[] toJsonUtf8Bytes(Object obj, B2JsonOptions options) throws B2JsonException {
        try {
            return this.toJson(obj, options).getBytes(UTF8);
        }
        catch (IOException e) {
            throw new RuntimeException("error writing to byte array: " + e.getMessage());
        }
    }

    public byte[] toJsonUtf8BytesWithNewline(Object obj) throws B2JsonException {
        return this.toJsonUtf8BytesWithNewline(obj, B2JsonOptions.DEFAULT);
    }

    public byte[] toJsonUtf8BytesWithNewline(Object obj, B2JsonOptions options) throws B2JsonException {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            this.toJson(obj, options, out);
            out.write(10);
            return out.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException("error writing to byte array: " + e.getMessage());
        }
    }

    public void toJson(Object obj, OutputStream out) throws IOException, B2JsonException {
        this.toJson(obj, B2JsonOptions.DEFAULT, out);
    }

    public void toJson(Object obj, B2JsonOptions options, OutputStream out) throws IOException, B2JsonException {
        this.toJson(obj, options, out, null);
    }

    public void toJson(Object obj, B2JsonOptions options, OutputStream out, Type objTypeOrNull) throws IOException, B2JsonException {
        if (obj == null) {
            throw new B2JsonException("top level object must not be null");
        }
        B2JsonTypeHandler<Object> handler = objTypeOrNull == null ? this.handlerMap.getHandler(obj.getClass()) : this.handlerMap.getHandler(objTypeOrNull);
        B2JsonWriter jsonWriter = new B2JsonWriter(out, options);
        handler.serialize(obj, options, jsonWriter);
    }

    public String toJson(Object obj) throws B2JsonException {
        return this.toJson(obj, B2JsonOptions.DEFAULT);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String toJson(Object obj, B2JsonOptions options) throws B2JsonException {
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            this.toJson(obj, options, out);
            String string = out.toString("UTF-8");
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException("IO exception writing to string");
        }
    }

    public static String toJsonOrThrowRuntime(Object obj) {
        return B2Json.toJsonOrThrowRuntime(obj, B2JsonOptions.DEFAULT);
    }

    public static String toJsonOrThrowRuntime(Object obj, B2JsonOptions options) {
        try {
            return B2Json.get().toJson(obj, options);
        }
        catch (B2JsonException e) {
            throw new IllegalArgumentException("failed to convert to json: " + e.getMessage(), e);
        }
    }

    public static <T> T fromJsonOrThrowRuntime(String json, Class<T> clazz) {
        return B2Json.fromJsonOrThrowRuntime(json, clazz, B2JsonOptions.DEFAULT);
    }

    public static <T> T fromJsonOrThrowRuntime(String json, Class<T> clazz, B2JsonOptions options) {
        try {
            return B2Json.get().fromJson(json, clazz, options);
        }
        catch (B2JsonException e) {
            throw new IllegalArgumentException("failed to convert from json: " + e.getMessage(), e);
        }
    }

    public String mapToJson(Map<?, ?> map, Class<?> keyClass, Class<?> valueClass) throws B2JsonException {
        return this.mapToJson(map, keyClass, valueClass, B2JsonOptions.DEFAULT);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String mapToJson(Map<?, ?> map, Class<?> keyClass, Class<?> valueClass, B2JsonOptions options) throws B2JsonException {
        if (map == null) {
            throw new B2JsonException("map must not be null");
        }
        B2JsonTypeHandler keyHandler = this.handlerMap.getHandler(keyClass);
        B2JsonTypeHandler valueHandler = this.handlerMap.getHandler(valueClass);
        B2JsonMapHandler handler = new B2JsonMapHandler(keyHandler, valueHandler);
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            B2JsonWriter jsonWriter = new B2JsonWriter(out, options);
            handler.serialize(map, options, jsonWriter);
            String string = out.toString("UTF-8");
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException("IO exception writing to string");
        }
    }

    public <K, V> Map<K, V> mapFromJson(String json, Class<K> keyClass, Class<V> valueClass) throws B2JsonException {
        return this.mapFromJson(json, keyClass, valueClass, B2JsonOptions.DEFAULT);
    }

    public <K, V> Map<K, V> mapFromJson(String json, Class<K> keyClass, Class<V> valueClass, B2JsonOptions options) throws B2JsonException {
        B2JsonTypeHandler keyHandler = this.handlerMap.getHandler(keyClass);
        B2JsonTypeHandler valueHandler = this.handlerMap.getHandler(valueClass);
        B2JsonMapHandler handler = new B2JsonMapHandler(keyHandler, valueHandler);
        return (Map)this.fromJsonWithHandler(json, (B2JsonTypeHandler)handler, options);
    }

    public String listToJson(List<?> list, Class<?> valueClass) throws B2JsonException {
        return this.listToJson(list, valueClass, B2JsonOptions.DEFAULT);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String listToJson(List<?> list, Class<?> valueClass, B2JsonOptions options) throws B2JsonException {
        if (list == null) {
            throw new B2JsonException("list must not be null");
        }
        B2JsonTypeHandler valueHandler = this.handlerMap.getHandler(valueClass);
        B2JsonListHandler handler = new B2JsonListHandler(valueHandler);
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            B2JsonWriter jsonWriter = new B2JsonWriter(out, options);
            handler.serialize(list, options, jsonWriter);
            String string = out.toString("UTF-8");
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException("IO exception writing to string");
        }
    }

    public <V> List<V> listFromJson(String json, Class<V> valueClass) throws B2JsonException {
        return this.listFromJson(json, valueClass, B2JsonOptions.DEFAULT);
    }

    public <V> List<V> listFromJson(String json, Class<V> valueClass, B2JsonOptions options) throws B2JsonException {
        B2JsonTypeHandler valueHandler = this.handlerMap.getHandler(valueClass);
        B2JsonListHandler handler = new B2JsonListHandler(valueHandler);
        return (List)this.fromJsonWithHandler(json, (B2JsonTypeHandler)handler, options);
    }

    public <T> T fromJsonUntilEof(InputStream in, Class<T> clazz) throws IOException, B2JsonException {
        return this.fromJsonUntilEof(in, clazz, B2JsonOptions.DEFAULT);
    }

    @Deprecated
    public <T> T fromJsonUntilEof(InputStream in, Class<T> clazz, int optionFlags) throws IOException, B2JsonException {
        return this.fromJsonUntilEof(in, clazz, B2Json.optionsFromFlags(optionFlags));
    }

    public <T> T fromJsonUntilEof(InputStream in, Class<T> clazz, B2JsonOptions options) throws IOException, B2JsonException {
        B2JsonReader reader = new B2JsonReader(new InputStreamReader(in, "UTF-8"));
        B2JsonTypeHandler handler = this.handlerMap.getHandler(clazz);
        Object result = handler.deserialize(reader, options);
        if (!reader.nextNonWhitespaceIsEof()) {
            throw new B2JsonException("non-whitespace characters after JSON value");
        }
        return result;
    }

    public <T> T fromJson(InputStream in, Class<T> clazz) throws IOException, B2JsonException {
        return this.fromJson(in, clazz, B2JsonOptions.DEFAULT);
    }

    @Deprecated
    public <T> T fromJson(InputStream in, Class<T> clazz, int optionFlags) throws IOException, B2JsonException {
        return this.fromJson(in, clazz, B2Json.optionsFromFlags(optionFlags));
    }

    public <T> T fromJson(InputStream in, Type type, B2JsonOptions options) throws IOException, B2JsonException {
        B2JsonReader reader = new B2JsonReader(new InputStreamReader(in, "UTF-8"));
        B2JsonTypeHandler handler = this.handlerMap.getHandler(type);
        if (handler == null) {
            throw new B2JsonException("B2Json.fromJson called with handler not in handlerMap");
        }
        return handler.deserialize(reader, options);
    }

    public <T> T fromJson(String json, Class<T> clazz) throws B2JsonException {
        return this.fromJson(json, clazz, B2JsonOptions.DEFAULT);
    }

    @Deprecated
    public <T> T fromJson(String json, Class<T> clazz, int optionFlags) throws B2JsonException {
        return this.fromJson(json, clazz, B2Json.optionsFromFlags(optionFlags));
    }

    public <T> T fromJson(String json, Class<T> clazz, B2JsonOptions options) throws B2JsonException {
        B2JsonTypeHandler handler = this.handlerMap.getHandler(clazz);
        return this.fromJsonWithHandler(json, handler, options);
    }

    @Deprecated
    private <T> T fromJsonWithHandler(String json, B2JsonTypeHandler handler, int optionFlags) throws B2JsonException {
        return this.fromJsonWithHandler(json, handler, B2Json.optionsFromFlags(optionFlags));
    }

    private <T> T fromJsonWithHandler(String json, B2JsonTypeHandler handler, B2JsonOptions options) throws B2JsonException {
        try {
            B2JsonReader reader = new B2JsonReader(new StringReader(json));
            return handler.deserialize(reader, options);
        }
        catch (IOException e) {
            throw new RuntimeException("error reading string", e);
        }
    }

    public <T> T fromJson(byte[] jsonUtf8Bytes, Class<T> clazz) throws IOException, B2JsonException {
        return this.fromJson(jsonUtf8Bytes, clazz, B2JsonOptions.DEFAULT);
    }

    @Deprecated
    public <T> T fromJson(byte[] jsonUtf8Bytes, Class<T> clazz, int optionFlags) throws IOException, B2JsonException {
        return this.fromJson(jsonUtf8Bytes, clazz, B2Json.optionsFromFlags(optionFlags));
    }

    public <T> T fromJson(byte[] jsonUtf8Bytes, Class<T> clazz, B2JsonOptions options) throws IOException, B2JsonException {
        B2JsonReader reader = new B2JsonReader(new InputStreamReader((InputStream)new ByteArrayInputStream(jsonUtf8Bytes), "UTF-8"));
        B2JsonTypeHandler handler = this.handlerMap.getHandler(clazz);
        return handler.deserialize(reader, options);
    }

    public <T> T fromUrlParameterMap(Map<String, String> parameterMap, Class<T> clazz) throws IOException, B2JsonException {
        return this.fromUrlParameterMap(parameterMap, clazz, B2JsonOptions.DEFAULT);
    }

    @Deprecated
    public <T> T fromUrlParameterMap(Map<String, String> parameterMap, Class<T> clazz, int optionFlags) throws IOException, B2JsonException {
        return this.fromUrlParameterMap(parameterMap, clazz, B2Json.optionsFromFlags(optionFlags));
    }

    public <T> T fromUrlParameterMap(Map<String, String> parameterMap, Class<T> clazz, B2JsonOptions options) throws IOException, B2JsonException {
        B2JsonTypeHandler handler = this.handlerMap.getHandler(clazz);
        if (!(handler instanceof B2JsonObjectHandler)) {
            throw new B2JsonException("only objects can be deserialized from parameter maps");
        }
        B2JsonObjectHandler objectHandler = (B2JsonObjectHandler)handler;
        return objectHandler.deserializeFromUrlParameterMap(parameterMap, options);
    }

    private static B2JsonOptions optionsFromFlags(int optionFlags) {
        if ((optionFlags & 1) == 0) {
            return B2JsonOptions.DEFAULT;
        }
        return B2JsonOptions.DEFAULT_AND_ALLOW_EXTRA_FIELDS;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface defaultForInvalidEnumValue {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.CONSTRUCTOR})
    public static @interface constructor {
        public String params();

        public String discards() default "";

        public String versionParam() default "";
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface sensitive {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface versionRange {
        public int firstVersion();

        public int lastVersion();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface firstVersion {
        public int firstVersion();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface ignored {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface optionalWithDefault {
        public String defaultValue();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface optional {
        public boolean omitNull() default false;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface required {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface defaultForUnknownType {
        public String value();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface union {
        public String typeField();
    }
}

