/*
 * Decompiled with CFR 0.152.
 */
package com.backblaze.b2.client.structures;

import com.backblaze.b2.json.B2Json;
import com.backblaze.b2.util.B2ByteRange;
import java.util.Objects;

public class B2CopyPartRequest {
    @B2Json.required
    private final int partNumber;
    @B2Json.required
    private final String sourceFileId;
    @B2Json.required
    private final String largeFileId;
    @B2Json.optional
    private final String range;

    @B2Json.constructor(params="partNumber, sourceFileId, largeFileId, range")
    private B2CopyPartRequest(int partNumber, String sourceFileId, String largeFileId, String range) {
        this.partNumber = partNumber;
        this.sourceFileId = sourceFileId;
        this.largeFileId = largeFileId;
        this.range = range;
    }

    public static Builder builder(int partNumber, String sourceFileId, String largeFileId) {
        return new Builder(partNumber, sourceFileId, largeFileId);
    }

    public int getPartNumber() {
        return this.partNumber;
    }

    public String getSourceFileId() {
        return this.sourceFileId;
    }

    public String getLargeFileId() {
        return this.largeFileId;
    }

    public String getRange() {
        return this.range;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        B2CopyPartRequest that = (B2CopyPartRequest)o;
        return this.partNumber == that.partNumber && Objects.equals(this.sourceFileId, that.sourceFileId) && Objects.equals(this.largeFileId, that.largeFileId) && Objects.equals(this.range, that.range);
    }

    public int hashCode() {
        return Objects.hash(this.partNumber, this.sourceFileId, this.largeFileId, this.range);
    }

    public static class Builder {
        private final int partNumber;
        private final String sourceFileId;
        private final String largeFileId;
        private B2ByteRange range;

        public Builder(int partNumber, String sourceFileId, String largeFileId) {
            this.partNumber = partNumber;
            this.sourceFileId = sourceFileId;
            this.largeFileId = largeFileId;
        }

        public Builder setRange(B2ByteRange range) {
            this.range = range;
            return this;
        }

        public B2CopyPartRequest build() {
            return new B2CopyPartRequest(this.partNumber, this.sourceFileId, this.largeFileId, this.range == null ? null : this.range.toString());
        }
    }
}

