/*
 * Decompiled with CFR 0.152.
 */
package com.backblaze.b2.util;

import com.backblaze.b2.util.B2StringUtil;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoField;

public class B2DateTimeUtil {
    static final long ONE_MINUTE_IN_SECONDS = 60L;
    static final long ONE_HOUR_IN_SECONDS = 3600L;
    static final long ONE_DAY_IN_SECONDS = 86400L;
    public static final long ONE_SECOND_IN_MILLIS = 1000L;
    static final long ONE_MINUTE_IN_MILLIS = 60000L;
    static final long ONE_HOUR_IN_MILLIS = 3600000L;
    static final long ONE_DAY_IN_MILLIS = 86400000L;
    static final long ONE_SECOND_IN_NANOS = 1000000000L;
    static final long ONE_MILLI_IN_NANOS = 1000000L;
    public static final int MIN_YEAR = 1970;
    public static final int MAX_YEAR = 2999;
    public static final int MIN_MONTH = 1;
    public static final int MAX_MONTH = 12;
    public static final int MIN_DAY = 1;
    public static final int MAX_DAY = 31;
    private static final int MIN_HOUR = 0;
    private static final int MAX_HOUR = 23;
    private static final int MIN_MINUTE = 0;
    private static final int MAX_MINUTE = 59;
    private static final int MIN_SECOND = 0;
    private static final int MAX_SECOND = 59;
    static LocalDateTime EPOCH_TIME = LocalDateTime.of(1970, 1, 1, 0, 0);

    public static String formatSolidDate(LocalDate date) {
        return String.format("%04d%02d%02d", date.getYear(), date.get(ChronoField.MONTH_OF_YEAR), date.getDayOfMonth());
    }

    public static LocalDateTime parseDateTime(String str) {
        try {
            int len = str.length();
            if ((len == 16 || 19 <= len && len <= 29) && B2StringUtil.decimalNumberInRange(str, 0, 4, 1970, 2999) && B2StringUtil.decimalNumberInRange(str, 5, 2, 1, 12) && B2StringUtil.decimalNumberInRange(str, 8, 2, 1, 31) && B2StringUtil.decimalNumberInRange(str, 11, 2, 0, 23) && B2StringUtil.decimalNumberInRange(str, 14, 2, 0, 59) && (len == 16 || B2StringUtil.decimalNumberInRange(str, 17, 2, 0, 59)) && (len <= 19 || str.charAt(19) == '.' && B2StringUtil.allDecimal(str, 20, len))) {
                if (str.charAt(10) == ' ') {
                    str = str.substring(0, 10) + "T" + str.substring(11);
                }
                return LocalDateTime.parse(str);
            }
            if (len == 17 && B2StringUtil.decimalNumberInRange(str, 1, 4, 1970, 2999) && B2StringUtil.decimalNumberInRange(str, 5, 2, 1, 12) && B2StringUtil.decimalNumberInRange(str, 7, 2, 1, 31) && B2StringUtil.decimalNumberInRange(str, 11, 2, 0, 23) && B2StringUtil.decimalNumberInRange(str, 13, 2, 0, 59) && B2StringUtil.decimalNumberInRange(str, 15, 2, 0, 59)) {
                return LocalDateTime.of(B2StringUtil.decimalSubstringToInt(str, 1, 5), B2StringUtil.decimalSubstringToInt(str, 5, 7), B2StringUtil.decimalSubstringToInt(str, 7, 9), B2StringUtil.decimalSubstringToInt(str, 11, 13), B2StringUtil.decimalSubstringToInt(str, 13, 15), B2StringUtil.decimalSubstringToInt(str, 15, 17));
            }
            if (len == 14 && B2StringUtil.decimalNumberInRange(str, 0, 4, 1970, 2999) && B2StringUtil.decimalNumberInRange(str, 4, 2, 1, 12) && B2StringUtil.decimalNumberInRange(str, 6, 2, 1, 31) && B2StringUtil.decimalNumberInRange(str, 8, 2, 0, 23) && B2StringUtil.decimalNumberInRange(str, 10, 2, 0, 59) && B2StringUtil.decimalNumberInRange(str, 12, 2, 0, 59)) {
                return LocalDateTime.of(B2StringUtil.decimalSubstringToInt(str, 0, 4), B2StringUtil.decimalSubstringToInt(str, 4, 6), B2StringUtil.decimalSubstringToInt(str, 6, 8), B2StringUtil.decimalSubstringToInt(str, 8, 10), B2StringUtil.decimalSubstringToInt(str, 10, 12), B2StringUtil.decimalSubstringToInt(str, 12, 14));
            }
        }
        catch (DateTimeParseException e) {
            throw new IllegalArgumentException("bad date time: " + e.getMessage(), e);
        }
        throw new IllegalArgumentException("bad date time: " + str);
    }

    public static String formatFguidDateTime(LocalDateTime dateTime) {
        return String.format("d%04d%02d%02d_m%02d%02d%02d", dateTime.getYear(), dateTime.getMonthValue(), dateTime.getDayOfMonth(), dateTime.getHour(), dateTime.getMinute(), dateTime.getSecond());
    }

    public static Duration parseDuration(String str) {
        try {
            return new DurationParser(str).getDuration();
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public static String durationString(long deltaSecs) {
        boolean wasNegative;
        String s = "";
        boolean bl = wasNegative = deltaSecs < 0L;
        if (wasNegative) {
            deltaSecs = -deltaSecs;
        }
        if (deltaSecs >= 86400L) {
            long nDays = deltaSecs / 86400L;
            s = s + nDays + "d";
            deltaSecs -= nDays * 86400L;
        }
        if (deltaSecs >= 3600L) {
            long nHours = deltaSecs / 3600L;
            s = s + nHours + "h";
            deltaSecs -= nHours * 3600L;
        }
        if (deltaSecs >= 60L) {
            long nMins = deltaSecs / 60L;
            s = s + nMins + "m";
            deltaSecs -= nMins * 60L;
        }
        if (deltaSecs > 0L) {
            s = s + deltaSecs + "s";
        }
        if (s.length() == 0) {
            s = "0s";
        }
        if (wasNegative) {
            s = "-" + s;
        }
        return s;
    }

    static long getMillisecondsSinceEpoch(LocalDateTime dateTime) {
        return Duration.between(EPOCH_TIME, dateTime).toMillis();
    }

    B2DateTimeUtil() {
    }

    private static class DurationParser {
        private long secondsSoFar;
        private int numMatched;

        DurationParser(String str) {
            if (B2StringUtil.isEmpty(str)) {
                throw new IllegalArgumentException();
            }
            boolean wasNegative = str.startsWith("-");
            if (wasNegative) {
                str = str.substring(1);
            }
            str = this.split(str, 'd', 86400L);
            str = this.split(str, 'h', 3600L);
            str = this.split(str, 'm', 60L);
            str = this.split(str, 's', 1L);
            if (this.numMatched == 0) {
                throw new IllegalArgumentException();
            }
            if (str.length() > 0) {
                throw new IllegalArgumentException();
            }
            if (wasNegative) {
                this.secondsSoFar = -this.secondsSoFar;
            }
        }

        private String split(String str, char unitsChar, long numSecondsPerUnit) {
            int iUnitsChar = str.indexOf(unitsChar);
            if (iUnitsChar < 0) {
                return str;
            }
            String numPart = str.substring(0, iUnitsChar);
            long count = Long.parseLong(numPart);
            this.secondsSoFar += count * numSecondsPerUnit;
            ++this.numMatched;
            return str.substring(iUnitsChar + 1);
        }

        Duration getDuration() {
            return Duration.ofSeconds(this.secondsSoFar);
        }
    }
}

