/*
 * Decompiled with CFR 0.152.
 */
package com.backblaze.b2.client.webApiHttpClient;

import com.backblaze.b2.client.exceptions.B2Exception;
import com.backblaze.b2.client.webApiHttpClient.HttpClientFactory;
import com.backblaze.b2.util.B2Preconditions;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.util.VersionInfo;

public class HttpClientFactoryImpl
implements HttpClientFactory {
    private final HttpClientConnectionManager connectionManager;
    private final RequestConfig requestConfig;
    private final IdleConnectionMonitorThread connectionJanitor;
    private static final String APACHE_HTTP_CLIENT_USER_AGENT = VersionInfo.getUserAgent("Apache-HttpClient", "org.apache.http.client", HttpClientBuilder.class);

    private HttpClientFactoryImpl(HttpClientConnectionManager connectionManager, RequestConfig requestConfig) {
        this.connectionManager = connectionManager;
        this.requestConfig = requestConfig;
        this.connectionJanitor = new IdleConnectionMonitorThread(connectionManager);
        this.connectionJanitor.start();
    }

    public static HttpClientFactoryImpl build() {
        return HttpClientFactoryImpl.builder().build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public CloseableHttpClient create() throws B2Exception {
        return HttpClients.custom().setUserAgent(APACHE_HTTP_CLIENT_USER_AGENT).setConnectionManager(this.connectionManager).setDefaultRequestConfig(this.requestConfig).build();
    }

    @Override
    public void close() {
        this.connectionManager.shutdown();
        this.connectionJanitor.shutdown();
        try {
            this.connectionJanitor.join();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    private static class IdleConnectionMonitorThread
    extends Thread {
        private final HttpClientConnectionManager connMgr;
        private volatile boolean shutdown;

        IdleConnectionMonitorThread(HttpClientConnectionManager connMgr) {
            this.connMgr = connMgr;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            try {
                while (!this.shutdown) {
                    IdleConnectionMonitorThread idleConnectionMonitorThread = this;
                    synchronized (idleConnectionMonitorThread) {
                        this.wait(5000L);
                        this.connMgr.closeExpiredConnections();
                        this.connMgr.closeIdleConnections(30L, TimeUnit.SECONDS);
                    }
                }
                return;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void shutdown() {
            this.shutdown = true;
            IdleConnectionMonitorThread idleConnectionMonitorThread = this;
            synchronized (idleConnectionMonitorThread) {
                this.notifyAll();
            }
        }
    }

    public static class Builder {
        private static final int DEFAULT_CONNECTION_REQUEST_TIMEOUT_SECONDS = 5;
        private static final int DEFAULT_CONNECT_TIMEOUT_SECONDS = 5;
        private static final int DEFAULT_SOCKET_TIMEOUT_SECONDS = 20;
        private static final int DEFAULT_MAX_TOTAL_CONNECTIONS_IN_POOL = 100;
        private static final int DEFAULT_MAX_CONNECTIONS_PER_ROUTE = 100;
        private boolean builtOneAlready;
        private boolean supportInsecureHttp;
        private int connectionRequestTimeoutSeconds = 5;
        private int connectTimeoutSeconds = 5;
        private int socketTimeoutSeconds = 20;
        private int maxTotalConnectionsInPool = 100;
        private int maxConnectionsPerRoute = 100;

        public Builder setSupportInsecureHttp(boolean supportInsecureHttp) {
            this.supportInsecureHttp = supportInsecureHttp;
            return this;
        }

        public Builder setConnectionRequestTimeoutSeconds(int connectionRequestTimeoutSeconds) {
            this.connectionRequestTimeoutSeconds = connectionRequestTimeoutSeconds;
            return this;
        }

        public Builder setConnectTimeoutSeconds(int connectTimeoutSeconds) {
            this.connectTimeoutSeconds = connectTimeoutSeconds;
            return this;
        }

        public Builder setSocketTimeoutSeconds(int socketTimeoutSeconds) {
            this.socketTimeoutSeconds = socketTimeoutSeconds;
            return this;
        }

        public Builder setMaxTotalConnectionsInPool(int maxTotalConnectionsInPool) {
            this.maxTotalConnectionsInPool = maxTotalConnectionsInPool;
            return this;
        }

        public Builder setMaxConnectionsPerRoute(int maxConnectionsPerRoute) {
            this.maxConnectionsPerRoute = maxConnectionsPerRoute;
            return this;
        }

        public HttpClientFactoryImpl build() {
            B2Preconditions.checkState(!this.builtOneAlready, "called build() more than once?!");
            this.builtOneAlready = true;
            return new HttpClientFactoryImpl(this.createConnectionManager(), this.createRequestConfig());
        }

        private RequestConfig createRequestConfig() {
            return RequestConfig.custom().setConnectionRequestTimeout(this.connectionRequestTimeoutSeconds * 1000).setConnectTimeout(this.connectTimeoutSeconds * 1000).setSocketTimeout(this.socketTimeoutSeconds * 1000).setNormalizeUri(false).build();
        }

        private HttpClientConnectionManager createConnectionManager() {
            RegistryBuilder<ConnectionSocketFactory> registryBuilder = RegistryBuilder.create();
            SSLContext sslcontext = SSLContexts.createDefault();
            SSLConnectionSocketFactory sslFactory = new SSLConnectionSocketFactory(sslcontext);
            registryBuilder.register("https", sslFactory);
            if (this.supportInsecureHttp) {
                PlainConnectionSocketFactory plainFactory = new PlainConnectionSocketFactory();
                registryBuilder.register("http", plainFactory);
            }
            Registry<ConnectionSocketFactory> registry = registryBuilder.build();
            PoolingHttpClientConnectionManager mgr = new PoolingHttpClientConnectionManager(registry);
            mgr.setMaxTotal(this.maxTotalConnectionsInPool);
            mgr.setDefaultMaxPerRoute(this.maxConnectionsPerRoute);
            return mgr;
        }
    }
}

