/*
 * Decompiled with CFR 0.152.
 */
package com.backblaze.b2.client.structures;

import com.backblaze.b2.client.structures.B2Allowed;
import com.backblaze.b2.json.B2Json;
import java.util.Objects;

public class B2AccountAuthorization {
    @B2Json.required
    private final String accountId;
    @B2Json.required
    private final String authorizationToken;
    @B2Json.required
    private final String apiUrl;
    @B2Json.required
    private final String downloadUrl;
    @B2Json.required
    private final long recommendedPartSize;
    @B2Json.required
    private final long absoluteMinimumPartSize;
    @B2Json.required
    private final B2Allowed allowed;

    @B2Json.constructor(params="accountId,authorizationToken,apiUrl,downloadUrl,recommendedPartSize,absoluteMinimumPartSize,allowed")
    public B2AccountAuthorization(String accountId, String authorizationToken, String apiUrl, String downloadUrl, long recommendedPartSize, long absoluteMinimumPartSize, B2Allowed allowed) {
        this.accountId = accountId;
        this.authorizationToken = authorizationToken;
        this.apiUrl = apiUrl;
        this.downloadUrl = downloadUrl;
        this.recommendedPartSize = recommendedPartSize;
        this.absoluteMinimumPartSize = absoluteMinimumPartSize;
        this.allowed = allowed;
    }

    public String getAccountId() {
        return this.accountId;
    }

    public String getAuthorizationToken() {
        return this.authorizationToken;
    }

    public String getApiUrl() {
        return this.apiUrl;
    }

    public String getDownloadUrl() {
        return this.downloadUrl;
    }

    public long getRecommendedPartSize() {
        return this.recommendedPartSize;
    }

    public long getAbsoluteMinimumPartSize() {
        return this.absoluteMinimumPartSize;
    }

    public B2Allowed getAllowed() {
        return this.allowed;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        B2AccountAuthorization that = (B2AccountAuthorization)o;
        return this.getRecommendedPartSize() == that.getRecommendedPartSize() && this.getAbsoluteMinimumPartSize() == that.getAbsoluteMinimumPartSize() && Objects.equals(this.getAccountId(), that.getAccountId()) && Objects.equals(this.getAuthorizationToken(), that.getAuthorizationToken()) && Objects.equals(this.getApiUrl(), that.getApiUrl()) && Objects.equals(this.getDownloadUrl(), that.getDownloadUrl()) && Objects.equals(this.getAllowed(), that.getAllowed());
    }

    public String toString() {
        return "B2AccountAuthorization{accountId='" + this.accountId + '\'' + ", authorizationToken='" + this.authorizationToken + '\'' + ", apiUrl='" + this.apiUrl + '\'' + ", downloadUrl='" + this.downloadUrl + '\'' + ", recommendedPartSize=" + this.recommendedPartSize + ", absoluteMinimumPartSize=" + this.absoluteMinimumPartSize + ", allowed=" + this.allowed + '}';
    }

    public int hashCode() {
        return Objects.hash(this.getAccountId(), this.getAuthorizationToken(), this.getApiUrl(), this.getDownloadUrl(), this.getRecommendedPartSize(), this.getAbsoluteMinimumPartSize(), this.getAllowed());
    }

    public B2AccountAuthorization withAuthToken(String authToken) {
        return new B2AccountAuthorization(this.getAccountId(), authToken, this.getApiUrl(), this.getDownloadUrl(), this.getRecommendedPartSize(), this.getAbsoluteMinimumPartSize(), this.getAllowed());
    }
}

