/*
 * Decompiled with CFR 0.152.
 */
package Utility.com.parablu;

import com.mongodb.BasicDBObject;
import com.mongodb.DBRef;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientURI;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.lang.StringUtils;
import org.bson.Document;

public class ChunksExport {
    public static void main(String[] args) throws ConfigurationException {
        PropertiesConfiguration config = null;
        config = new PropertiesConfiguration(args[0]);
        String mongoIP = config.getProperty("mongoIP").toString();
        String mongoPort = config.getProperty("mongoPort").toString();
        String deviceUUIDs = config.getProperty("deviceUUIDs").toString();
        boolean oldVersion = Boolean.parseBoolean(config.getProperty("oldVersion").toString());
        if (StringUtils.isEmpty(mongoIP)) {
            System.out.println("mongoIP or port cannot be empty in config file...Please configure and run again :)");
            throw new ArrayIndexOutOfBoundsException();
        }
        System.out.println("mongo IP:" + mongoIP);
        MongoClientURI uri = new MongoClientURI("mongodb://neil:parablu@" + mongoIP + ":" + mongoPort + "/parablu001");
        MongoClient client = new MongoClient(uri);
        MongoDatabase db = client.getDatabase(uri.getDatabase());
        MongoCollection<Document> deviceColl = db.getCollection("DEVICE");
        MongoCollection<Document> userDBCollection = db.getCollection("USER");
        ArrayList<String> deviceUUIDList = new ArrayList<String>();
        deviceUUIDList.addAll(Arrays.asList(deviceUUIDs.split(",")));
        System.out.println(deviceUUIDs);
        String mongoHost = String.valueOf(mongoIP) + ":" + mongoPort;
        for (String deviceUUID : deviceUUIDList) {
            deviceUUID = deviceUUID.replace("[", "");
            deviceUUID = deviceUUID.replace("]", "");
            System.out.println(deviceUUID);
            BasicDBObject andQuery = new BasicDBObject();
            ArrayList<BasicDBObject> whereQuery = new ArrayList<BasicDBObject>();
            whereQuery.add(new BasicDBObject("deviceUUID", deviceUUID));
            andQuery.put("$and", whereQuery);
            Document device = (Document)deviceColl.find(andQuery).first();
            Document userDBObject = null;
            if (oldVersion) {
                DBRef useRef = (DBRef)device.get("user");
                userDBObject = (Document)userDBCollection.find(new Document("_id", useRef.getId())).first();
            } else {
                userDBObject = (Document)userDBCollection.find(new Document("userName", device.getString("userName"))).first();
            }
            String userName = userDBObject.getString("userName");
            userName = userName.replaceAll("[^A-Za-z0-9,]", "_");
            userName = userName.replaceAll(" ", "_");
            System.out.println("mongoexport -h  " + mongoHost + " -u \"neil\" -p \"parablu\" --db parablu001 --collection CHUNK_DETAIL -q '{\"userName\":{\"$regex\" : \"^" + userName + "$\", \"$options\" : \"i\"}}' --out " + userName + "_Chunk_DETAIL.csv");
            System.out.println("mongoimport -h  " + mongoHost + " -u \"neil\" -p \"parablu\" --db parablu001 --collection " + userName.toUpperCase() + "_CHUNKS  --file " + userName + "_Chunk_DETAIL.csv");
            int i = 0;
            while (i <= 101) {
                System.out.println("mongoexport -h  " + mongoHost + " -u \"neil\" -p \"parablu\" --db parablu001 --collection CHUNK_DETAIL_" + i + " -q '{\"userName\":{\"$regex\" : \"^" + userName + "$\", \"$options\" : \"i\"}}' --out " + userName + "_Chunk_DETAIL_" + i + ".csv");
                System.out.println("mongoimport -h  " + mongoHost + " -u \"neil\" -p \"parablu\" --db parablu001 --collection " + userName.toUpperCase() + "_CHUNKS  --file " + userName + "_Chunk_DETAIL_" + i + ".csv");
                ++i;
            }
        }
    }
}

