/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.aad.adal4j;

import com.microsoft.aad.adal4j.AuthenticationCallback;
import com.microsoft.aad.adal4j.AuthenticationContext;
import com.microsoft.aad.adal4j.ClientDataHttpHeaders;
import com.microsoft.aad.adal4j.LogHelper;
import java.util.concurrent.Callable;

abstract class AdalCallable<T>
implements Callable<T> {
    AuthenticationContext context;
    ClientDataHttpHeaders headers;
    AuthenticationCallback<T> callback;

    AdalCallable(AuthenticationContext context, AuthenticationCallback<T> callback) {
        this.context = context;
        this.callback = callback;
    }

    abstract T execute() throws Exception;

    void logResult(T result, ClientDataHttpHeaders headers) throws Exception {
    }

    @Override
    public T call() throws Exception {
        Object result = null;
        try {
            result = this.execute();
            this.logResult(result, this.headers);
            if (this.callback != null) {
                this.callback.onSuccess(result);
            }
        }
        catch (Exception ex) {
            this.context.log.error(LogHelper.createMessage("Execution of " + this.getClass() + " failed.", this.headers.getHeaderCorrelationIdValue()), ex);
            if (this.callback != null) {
                this.callback.onFailure(ex);
            }
            throw ex;
        }
        return result;
    }
}

