/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.support;

import java.io.NotSerializableException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Provider;
import org.springframework.beans.BeansException;
import org.springframework.beans.FatalBeanException;
import org.springframework.beans.TypeConverter;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.BeanCurrentlyInCreationException;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.CannotLoadBeanClassException;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.beans.factory.SmartFactoryBean;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.DependencyDescriptor;
import org.springframework.beans.factory.support.AbstractAutowireCapableBeanFactory;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.AutowireCandidateResolver;
import org.springframework.beans.factory.support.AutowireUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionValidationException;
import org.springframework.beans.factory.support.ConstructorResolver;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.support.SimpleAutowireCandidateResolver;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultListableBeanFactory
extends AbstractAutowireCapableBeanFactory
implements ConfigurableListableBeanFactory,
BeanDefinitionRegistry,
Serializable {
    private static Class javaxInjectProviderClass = null;
    private static final Map<String, Reference<DefaultListableBeanFactory>> serializableFactories;
    private String serializationId;
    private boolean allowBeanDefinitionOverriding = true;
    private boolean allowEagerClassLoading = true;
    private AutowireCandidateResolver autowireCandidateResolver = new SimpleAutowireCandidateResolver();
    private final Map<Class, Object> resolvableDependencies = new HashMap<Class, Object>();
    private final Map<String, BeanDefinition> beanDefinitionMap = new ConcurrentHashMap<String, BeanDefinition>();
    private final List<String> beanDefinitionNames = new ArrayList<String>();
    private boolean configurationFrozen = false;
    private String[] frozenBeanDefinitionNames;

    static {
        ClassLoader cl = DefaultListableBeanFactory.class.getClassLoader();
        try {
            javaxInjectProviderClass = cl.loadClass("javax.inject.Provider");
        }
        catch (ClassNotFoundException classNotFoundException) {}
        serializableFactories = new ConcurrentHashMap<String, Reference<DefaultListableBeanFactory>>();
    }

    public DefaultListableBeanFactory() {
    }

    public DefaultListableBeanFactory(BeanFactory parentBeanFactory) {
        super(parentBeanFactory);
    }

    public void setSerializationId(String serializationId) {
        if (serializationId != null) {
            serializableFactories.put(serializationId, new WeakReference<DefaultListableBeanFactory>(this));
        } else if (this.serializationId != null) {
            serializableFactories.remove(this.serializationId);
        }
        this.serializationId = serializationId;
    }

    public void setAllowBeanDefinitionOverriding(boolean allowBeanDefinitionOverriding) {
        this.allowBeanDefinitionOverriding = allowBeanDefinitionOverriding;
    }

    public void setAllowEagerClassLoading(boolean allowEagerClassLoading) {
        this.allowEagerClassLoading = allowEagerClassLoading;
    }

    public void setAutowireCandidateResolver(final AutowireCandidateResolver autowireCandidateResolver) {
        Assert.notNull(autowireCandidateResolver, "AutowireCandidateResolver must not be null");
        if (autowireCandidateResolver instanceof BeanFactoryAware) {
            if (System.getSecurityManager() != null) {
                final DefaultListableBeanFactory target = this;
                AccessController.doPrivileged(new PrivilegedAction<Object>(){

                    @Override
                    public Object run() {
                        ((BeanFactoryAware)((Object)autowireCandidateResolver)).setBeanFactory(target);
                        return null;
                    }
                }, this.getAccessControlContext());
            } else {
                ((BeanFactoryAware)((Object)autowireCandidateResolver)).setBeanFactory(this);
            }
        }
        this.autowireCandidateResolver = autowireCandidateResolver;
    }

    public AutowireCandidateResolver getAutowireCandidateResolver() {
        return this.autowireCandidateResolver;
    }

    @Override
    public void copyConfigurationFrom(ConfigurableBeanFactory otherFactory) {
        super.copyConfigurationFrom(otherFactory);
        if (otherFactory instanceof DefaultListableBeanFactory) {
            DefaultListableBeanFactory otherListableFactory = (DefaultListableBeanFactory)otherFactory;
            this.allowBeanDefinitionOverriding = otherListableFactory.allowBeanDefinitionOverriding;
            this.allowEagerClassLoading = otherListableFactory.allowEagerClassLoading;
            this.autowireCandidateResolver = otherListableFactory.autowireCandidateResolver;
            this.resolvableDependencies.putAll(otherListableFactory.resolvableDependencies);
        }
    }

    @Override
    public <T> T getBean(Class<T> requiredType) throws BeansException {
        Assert.notNull(requiredType, "Required type must not be null");
        Object[] beanNames = this.getBeanNamesForType(requiredType);
        if (beanNames.length == 1) {
            return this.getBean(beanNames[0], requiredType);
        }
        if (beanNames.length == 0 && this.getParentBeanFactory() != null) {
            return this.getParentBeanFactory().getBean(requiredType);
        }
        throw new NoSuchBeanDefinitionException(requiredType, "expected single bean but found " + beanNames.length + ": " + StringUtils.arrayToCommaDelimitedString(beanNames));
    }

    @Override
    public boolean containsBeanDefinition(String beanName) {
        Assert.notNull(beanName, "Bean name must not be null");
        return this.beanDefinitionMap.containsKey(beanName);
    }

    @Override
    public int getBeanDefinitionCount() {
        return this.beanDefinitionMap.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getBeanDefinitionNames() {
        Map<String, BeanDefinition> map = this.beanDefinitionMap;
        synchronized (map) {
            if (this.frozenBeanDefinitionNames != null) {
                return this.frozenBeanDefinitionNames;
            }
            return StringUtils.toStringArray(this.beanDefinitionNames);
        }
    }

    @Override
    public String[] getBeanNamesForType(Class type) {
        return this.getBeanNamesForType(type, true, true);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public String[] getBeanNamesForType(Class type, boolean includeNonSingletons, boolean allowEagerInit) {
        result = new ArrayList<String>();
        var9_6 = beanDefinitionNames = this.getBeanDefinitionNames();
        var8_8 = beanDefinitionNames.length;
        var7_9 = 0;
        while (var7_9 < var8_8) {
            beanName = var9_6[var7_9];
            if (!this.isAlias(beanName)) {
                try {
                    mbd = this.getMergedLocalBeanDefinition(beanName);
                    if (!mbd.isAbstract() && (allowEagerInit || (mbd.hasBeanClass() || !mbd.isLazyInit() || this.allowEagerClassLoading) && !this.requiresEagerInitForType(mbd.getFactoryBeanName()))) {
                        isFactoryBean = this.isFactoryBean(beanName, mbd);
                        v0 = matchFound = !(allowEagerInit == false && isFactoryBean != false && this.containsSingleton(beanName) == false || includeNonSingletons == false && this.isSingleton(beanName) == false || this.isTypeMatch(beanName, type) == false);
                        if (!matchFound && isFactoryBean) {
                            beanName = "&" + beanName;
                            v1 = matchFound = (includeNonSingletons != false || mbd.isSingleton() != false) && this.isTypeMatch(beanName, type) != false;
                        }
                        if (matchFound) {
                            result.add(beanName);
                        }
                    }
                }
                catch (CannotLoadBeanClassException ex) {
                    if (allowEagerInit) {
                        throw ex;
                    }
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("Ignoring bean class loading failure for bean '" + beanName + "'", ex);
                    }
                    this.onSuppressedException(ex);
                }
                catch (BeanDefinitionStoreException ex) {
                    if (allowEagerInit) {
                        throw ex;
                    }
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("Ignoring unresolvable metadata in bean definition '" + beanName + "'", ex);
                    }
                    this.onSuppressedException(ex);
                }
            }
            ++var7_9;
        }
        var10_12 = singletonNames = this.getSingletonNames();
        var9_7 = singletonNames.length;
        var8_8 = 0;
        while (var8_8 < var9_7) {
            block16: {
                beanName = var10_12[var8_8];
                if (this.containsBeanDefinition(beanName)) break block16;
                if (!this.isFactoryBean(beanName)) ** GOTO lbl47
                if ((includeNonSingletons || this.isSingleton(beanName)) && this.isTypeMatch(beanName, type)) {
                    result.add(beanName);
                } else {
                    beanName = "&" + beanName;
lbl47:
                    // 2 sources

                    if (this.isTypeMatch(beanName, type)) {
                        result.add(beanName);
                    }
                }
            }
            ++var8_8;
        }
        return StringUtils.toStringArray(result);
    }

    private boolean requiresEagerInitForType(String factoryBeanName) {
        return factoryBeanName != null && this.isFactoryBean(factoryBeanName) && !this.containsSingleton(factoryBeanName);
    }

    @Override
    public <T> Map<String, T> getBeansOfType(Class<T> type) throws BeansException {
        return this.getBeansOfType(type, true, true);
    }

    @Override
    public <T> Map<String, T> getBeansOfType(Class<T> type, boolean includeNonSingletons, boolean allowEagerInit) throws BeansException {
        String[] beanNames = this.getBeanNamesForType(type, includeNonSingletons, allowEagerInit);
        LinkedHashMap<String, T> result = new LinkedHashMap<String, T>(beanNames.length);
        String[] stringArray = beanNames;
        int n = beanNames.length;
        int n2 = 0;
        while (n2 < n) {
            String beanName = stringArray[n2];
            try {
                result.put(beanName, this.getBean(beanName, type));
            }
            catch (BeanCreationException ex) {
                BeanCreationException bce;
                Throwable rootCause = ex.getMostSpecificCause();
                if (rootCause instanceof BeanCurrentlyInCreationException && this.isCurrentlyInCreation((bce = (BeanCreationException)rootCause).getBeanName())) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("Ignoring match to currently created bean '" + beanName + "': " + ex.getMessage());
                    }
                    this.onSuppressedException(ex);
                }
                throw ex;
            }
            ++n2;
        }
        return result;
    }

    @Override
    public Map<String, Object> getBeansWithAnnotation(Class<? extends Annotation> annotationType) {
        LinkedHashSet beanNames = new LinkedHashSet(this.getBeanDefinitionCount());
        beanNames.addAll(Arrays.asList(this.getBeanDefinitionNames()));
        beanNames.addAll(Arrays.asList(this.getSingletonNames()));
        LinkedHashMap<String, Object> results = new LinkedHashMap<String, Object>();
        for (String beanName : beanNames) {
            if (this.findAnnotationOnBean(beanName, annotationType) == null) continue;
            results.put(beanName, this.getBean(beanName));
        }
        return results;
    }

    @Override
    public <A extends Annotation> A findAnnotationOnBean(String beanName, Class<A> annotationType) {
        AbstractBeanDefinition abd;
        BeanDefinition bd;
        A ann = null;
        Class<?> beanType = this.getType(beanName);
        if (beanType != null) {
            ann = AnnotationUtils.findAnnotation(beanType, annotationType);
        }
        if (ann == null && this.containsBeanDefinition(beanName) && (bd = this.getMergedBeanDefinition(beanName)) instanceof AbstractBeanDefinition && (abd = (AbstractBeanDefinition)bd).hasBeanClass()) {
            ann = AnnotationUtils.findAnnotation(abd.getBeanClass(), annotationType);
        }
        return ann;
    }

    @Override
    public void registerResolvableDependency(Class dependencyType, Object autowiredValue) {
        Assert.notNull(dependencyType, "Type must not be null");
        if (autowiredValue != null) {
            Assert.isTrue(autowiredValue instanceof ObjectFactory || dependencyType.isInstance(autowiredValue), "Value [" + autowiredValue + "] does not implement specified type [" + dependencyType.getName() + "]");
            this.resolvableDependencies.put(dependencyType, autowiredValue);
        }
    }

    @Override
    public boolean isAutowireCandidate(String beanName, DependencyDescriptor descriptor) throws NoSuchBeanDefinitionException {
        boolean isFactoryBean;
        boolean bl = isFactoryBean = descriptor != null && descriptor.getDependencyType() != null && FactoryBean.class.isAssignableFrom(descriptor.getDependencyType());
        if (isFactoryBean) {
            beanName = BeanFactoryUtils.transformedBeanName(beanName);
        }
        if (this.containsBeanDefinition(beanName)) {
            return this.isAutowireCandidate(beanName, this.getMergedLocalBeanDefinition(beanName), descriptor);
        }
        if (this.containsSingleton(beanName)) {
            return this.isAutowireCandidate(beanName, new RootBeanDefinition(this.getType(beanName)), descriptor);
        }
        if (this.getParentBeanFactory() instanceof ConfigurableListableBeanFactory) {
            return ((ConfigurableListableBeanFactory)this.getParentBeanFactory()).isAutowireCandidate(beanName, descriptor);
        }
        return true;
    }

    protected boolean isAutowireCandidate(String beanName, RootBeanDefinition mbd, DependencyDescriptor descriptor) {
        this.resolveBeanClass(mbd, beanName, new Class[0]);
        if (mbd.isFactoryMethodUnique && mbd.resolvedConstructorOrFactoryMethod == null) {
            new ConstructorResolver(this).resolveFactoryMethodIfPossible(mbd);
        }
        return this.getAutowireCandidateResolver().isAutowireCandidate(new BeanDefinitionHolder(mbd, beanName, this.getAliases(beanName)), descriptor);
    }

    @Override
    public BeanDefinition getBeanDefinition(String beanName) throws NoSuchBeanDefinitionException {
        BeanDefinition bd = this.beanDefinitionMap.get(beanName);
        if (bd == null) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("No bean named '" + beanName + "' found in " + this);
            }
            throw new NoSuchBeanDefinitionException(beanName);
        }
        return bd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void freezeConfiguration() {
        this.configurationFrozen = true;
        Map<String, BeanDefinition> map = this.beanDefinitionMap;
        synchronized (map) {
            this.frozenBeanDefinitionNames = StringUtils.toStringArray(this.beanDefinitionNames);
        }
    }

    @Override
    public boolean isConfigurationFrozen() {
        return this.configurationFrozen;
    }

    @Override
    protected boolean isBeanEligibleForMetadataCaching(String beanName) {
        return this.configurationFrozen || super.isBeanEligibleForMetadataCaching(beanName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void preInstantiateSingletons() throws BeansException {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Pre-instantiating singletons in " + this);
        }
        Map<String, BeanDefinition> map = this.beanDefinitionMap;
        synchronized (map) {
            for (String beanName : this.beanDefinitionNames) {
                RootBeanDefinition bd = this.getMergedLocalBeanDefinition(beanName);
                if (bd.isAbstract() || !bd.isSingleton() || bd.isLazyInit()) continue;
                if (this.isFactoryBean(beanName)) {
                    boolean isEagerInit;
                    final FactoryBean factory = (FactoryBean)this.getBean("&" + beanName);
                    if (System.getSecurityManager() != null && factory instanceof SmartFactoryBean) {
                        isEagerInit = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

                            @Override
                            public Boolean run() {
                                return ((SmartFactoryBean)factory).isEagerInit();
                            }
                        }, this.getAccessControlContext());
                    } else {
                        boolean bl = isEagerInit = factory instanceof SmartFactoryBean && ((SmartFactoryBean)factory).isEagerInit();
                    }
                    if (!isEagerInit) continue;
                    this.getBean(beanName);
                    continue;
                }
                this.getBean(beanName);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerBeanDefinition(String beanName, BeanDefinition beanDefinition) throws BeanDefinitionStoreException {
        Assert.hasText(beanName, "Bean name must not be empty");
        Assert.notNull(beanDefinition, "BeanDefinition must not be null");
        if (beanDefinition instanceof AbstractBeanDefinition) {
            try {
                ((AbstractBeanDefinition)beanDefinition).validate();
            }
            catch (BeanDefinitionValidationException ex) {
                throw new BeanDefinitionStoreException(beanDefinition.getResourceDescription(), beanName, "Validation of bean definition failed", ex);
            }
        }
        Map<String, BeanDefinition> map = this.beanDefinitionMap;
        synchronized (map) {
            BeanDefinition oldBeanDefinition = this.beanDefinitionMap.get(beanName);
            if (oldBeanDefinition != null) {
                if (!this.allowBeanDefinitionOverriding) {
                    throw new BeanDefinitionStoreException(beanDefinition.getResourceDescription(), beanName, "Cannot register bean definition [" + beanDefinition + "] for bean '" + beanName + "': There is already [" + oldBeanDefinition + "] bound.");
                }
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("Overriding bean definition for bean '" + beanName + "': replacing [" + oldBeanDefinition + "] with [" + beanDefinition + "]");
                }
            } else {
                this.beanDefinitionNames.add(beanName);
                this.frozenBeanDefinitionNames = null;
            }
            this.beanDefinitionMap.put(beanName, beanDefinition);
            this.resetBeanDefinition(beanName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeBeanDefinition(String beanName) throws NoSuchBeanDefinitionException {
        Assert.hasText(beanName, "'beanName' must not be empty");
        Map<String, BeanDefinition> map = this.beanDefinitionMap;
        synchronized (map) {
            BeanDefinition bd = this.beanDefinitionMap.remove(beanName);
            if (bd == null) {
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace("No bean named '" + beanName + "' found in " + this);
                }
                throw new NoSuchBeanDefinitionException(beanName);
            }
            this.beanDefinitionNames.remove(beanName);
            this.frozenBeanDefinitionNames = null;
            this.resetBeanDefinition(beanName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void resetBeanDefinition(String beanName) {
        this.clearMergedBeanDefinition(beanName);
        Object object = this.getSingletonMutex();
        synchronized (object) {
            this.destroySingleton(beanName);
        }
        for (String bdName : this.beanDefinitionNames) {
            BeanDefinition bd;
            if (beanName.equals(bdName) || !beanName.equals((bd = this.beanDefinitionMap.get(bdName)).getParentName())) continue;
            this.resetBeanDefinition(bdName);
        }
    }

    @Override
    protected boolean allowAliasOverriding() {
        return this.allowBeanDefinitionOverriding;
    }

    @Override
    public Object resolveDependency(DependencyDescriptor descriptor, String beanName, Set<String> autowiredBeanNames, TypeConverter typeConverter) throws BeansException {
        descriptor.initParameterNameDiscovery(this.getParameterNameDiscoverer());
        if (descriptor.getDependencyType().equals(ObjectFactory.class)) {
            return new DependencyObjectFactory(descriptor, beanName);
        }
        if (descriptor.getDependencyType().equals(javaxInjectProviderClass)) {
            return new DependencyProviderFactory().createDependencyProvider(descriptor, beanName);
        }
        return this.doResolveDependency(descriptor, descriptor.getDependencyType(), beanName, autowiredBeanNames, typeConverter);
    }

    protected Object doResolveDependency(DependencyDescriptor descriptor, Class<?> type, String beanName, Set<String> autowiredBeanNames, TypeConverter typeConverter) throws BeansException {
        Object value = this.getAutowireCandidateResolver().getSuggestedValue(descriptor);
        if (value != null) {
            if (value instanceof String) {
                String strVal = this.resolveEmbeddedValue((String)value);
                BeanDefinition bd = this.containsBean(beanName) ? this.getMergedBeanDefinition(beanName) : null;
                value = this.evaluateBeanDefinitionString(strVal, bd);
            }
            TypeConverter converter = typeConverter != null ? typeConverter : this.getTypeConverter();
            return converter.convertIfNecessary(value, type);
        }
        if (type.isArray()) {
            Class<?> componentType = type.getComponentType();
            Map<String, Object> matchingBeans = this.findAutowireCandidates(beanName, componentType, descriptor);
            if (matchingBeans.isEmpty()) {
                if (descriptor.isRequired()) {
                    this.raiseNoSuchBeanDefinitionException(componentType, "array of " + componentType.getName(), descriptor);
                }
                return null;
            }
            if (autowiredBeanNames != null) {
                autowiredBeanNames.addAll((Collection<String>)matchingBeans.keySet());
            }
            TypeConverter converter = typeConverter != null ? typeConverter : this.getTypeConverter();
            return converter.convertIfNecessary(matchingBeans.values(), type);
        }
        if (Collection.class.isAssignableFrom(type) && type.isInterface()) {
            Class<?> elementType = descriptor.getCollectionType();
            if (elementType == null) {
                if (descriptor.isRequired()) {
                    throw new FatalBeanException("No element type declared for collection [" + type.getName() + "]");
                }
                return null;
            }
            Map<String, Object> matchingBeans = this.findAutowireCandidates(beanName, elementType, descriptor);
            if (matchingBeans.isEmpty()) {
                if (descriptor.isRequired()) {
                    this.raiseNoSuchBeanDefinitionException(elementType, "collection of " + elementType.getName(), descriptor);
                }
                return null;
            }
            if (autowiredBeanNames != null) {
                autowiredBeanNames.addAll((Collection<String>)matchingBeans.keySet());
            }
            TypeConverter converter = typeConverter != null ? typeConverter : this.getTypeConverter();
            return converter.convertIfNecessary(matchingBeans.values(), type);
        }
        if (Map.class.isAssignableFrom(type) && type.isInterface()) {
            Class<?> keyType = descriptor.getMapKeyType();
            if (keyType == null || !String.class.isAssignableFrom(keyType)) {
                if (descriptor.isRequired()) {
                    throw new FatalBeanException("Key type [" + keyType + "] of map [" + type.getName() + "] must be assignable to [java.lang.String]");
                }
                return null;
            }
            Class<?> valueType = descriptor.getMapValueType();
            if (valueType == null) {
                if (descriptor.isRequired()) {
                    throw new FatalBeanException("No value type declared for map [" + type.getName() + "]");
                }
                return null;
            }
            Map<String, Object> matchingBeans = this.findAutowireCandidates(beanName, valueType, descriptor);
            if (matchingBeans.isEmpty()) {
                if (descriptor.isRequired()) {
                    this.raiseNoSuchBeanDefinitionException(valueType, "map with value type " + valueType.getName(), descriptor);
                }
                return null;
            }
            if (autowiredBeanNames != null) {
                autowiredBeanNames.addAll((Collection<String>)matchingBeans.keySet());
            }
            return matchingBeans;
        }
        Map<String, Object> matchingBeans = this.findAutowireCandidates(beanName, type, descriptor);
        if (matchingBeans.isEmpty()) {
            if (descriptor.isRequired()) {
                this.raiseNoSuchBeanDefinitionException(type, "", descriptor);
            }
            return null;
        }
        if (matchingBeans.size() > 1) {
            String primaryBeanName = this.determinePrimaryCandidate(matchingBeans, descriptor);
            if (primaryBeanName == null) {
                throw new NoSuchBeanDefinitionException(type, "expected single matching bean but found " + matchingBeans.size() + ": " + matchingBeans.keySet());
            }
            if (autowiredBeanNames != null) {
                autowiredBeanNames.add(primaryBeanName);
            }
            return matchingBeans.get(primaryBeanName);
        }
        Map.Entry<String, Object> entry = matchingBeans.entrySet().iterator().next();
        if (autowiredBeanNames != null) {
            autowiredBeanNames.add(entry.getKey());
        }
        return entry.getValue();
    }

    protected Map<String, Object> findAutowireCandidates(String beanName, Class requiredType, DependencyDescriptor descriptor) {
        String[] candidateNames = BeanFactoryUtils.beanNamesForTypeIncludingAncestors(this, requiredType, true, descriptor.isEager());
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>(candidateNames.length);
        for (Class autowiringType : this.resolvableDependencies.keySet()) {
            if (!autowiringType.isAssignableFrom(requiredType)) continue;
            Object autowiringValue = this.resolvableDependencies.get(autowiringType);
            if (!requiredType.isInstance(autowiringValue = AutowireUtils.resolveAutowiringValue(autowiringValue, requiredType))) continue;
            result.put(ObjectUtils.identityToString(autowiringValue), autowiringValue);
            break;
        }
        String[] stringArray = candidateNames;
        int n = candidateNames.length;
        int n2 = 0;
        while (n2 < n) {
            String candidateName = stringArray[n2];
            if (!candidateName.equals(beanName) && this.isAutowireCandidate(candidateName, descriptor)) {
                result.put(candidateName, this.getBean(candidateName));
            }
            ++n2;
        }
        return result;
    }

    protected String determinePrimaryCandidate(Map<String, Object> candidateBeans, DependencyDescriptor descriptor) {
        String primaryBeanName = null;
        String fallbackBeanName = null;
        for (Map.Entry<String, Object> entry : candidateBeans.entrySet()) {
            Object beanInstance;
            String candidateBeanName = entry.getKey();
            if (this.isPrimary(candidateBeanName, beanInstance = entry.getValue())) {
                if (primaryBeanName != null) {
                    boolean primaryLocal;
                    boolean candidateLocal = this.containsBeanDefinition(candidateBeanName);
                    if (candidateLocal == (primaryLocal = this.containsBeanDefinition(primaryBeanName))) {
                        throw new NoSuchBeanDefinitionException(descriptor.getDependencyType(), "more than one 'primary' bean found among candidates: " + candidateBeans.keySet());
                    }
                    if (candidateLocal && !primaryLocal) {
                        primaryBeanName = candidateBeanName;
                    }
                } else {
                    primaryBeanName = candidateBeanName;
                }
            }
            if (primaryBeanName != null || !this.resolvableDependencies.values().contains(beanInstance) && !this.matchesBeanName(candidateBeanName, descriptor.getDependencyName())) continue;
            fallbackBeanName = candidateBeanName;
        }
        return primaryBeanName != null ? primaryBeanName : fallbackBeanName;
    }

    protected boolean isPrimary(String beanName, Object beanInstance) {
        if (this.containsBeanDefinition(beanName)) {
            return this.getMergedLocalBeanDefinition(beanName).isPrimary();
        }
        BeanFactory parentFactory = this.getParentBeanFactory();
        return parentFactory instanceof DefaultListableBeanFactory && ((DefaultListableBeanFactory)parentFactory).isPrimary(beanName, beanInstance);
    }

    protected boolean matchesBeanName(String beanName, String candidateName) {
        return candidateName != null && (candidateName.equals(beanName) || ObjectUtils.containsElement(this.getAliases(beanName), candidateName));
    }

    private void raiseNoSuchBeanDefinitionException(Class type, String dependencyDescription, DependencyDescriptor descriptor) throws NoSuchBeanDefinitionException {
        throw new NoSuchBeanDefinitionException(type, dependencyDescription, "expected at least 1 bean which qualifies as autowire candidate for this dependency. Dependency annotations: " + ObjectUtils.nullSafeToString(descriptor.getAnnotations()));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(ObjectUtils.identityToString(this));
        sb.append(": defining beans [");
        sb.append(StringUtils.arrayToCommaDelimitedString(this.getBeanDefinitionNames()));
        sb.append("]; ");
        BeanFactory parent = this.getParentBeanFactory();
        if (parent == null) {
            sb.append("root of factory hierarchy");
        } else {
            sb.append("parent: ").append(ObjectUtils.identityToString(parent));
        }
        return sb.toString();
    }

    protected Object writeReplace() throws ObjectStreamException {
        if (this.serializationId != null) {
            return new SerializedBeanFactoryReference(this.serializationId);
        }
        throw new NotSerializableException("DefaultListableBeanFactory has no serialization id");
    }

    private class DependencyObjectFactory
    implements ObjectFactory,
    Serializable {
        private final DependencyDescriptor descriptor;
        private final String beanName;
        private final Class type;

        public DependencyObjectFactory(DependencyDescriptor descriptor, String beanName) {
            this.descriptor = descriptor;
            this.beanName = beanName;
            this.type = this.determineObjectFactoryType();
        }

        private Class determineObjectFactoryType() {
            Type arg;
            Type type = this.descriptor.getGenericDependencyType();
            if (type instanceof ParameterizedType && (arg = ((ParameterizedType)type).getActualTypeArguments()[0]) instanceof Class) {
                return (Class)arg;
            }
            return Object.class;
        }

        public Object getObject() throws BeansException {
            return DefaultListableBeanFactory.this.doResolveDependency(this.descriptor, this.type, this.beanName, null, null);
        }
    }

    private class DependencyProvider
    extends DependencyObjectFactory
    implements Provider {
        public DependencyProvider(DependencyDescriptor descriptor, String beanName) {
            super(descriptor, beanName);
        }

        public Object get() throws BeansException {
            return this.getObject();
        }
    }

    private class DependencyProviderFactory {
        private DependencyProviderFactory() {
        }

        public Object createDependencyProvider(DependencyDescriptor descriptor, String beanName) {
            return new DependencyProvider(descriptor, beanName);
        }
    }

    private static class SerializedBeanFactoryReference
    implements Serializable {
        private final String id;

        public SerializedBeanFactoryReference(String id) {
            this.id = id;
        }

        private Object readResolve() {
            Reference ref = (Reference)serializableFactories.get(this.id);
            if (ref == null) {
                throw new IllegalStateException("Cannot deserialize BeanFactory with id " + this.id + ": no factory registered for this id");
            }
            Object result = ref.get();
            if (result == null) {
                throw new IllegalStateException("Cannot deserialize BeanFactory with id " + this.id + ": factory has been garbage-collected");
            }
            return result;
        }
    }
}

