/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.sts.domain;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import org.jclouds.aws.domain.SessionCredentials;
import org.jclouds.sts.domain.User;

public final class UserAndSessionCredentials {
    private final User user;
    private final SessionCredentials credentials;
    private final int packedPolicySize;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return UserAndSessionCredentials.builder().from(this);
    }

    private UserAndSessionCredentials(User user, SessionCredentials credentials, int packedPolicySize) {
        this.user = Preconditions.checkNotNull(user, "user");
        this.credentials = Preconditions.checkNotNull(credentials, "credentials for %s", user);
        this.packedPolicySize = packedPolicySize;
    }

    public User getUser() {
        return this.user;
    }

    public SessionCredentials getCredentials() {
        return this.credentials;
    }

    public int getPackedPolicySize() {
        return this.packedPolicySize;
    }

    public int hashCode() {
        return Objects.hashCode(this.user, this.credentials, this.packedPolicySize);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UserAndSessionCredentials other = (UserAndSessionCredentials)obj;
        return Objects.equal(this.user, other.user) && Objects.equal(this.credentials, other.credentials) && Objects.equal(this.packedPolicySize, other.packedPolicySize);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("user", this.user).add("credentials", this.credentials).add("packedPolicySize", this.packedPolicySize).toString();
    }

    public static final class Builder {
        private User user;
        private SessionCredentials credentials;
        private int packedPolicySize;

        public Builder user(User user) {
            this.user = user;
            return this;
        }

        public Builder credentials(SessionCredentials credentials) {
            this.credentials = credentials;
            return this;
        }

        public Builder packedPolicySize(int packedPolicySize) {
            this.packedPolicySize = packedPolicySize;
            return this;
        }

        public UserAndSessionCredentials build() {
            return new UserAndSessionCredentials(this.user, this.credentials, this.packedPolicySize);
        }

        public Builder from(UserAndSessionCredentials in) {
            return this.user(in.user).credentials(in.credentials).packedPolicySize(in.packedPolicySize);
        }
    }
}

