/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.softlayer.domain;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.Set;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.softlayer.domain.Password;
import org.jclouds.softlayer.domain.SoftwareLicense;

public class OperatingSystem {
    private final String id;
    private final SoftwareLicense softwareLicense;
    private final String operatingSystemReferenceCode;
    private final Set<Password> passwords;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return OperatingSystem.builder().fromOperatingSystem(this);
    }

    @ConstructorProperties(value={"id", "softwareLicense", "operatingSystemReferenceCode", "passwords"})
    protected OperatingSystem(String id, @Nullable SoftwareLicense softwareLicense, @Nullable String operatingSystemReferenceCode, @Nullable Set<Password> passwords) {
        this.id = Preconditions.checkNotNull(id, "id");
        this.softwareLicense = softwareLicense;
        this.operatingSystemReferenceCode = operatingSystemReferenceCode;
        this.passwords = passwords == null ? ImmutableSet.of() : ImmutableSet.copyOf(passwords);
    }

    public String getId() {
        return this.id;
    }

    public SoftwareLicense getSoftwareLicense() {
        return this.softwareLicense;
    }

    public String getOperatingSystemReferenceCode() {
        return this.operatingSystemReferenceCode;
    }

    public Set<Password> getPasswords() {
        return this.passwords;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OperatingSystem that = (OperatingSystem)o;
        return Objects.equal(this.id, that.id) && Objects.equal(this.softwareLicense, that.softwareLicense) && Objects.equal(this.operatingSystemReferenceCode, that.operatingSystemReferenceCode) && Objects.equal(this.passwords, that.passwords);
    }

    public int hashCode() {
        return Objects.hashCode(this.id, this.softwareLicense, this.operatingSystemReferenceCode, this.passwords);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("id", this.id).add("softwareLicense", this.softwareLicense).add("operatingSystemReferenceCode", this.operatingSystemReferenceCode).add("passwords", this.passwords).toString();
    }

    public static class Builder {
        protected String id;
        protected SoftwareLicense softwareLicense;
        protected String operatingSystemReferenceCode;
        protected Set<Password> passwords = ImmutableSet.of();

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder softwareLicense(SoftwareLicense softwareLicense) {
            this.softwareLicense = softwareLicense;
            return this;
        }

        public Builder operatingSystemReferenceCode(String operatingSystemReferenceCode) {
            this.operatingSystemReferenceCode = operatingSystemReferenceCode;
            return this;
        }

        public Builder passwords(Set<Password> passwords) {
            this.passwords = ImmutableSet.copyOf((Collection)Preconditions.checkNotNull(passwords, "passwords"));
            return this;
        }

        public Builder passwords(Password ... in) {
            return this.passwords(ImmutableSet.copyOf(in));
        }

        public OperatingSystem build() {
            return new OperatingSystem(this.id, this.softwareLicense, this.operatingSystemReferenceCode, this.passwords);
        }

        public Builder fromOperatingSystem(OperatingSystem in) {
            return this.id(in.getId()).passwords(in.getPasswords());
        }
    }
}

