/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rackspace.cloudloadbalancers.v1.loadbalancer.strategy;

import com.google.common.base.Preconditions;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.loadbalancer.domain.LoadBalancerMetadata;
import org.jclouds.loadbalancer.strategy.DestroyLoadBalancerStrategy;
import org.jclouds.loadbalancer.strategy.GetLoadBalancerMetadataStrategy;
import org.jclouds.logging.Logger;
import org.jclouds.rackspace.cloudloadbalancers.v1.CloudLoadBalancersApi;

@Singleton
public class CloudLoadBalancersDestroyLoadBalancerStrategy
implements DestroyLoadBalancerStrategy {
    @Resource
    @Named(value="jclouds.loadbalancer")
    protected Logger logger = Logger.NULL;
    private final CloudLoadBalancersApi client;
    private final GetLoadBalancerMetadataStrategy getLoadBalancer;

    @Inject
    protected CloudLoadBalancersDestroyLoadBalancerStrategy(CloudLoadBalancersApi client, GetLoadBalancerMetadataStrategy getLoadBalancer) {
        this.client = Preconditions.checkNotNull(client, "client");
        this.getLoadBalancer = Preconditions.checkNotNull(getLoadBalancer, "getLoadBalancer");
    }

    @Override
    public LoadBalancerMetadata destroyLoadBalancer(String id) {
        String[] parts = Preconditions.checkNotNull(id, "id").split("/");
        String region = parts[0];
        int lbId = Integer.parseInt(parts[1]);
        this.client.getLoadBalancerApi(region).delete(lbId);
        return this.getLoadBalancer.getLoadBalancer(id);
    }
}

