/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rackspace.clouddns.v1.domain;

import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.beans.ConstructorProperties;

public class Job<T> {
    private final String id;
    private final Status status;
    private final Optional<Error> error;
    private final Optional<T> resource;

    private Job(String id, Status status, Optional<Error> error, Optional<T> resource) {
        this.id = id;
        this.status = status;
        this.error = error;
        this.resource = resource;
    }

    public String getId() {
        return this.id;
    }

    public Status getStatus() {
        return this.status;
    }

    public Optional<Error> getError() {
        return this.error;
    }

    public Optional<T> getResource() {
        return this.resource;
    }

    public static <T> Builder<T> builder() {
        return new Builder();
    }

    public static final class Error {
        private final int code;
        private final String message;
        private final String details;

        @ConstructorProperties(value={"code", "message", "details"})
        protected Error(int code, String message, String details) {
            this.code = code;
            this.message = message;
            this.details = details;
        }

        public int getCode() {
            return this.code;
        }

        public String getMessage() {
            return this.message;
        }

        public String getDetails() {
            return this.details;
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("code", this.code).add("message", this.message).add("details", this.details).toString();
        }
    }

    public static class Builder<T> {
        private String id;
        private Status status;
        private Optional<Error> error = Optional.absent();
        private Optional<T> resource = Optional.absent();

        public Builder<T> id(String id) {
            this.id = id;
            return this;
        }

        public Builder<T> status(Status status) {
            this.status = status;
            return this;
        }

        public Builder<T> error(Error error) {
            this.error = Optional.fromNullable(error);
            return this;
        }

        public Builder<T> resource(T resource) {
            this.resource = Optional.fromNullable(resource);
            return this;
        }

        public Job<T> build() {
            return new Job(this.id, this.status, this.error, this.resource);
        }
    }

    public static enum Status {
        INITIALIZED,
        RUNNING,
        COMPLETED,
        ERROR,
        UNRECOGNIZED;


        public static Status fromValue(String status) {
            try {
                return Status.valueOf(Preconditions.checkNotNull(status, "status").toUpperCase());
            }
            catch (IllegalArgumentException e) {
                return UNRECOGNIZED;
            }
        }
    }
}

