/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rackspace.clouddns.v1.domain;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import org.jclouds.rackspace.clouddns.v1.domain.CreateSubdomain;
import org.jclouds.rackspace.clouddns.v1.domain.Record;

public class CreateDomain {
    private final String name;
    private final String emailAddress;
    private final Optional<Integer> ttl;
    private final Optional<String> comment;
    private final ImmutableMap<String, Iterable<CreateSubdomain>> subdomains;
    private final ImmutableMap<String, Iterable<Record>> recordsList;

    private CreateDomain(String name, String email, Optional<Integer> ttl, Optional<String> comment, ImmutableMap<String, Iterable<CreateSubdomain>> subdomains, ImmutableMap<String, Iterable<Record>> recordsList) {
        this.name = Preconditions.checkNotNull(name, "name required");
        this.emailAddress = Preconditions.checkNotNull(email, "email required");
        this.ttl = ttl;
        this.comment = comment;
        this.subdomains = subdomains != null ? subdomains : ImmutableMap.of();
        this.recordsList = recordsList != null ? recordsList : ImmutableMap.of();
    }

    public String getName() {
        return this.name;
    }

    public String getEmail() {
        return this.emailAddress;
    }

    public Optional<Integer> getTTL() {
        return this.ttl;
    }

    public Optional<String> getComment() {
        return this.comment;
    }

    public Iterable<CreateSubdomain> getSubdomains() {
        return this.subdomains.get("domains");
    }

    public Iterable<Record> getRecords() {
        return this.recordsList.get("records");
    }

    public int hashCode() {
        return Objects.hashCode(this.name);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        CreateDomain that = (CreateDomain)CreateDomain.class.cast(obj);
        return Objects.equal(this.name, that.name);
    }

    protected MoreObjects.ToStringHelper string() {
        return MoreObjects.toStringHelper(this).omitNullValues().add("name", this.name).add("email", this.emailAddress).add("ttl", this.ttl.orNull()).add("comment", this.comment.orNull()).add("subdomains", this.subdomains).add("records", this.recordsList);
    }

    public String toString() {
        return this.string().toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static class Builder {
        private String name;
        private String emailAddress;
        private Optional<Integer> ttl = Optional.absent();
        private Optional<String> comment = Optional.absent();
        private ImmutableMap<String, Iterable<CreateSubdomain>> subdomains;
        private ImmutableMap<String, Iterable<Record>> records;

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder email(String email) {
            this.emailAddress = email;
            return this;
        }

        public Builder ttl(Integer ttl) {
            this.ttl = Optional.fromNullable(ttl);
            return this;
        }

        public Builder comment(String comment) {
            this.comment = Optional.fromNullable(comment);
            return this;
        }

        public Builder subdomains(Iterable<CreateSubdomain> subdomains) {
            if (subdomains != null) {
                this.subdomains = ImmutableMap.of("domains", subdomains);
            }
            return this;
        }

        public Builder records(Iterable<Record> records) {
            if (records != null) {
                this.records = ImmutableMap.of("records", records);
            }
            return this;
        }

        public CreateDomain build() {
            return new CreateDomain(this.name, this.emailAddress, this.ttl, this.comment, this.subdomains, this.records);
        }

        public Builder from(CreateDomain in) {
            return this.name(in.getName()).email(in.getEmail()).ttl(in.getTTL().orNull()).comment(in.getComment().orNull()).subdomains(in.getSubdomains()).records(in.getRecords());
        }
    }
}

