/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.handlers;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import com.google.common.base.Strings;
import com.google.common.base.Ticker;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import javax.annotation.Resource;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.date.DateCodecFactory;
import org.jclouds.fallbacks.HeaderToRetryAfterException;
import org.jclouds.http.HttpCommand;
import org.jclouds.http.HttpErrorHandler;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.HttpResponseException;
import org.jclouds.http.HttpUtils;
import org.jclouds.logging.Logger;
import org.jclouds.openstack.nova.v2_0.functions.OverLimitParser;
import org.jclouds.rest.AuthorizationException;
import org.jclouds.rest.InsufficientResourcesException;
import org.jclouds.rest.ResourceNotFoundException;
import org.jclouds.rest.RetryAfterException;

@Singleton
public class NovaErrorHandler
implements HttpErrorHandler {
    @Inject(optional=true)
    @Named(value="jclouds.wire.log.sensitive")
    private boolean logSensitiveInformation = false;
    @Resource
    protected Logger logger = Logger.NULL;
    protected final HeaderToRetryAfterException retryAfterParser;
    protected final OverLimitParser overLimitParser;

    protected NovaErrorHandler(HeaderToRetryAfterException retryAfterParser, OverLimitParser overLimitParser) {
        this.retryAfterParser = Preconditions.checkNotNull(retryAfterParser, "retryAfterParser");
        this.overLimitParser = Preconditions.checkNotNull(overLimitParser, "overLimitParser");
    }

    @javax.inject.Inject
    public NovaErrorHandler(DateCodecFactory factory, OverLimitParser overLimitParser) {
        this(HeaderToRetryAfterException.create(Ticker.systemTicker(), factory.iso8601Seconds()), overLimitParser);
    }

    @Override
    public void handleError(HttpCommand command, HttpResponse response) {
        byte[] data = HttpUtils.closeClientButKeepContentStream(response);
        String content = data != null ? Strings.emptyToNull(new String(data)) : null;
        Exception exception = content != null ? new HttpResponseException(command, response, content) : new HttpResponseException(command, response, this.logSensitiveInformation);
        String requestLine = command.getCurrentRequest().getRequestLine();
        String message = content != null ? content : String.format("%s -> %s", requestLine, response.getStatusLine());
        switch (response.getStatusCode()) {
            case 400: {
                if (message.indexOf("quota exceeded") != -1) {
                    exception = new InsufficientResourcesException(message, exception);
                    break;
                }
                if (message.indexOf("has no fixed_ips") != -1) {
                    exception = new IllegalStateException(message, exception);
                    break;
                }
                if (message.indexOf("already exists") == -1) break;
                exception = new IllegalStateException(message, exception);
                break;
            }
            case 401: 
            case 403: {
                exception = new AuthorizationException(message, exception);
                break;
            }
            case 404: {
                if (command.getCurrentRequest().getMethod().equals("DELETE")) break;
                exception = new ResourceNotFoundException(message, exception);
                break;
            }
            case 500: {
                if (!command.getCurrentRequest().getMethod().equals("POST") || message.indexOf("The server has either erred or is incapable of performing the requested operation.") == -1 || command.getCurrentRequest().getEndpoint().getPath().indexOf("os-floating-ips") == -1) break;
                exception = new InsufficientResourcesException(message, exception);
                break;
            }
            case 413: {
                exception = content == null ? new InsufficientResourcesException(message, exception) : this.parseAndBuildRetryException(content, message, exception);
            }
        }
        command.setException(exception);
    }

    private Exception parseAndBuildRetryException(String json, String message, Exception exception) {
        ImmutableSet<String> retryFields = ImmutableSet.of("retryAfter", "retryAt");
        for (String value : Maps.filterKeys(this.overLimitParser.apply(json), Predicates.in(retryFields)).values()) {
            Optional<RetryAfterException> retryException = this.retryAfterParser.tryCreateRetryAfterException(exception, value);
            if (!retryException.isPresent()) continue;
            return retryException.get();
        }
        return new InsufficientResourcesException(message, exception);
    }
}

