/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.compute.functions;

import com.google.common.base.Function;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.inject.assistedinject.Assisted;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.jclouds.compute.domain.SecurityGroupBuilder;
import org.jclouds.domain.Location;
import org.jclouds.net.domain.IpPermission;
import org.jclouds.net.domain.IpProtocol;
import org.jclouds.openstack.neutron.v2.domain.Rule;
import org.jclouds.openstack.neutron.v2.domain.RuleDirection;
import org.jclouds.openstack.neutron.v2.domain.SecurityGroup;

public class NeutronSecurityGroupToSecurityGroup
implements Function<SecurityGroup, org.jclouds.compute.domain.SecurityGroup> {
    private final Location location;

    @Inject
    public NeutronSecurityGroupToSecurityGroup(@Assisted Location location) {
        this.location = location;
    }

    @Override
    public org.jclouds.compute.domain.SecurityGroup apply(@Nullable SecurityGroup group) {
        SecurityGroupBuilder builder = new SecurityGroupBuilder();
        builder.providerId(group.getId());
        builder.ownerId(group.getTenantId());
        builder.name(group.getName());
        final String regionId = this.location.getId();
        builder.location(this.location);
        builder.id(regionId + "/" + group.getId());
        if (group.getRules() != null) {
            builder.ipPermissions(Iterables.filter(Iterables.transform(group.getRules(), new Function<Rule, IpPermission>(){

                @Override
                public IpPermission apply(Rule from) {
                    if (from.getDirection() == RuleDirection.EGRESS) {
                        return null;
                    }
                    IpPermission.Builder builder = IpPermission.builder();
                    if (from.getProtocol() != null) {
                        builder.ipProtocol(IpProtocol.fromValue(from.getProtocol().name()));
                    } else {
                        builder.ipProtocol(IpProtocol.TCP);
                    }
                    if (from.getPortRangeMin() != null) {
                        builder.fromPort(from.getPortRangeMin());
                    }
                    if (from.getPortRangeMax() != null) {
                        builder.toPort(from.getPortRangeMax());
                    }
                    if (from.getRemoteGroupId() != null) {
                        builder.groupId(regionId + "/" + from.getRemoteGroupId());
                    } else if (from.getRemoteIpPrefix() != null) {
                        builder.cidrBlock(from.getRemoteIpPrefix());
                    }
                    return builder.build();
                }
            }), Predicates.notNull()));
        }
        return builder.build();
    }

    public static interface Factory {
        public NeutronSecurityGroupToSecurityGroup create(Location var1);
    }
}

