/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.xml;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import org.jclouds.aws.util.AWSUtils;
import org.jclouds.date.DateService;
import org.jclouds.ec2.domain.Attachment;
import org.jclouds.ec2.domain.Volume;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.location.Region;
import org.jclouds.location.Zone;
import org.jclouds.rest.internal.GeneratedHttpRequest;
import org.xml.sax.Attributes;

public class CreateVolumeResponseHandler
extends ParseSax.HandlerForGeneratedRequestWithResult<Volume> {
    protected final DateService dateService;
    protected final Supplier<String> defaultRegion;
    protected final Supplier<Map<String, Supplier<Set<String>>>> regionToZonesSupplier;
    protected final Supplier<Set<String>> zonesSupplier;
    protected StringBuilder currentText = new StringBuilder();
    protected String id;
    protected int size;
    protected String snapshotId;
    protected String availabilityZone;
    protected Volume.Status volumeStatus;
    protected Date createTime;
    protected Set<Attachment> attachments = Sets.newLinkedHashSet();
    protected String volumeId;
    protected String instanceId;
    protected String device;
    protected Attachment.Status attachmentStatus;
    protected Date attachTime;
    protected String volumeType;
    protected Integer iops;
    protected boolean encrypted;
    protected boolean inAttachmentSet;
    protected String region;

    @Inject
    protected CreateVolumeResponseHandler(DateService dateService, @Region Supplier<String> defaultRegion, @Zone Supplier<Map<String, Supplier<Set<String>>>> regionToZonesSupplier, @Zone Supplier<Set<String>> zonesSupplier) {
        this.dateService = dateService;
        this.defaultRegion = defaultRegion;
        this.regionToZonesSupplier = regionToZonesSupplier;
        this.zonesSupplier = zonesSupplier;
    }

    @Override
    public Volume getResult() {
        return this.newVolume();
    }

    @Override
    public void startElement(String uri, String name, String qName, Attributes attrs) {
        if (qName.equals("attachmentSet")) {
            this.inAttachmentSet = true;
        }
    }

    @Override
    public void endElement(String uri, String name, String qName) {
        if (qName.equals("volumeId")) {
            if (this.inAttachmentSet) {
                this.volumeId = this.currentText.toString().trim();
            } else {
                this.id = this.currentText.toString().trim();
            }
        } else if (qName.equals("size")) {
            this.size = Integer.parseInt(this.currentText.toString().trim());
        } else if (qName.equals("availabilityZone")) {
            this.availabilityZone = this.currentText.toString().trim();
        } else if (qName.equals("volumeId")) {
            if (this.inAttachmentSet) {
                this.volumeId = this.currentText.toString().trim();
            } else {
                this.id = this.currentText.toString().trim();
            }
        } else if (qName.equals("status")) {
            if (this.inAttachmentSet) {
                this.attachmentStatus = Attachment.Status.fromValue(this.currentText.toString().trim());
            } else {
                this.volumeStatus = Volume.Status.fromValue(this.currentText.toString().trim());
            }
        } else if (qName.equals("createTime")) {
            this.createTime = this.dateService.iso8601DateOrSecondsDateParse(this.currentText.toString().trim());
        } else if (qName.equals("attachmentSet")) {
            this.inAttachmentSet = false;
        } else if (qName.equals("instanceId")) {
            this.instanceId = this.currentText.toString().trim();
        } else if (qName.equals("snapshotId")) {
            this.snapshotId = this.currentText.toString().trim();
            if (this.snapshotId.equals("")) {
                this.snapshotId = null;
            }
        } else if (qName.equals("device")) {
            this.device = this.currentText.toString().trim();
        } else if (qName.equals("attachTime")) {
            this.attachTime = this.dateService.iso8601DateOrSecondsDateParse(this.currentText.toString().trim());
        } else if (qName.equals("volumeType")) {
            this.volumeType = this.currentText.toString().trim();
            if (this.volumeType.equals("")) {
                this.volumeType = null;
            }
        } else if (qName.equals("iops")) {
            this.iops = Integer.parseInt(this.currentText.toString().trim());
        } else if (qName.equals("encrypted")) {
            this.encrypted = Boolean.parseBoolean(this.currentText.toString().trim());
        } else if (qName.equals("item") && this.inAttachmentSet) {
            this.attachments.add(new Attachment(this.region, this.volumeId, this.instanceId, this.device, this.attachmentStatus, this.attachTime));
            this.volumeId = null;
            this.instanceId = null;
            this.device = null;
            this.attachmentStatus = null;
            this.attachTime = null;
        }
        this.currentText.setLength(0);
    }

    private Volume newVolume() {
        Volume volume = new Volume(this.region, this.id, this.size, this.snapshotId, this.availabilityZone, this.volumeStatus, this.createTime, this.volumeType, this.iops, this.encrypted, this.attachments);
        this.id = null;
        this.size = 0;
        this.snapshotId = null;
        this.availabilityZone = null;
        this.volumeStatus = null;
        this.createTime = null;
        this.attachments = Sets.newLinkedHashSet();
        this.volumeType = null;
        this.iops = null;
        this.encrypted = false;
        return volume;
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        this.currentText.append(ch, start, length);
    }

    @Override
    public CreateVolumeResponseHandler setContext(HttpRequest request) {
        super.setContext(request);
        this.region = AWSUtils.findRegionInArgsOrNull(this.getRequest());
        if (this.region == null) {
            Set<String> zones = this.zonesSupplier.get();
            String zone = CreateVolumeResponseHandler.findAvailabilityZoneInArgsOrNull(this.getRequest(), zones);
            if (zone != null) {
                Map regionToZones = Maps.transformValues(this.regionToZonesSupplier.get(), Suppliers.supplierFunction());
                for (Map.Entry entry : regionToZones.entrySet()) {
                    if (!((Set)entry.getValue()).contains(zone)) continue;
                    this.region = entry.getKey();
                    break;
                }
                Preconditions.checkNotNull(this.region, "zone %s not in %s", zone, regionToZones);
            } else {
                this.region = this.defaultRegion.get();
            }
        }
        return this;
    }

    public static String findAvailabilityZoneInArgsOrNull(GeneratedHttpRequest gRequest, Set<String> zones) {
        for (Object arg : gRequest.getInvocation().getArgs()) {
            String zone;
            if (!(arg instanceof String) || !zones.contains(zone = (String)arg)) continue;
            return zone;
        }
        return null;
    }
}

