/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudwatch.functions;

import com.google.common.annotations.Beta;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import javax.inject.Inject;
import org.jclouds.cloudwatch.CloudWatchApi;
import org.jclouds.cloudwatch.domain.Metric;
import org.jclouds.cloudwatch.features.MetricApi;
import org.jclouds.cloudwatch.options.ListMetricsOptions;
import org.jclouds.collect.IterableWithMarker;
import org.jclouds.collect.internal.CallerArg0ToPagedIterable;

@Beta
public class MetricsToPagedIterable
extends CallerArg0ToPagedIterable<Metric, MetricsToPagedIterable> {
    private final CloudWatchApi api;

    @Inject
    protected MetricsToPagedIterable(CloudWatchApi api) {
        this.api = Preconditions.checkNotNull(api, "api");
    }

    @Override
    protected Function<Object, IterableWithMarker<Metric>> markerToNextForCallingArg0(final String arg0) {
        final MetricApi metricApi = this.api.getMetricApiForRegion(arg0);
        return new Function<Object, IterableWithMarker<Metric>>(){

            @Override
            public IterableWithMarker<Metric> apply(Object input) {
                return metricApi.list(ListMetricsOptions.Builder.afterMarker(input.toString()));
            }

            public String toString() {
                return "listMetricsInRegion(" + arg0 + ")";
            }
        };
    }
}

