/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.chef.functions;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Supplier;
import com.google.common.base.Throwables;
import com.google.common.cache.CacheLoader;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.net.URI;
import java.security.PrivateKey;
import java.util.Collections;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.chef.config.InstallChef;
import org.jclouds.chef.config.Validator;
import org.jclouds.chef.domain.BootstrapConfig;
import org.jclouds.crypto.Pems;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.location.Provider;
import org.jclouds.scriptbuilder.ExitInsteadOfReturn;
import org.jclouds.scriptbuilder.domain.Statement;
import org.jclouds.scriptbuilder.domain.StatementList;
import org.jclouds.scriptbuilder.domain.Statements;

@Singleton
public class GroupToBootScript {
    private static final Pattern newLinePattern = Pattern.compile("(\\r\\n)|(\\n)");
    private final Supplier<URI> endpoint;
    private final CacheLoader<String, BootstrapConfig> bootstrapConfigForGroup;
    private final Statement installChef;
    private final Optional<String> validatorName;
    private final Optional<PrivateKey> validatorCredential;

    @Inject
    GroupToBootScript(@Provider Supplier<URI> endpoint, CacheLoader<String, BootstrapConfig> bootstrapConfigForGroup, @InstallChef Statement installChef, @Validator Optional<String> validatorName, @Validator Optional<PrivateKey> validatorCredential) {
        this.endpoint = endpoint;
        this.bootstrapConfigForGroup = bootstrapConfigForGroup;
        this.installChef = installChef;
        this.validatorName = validatorName;
        this.validatorCredential = validatorCredential;
    }

    public Statement apply(String group, @Nullable String nodeName) {
        BootstrapConfig config = null;
        try {
            config = this.bootstrapConfigForGroup.load(Preconditions.checkNotNull(group, "group"));
        }
        catch (Exception ex) {
            throw Throwables.propagate(ex);
        }
        String chefConfigDir = "{root}etc{fs}chef";
        String chefBootFile = chefConfigDir + "{fs}first-boot.json";
        ImmutableList.Builder statements = ImmutableList.builder();
        statements.add(new ExitInsteadOfReturn(this.installChef));
        statements.add(Statements.exec("{md} " + chefConfigDir));
        if (config.getSslCAFile() != null) {
            statements.add(Statements.createOrOverwriteFile(chefConfigDir + "{fs}chef-server.crt", Splitter.on(newLinePattern).split(config.getSslCAFile())));
        }
        statements.add(this.createClientRbFile(chefConfigDir + "{fs}client.rb", group, nodeName, config));
        statements.add(Statements.createOrOverwriteFile(chefConfigDir + "{fs}validation.pem", Splitter.on(newLinePattern).split(Pems.pem(this.validatorCredential.get()))));
        statements.add(this.createAttributesFile(chefBootFile, config));
        statements.add(Statements.exec("chef-client -j " + chefBootFile));
        return new StatementList(statements.build());
    }

    private Statement createClientRbFile(String clientRbFile, String group, String nodeName, BootstrapConfig config) {
        ImmutableList.Builder<String> clientRb = ImmutableList.builder();
        clientRb.add((Object)"require 'rubygems'");
        clientRb.add((Object)"require 'ohai'");
        clientRb.add((Object)"o = Ohai::System.new");
        clientRb.add((Object)"o.all_plugins");
        clientRb.add((Object)("node_name \"" + (nodeName != null ? nodeName + "\"" : group + "-\" + o[:ipaddress]")));
        clientRb.add((Object)"log_level :info");
        clientRb.add((Object)"log_location STDOUT");
        clientRb.add((Object)String.format("validation_client_name \"%s\"", this.validatorName.get()));
        clientRb.add((Object)String.format("chef_server_url \"%s\"", this.endpoint.get()));
        this.addIfPresent(clientRb, "environment", config.getEnvironment());
        if (config.getSslCAFile() != null) {
            this.addIfPresent(clientRb, "ssl_ca_file", "/etc/chef/chef-server.crt");
        }
        this.addIfPresent(clientRb, "ssl_ca_path", config.getSslCAPath());
        this.addIfPresent(clientRb, "ssl_verify_mode", (Object)config.getSslVerifyMode());
        this.addIfPresent(clientRb, "verify_api_cert", config.getVerifyApiCert());
        return Statements.createOrOverwriteFile(clientRbFile, clientRb.build());
    }

    private Statement createAttributesFile(String chefBootFile, BootstrapConfig config) {
        String runlist = Joiner.on(',').join(Iterables.transform(config.getRunList(), new Function<String, String>(){

            @Override
            public String apply(String input) {
                return "\"" + input + "\"";
            }
        }));
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (config.getAttributes() != null) {
            String attributes = config.getAttributes().toString();
            sb.append(attributes.trim().substring(1, attributes.length() - 1));
            sb.append(",");
        }
        sb.append("\"run_list\":[").append(runlist).append("]");
        sb.append("}");
        return Statements.createOrOverwriteFile(chefBootFile, Collections.singleton(sb.toString()));
    }

    private void addIfPresent(ImmutableList.Builder<String> lines, String key, Object value) {
        if (value != null) {
            lines.add((Object)String.format("%s %s", key, value instanceof String ? "\"" + value + "\"" : value.toString()));
        }
    }
}

