/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azurecompute.arm.domain;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.jclouds.azurecompute.arm.domain.AutoValue_VirtualMachine;
import org.jclouds.azurecompute.arm.domain.Plan;
import org.jclouds.azurecompute.arm.domain.VirtualMachineProperties;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.json.SerializedNames;

public abstract class VirtualMachine {
    public abstract String id();

    public abstract String name();

    public abstract String type();

    public abstract String location();

    @Nullable
    public abstract Map<String, String> tags();

    public abstract VirtualMachineProperties properties();

    @Nullable
    public abstract Plan plan();

    @SerializedNames(value={"id", "name", "type", "location", "tags", "properties", "plan"})
    public static VirtualMachine create(String id, String name, String type, String location, @Nullable Map<String, String> tags, VirtualMachineProperties properties, @Nullable Plan plan) {
        return VirtualMachine.builder().id(id).name(name).type(type).location(location).tags(tags).properties(properties).plan(plan).build();
    }

    public abstract Builder toBuilder();

    public static Builder builder() {
        return new AutoValue_VirtualMachine.Builder();
    }

    public static abstract class Builder {
        public abstract Builder id(String var1);

        public abstract Builder name(String var1);

        public abstract Builder type(String var1);

        public abstract Builder location(String var1);

        public abstract Builder tags(Map<String, String> var1);

        public abstract Builder properties(VirtualMachineProperties var1);

        public abstract Builder plan(Plan var1);

        abstract Map<String, String> tags();

        abstract VirtualMachine autoBuild();

        public VirtualMachine build() {
            this.tags(this.tags() != null ? ImmutableMap.copyOf(this.tags()) : null);
            return this.autoBuild();
        }
    }
}

